/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.master.assignment;

import io.hops.hudi.org.apache.hadoop.hbase.ServerName;
import io.hops.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import io.hops.hudi.org.apache.hadoop.hbase.exceptions.UnexpectedStateException;
import io.hops.hudi.org.apache.hadoop.hbase.master.RegionState;
import io.hops.hudi.org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import io.hops.hudi.org.apache.hadoop.hbase.master.assignment.RegionRemoteProcedureBase;
import io.hops.hudi.org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import io.hops.hudi.org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import io.hops.hudi.org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import io.hops.hudi.org.apache.hadoop.hbase.master.procedure.RSProcedureDispatcher;
import io.hops.hudi.org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import io.hops.hudi.org.apache.hadoop.hbase.procedure2.ProcedureMetrics;
import io.hops.hudi.org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import io.hops.hudi.org.apache.hadoop.hbase.procedure2.RemoteProcedureDispatcher;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.protobuf.Message;
import java.io.IOException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class OpenRegionProcedure
extends RegionRemoteProcedureBase {
    private static final Logger LOG = LoggerFactory.getLogger(OpenRegionProcedure.class);

    public OpenRegionProcedure() {
    }

    public OpenRegionProcedure(TransitRegionStateProcedure parent, RegionInfo region, ServerName targetServer) {
        super(parent, region, targetServer);
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.REGION_ASSIGN;
    }

    @Override
    public RemoteProcedureDispatcher.RemoteOperation newRemoteOperation() {
        return new RSProcedureDispatcher.RegionOpenOperation(this, this.region, this.getProcId());
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        serializer.serialize((Message)MasterProcedureProtos.OpenRegionProcedureStateData.getDefaultInstance());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        serializer.deserialize(MasterProcedureProtos.OpenRegionProcedureStateData.class);
    }

    protected ProcedureMetrics getProcedureMetrics(MasterProcedureEnv env) {
        return env.getAssignmentManager().getAssignmentManagerMetrics().getOpenProcMetrics();
    }

    private void regionOpenedWithoutPersistingToMeta(AssignmentManager am, RegionStateNode regionNode, RegionServerStatusProtos.RegionStateTransition.TransitionCode transitionCode, long openSeqNum) throws IOException {
        if (openSeqNum < regionNode.getOpenSeqNum()) {
            LOG.warn("Received report {} transition from {} for {}, pid={} but the new openSeqNum {} is less than the current one {}, ignoring...", new Object[]{transitionCode, this.targetServer, regionNode, this.getProcId(), openSeqNum, regionNode.getOpenSeqNum()});
        } else {
            regionNode.setOpenSeqNum(openSeqNum);
        }
        am.regionOpenedWithoutPersistingToMeta(regionNode);
    }

    @Override
    protected void checkTransition(RegionStateNode regionNode, RegionServerStatusProtos.RegionStateTransition.TransitionCode transitionCode, long openSeqNum) throws UnexpectedStateException {
        switch (transitionCode) {
            case OPENED: {
                if (openSeqNum >= 0L) break;
                throw new UnexpectedStateException("Received report unexpected " + RegionServerStatusProtos.RegionStateTransition.TransitionCode.OPENED + " transition openSeqNum=" + openSeqNum + ", " + regionNode + ", proc=" + this);
            }
            case FAILED_OPEN: {
                break;
            }
            default: {
                throw new UnexpectedStateException("Received report unexpected " + transitionCode + " transition, " + regionNode.toShortString() + ", " + this + ", expected OPENED or FAILED_OPEN.");
            }
        }
    }

    @Override
    protected void updateTransitionWithoutPersistingToMeta(MasterProcedureEnv env, RegionStateNode regionNode, RegionServerStatusProtos.RegionStateTransition.TransitionCode transitionCode, long openSeqNum) throws IOException {
        if (transitionCode == RegionServerStatusProtos.RegionStateTransition.TransitionCode.OPENED) {
            this.regionOpenedWithoutPersistingToMeta(env.getAssignmentManager(), regionNode, transitionCode, openSeqNum);
        } else {
            assert (transitionCode == RegionServerStatusProtos.RegionStateTransition.TransitionCode.FAILED_OPEN);
            env.getAssignmentManager().regionFailedOpen(regionNode, false);
        }
    }

    @Override
    protected void restoreSucceedState(AssignmentManager am, RegionStateNode regionNode, long openSeqNum) throws IOException {
        if (regionNode.getState() == RegionState.State.OPEN) {
            return;
        }
        this.regionOpenedWithoutPersistingToMeta(am, regionNode, RegionServerStatusProtos.RegionStateTransition.TransitionCode.OPENED, openSeqNum);
    }
}

