/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.master.balancer;

import com.google.errorprone.annotations.RestrictedApi;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import io.hops.hudi.org.apache.hadoop.hbase.ClusterMetrics;
import io.hops.hudi.org.apache.hadoop.hbase.RegionMetrics;
import io.hops.hudi.org.apache.hadoop.hbase.ServerName;
import io.hops.hudi.org.apache.hadoop.hbase.TableName;
import io.hops.hudi.org.apache.hadoop.hbase.client.BalancerDecision;
import io.hops.hudi.org.apache.hadoop.hbase.client.BalancerRejection;
import io.hops.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import io.hops.hudi.org.apache.hadoop.hbase.master.RegionPlan;
import io.hops.hudi.org.apache.hadoop.hbase.master.balancer.BalancerRegionLoad;
import io.hops.hudi.org.apache.hadoop.hbase.master.balancer.BaseLoadBalancer;
import io.hops.hudi.org.apache.hadoop.hbase.master.balancer.CandidateGenerator;
import io.hops.hudi.org.apache.hadoop.hbase.master.balancer.ClusterLoadState;
import io.hops.hudi.org.apache.hadoop.hbase.master.balancer.DoubleArrayCost;
import io.hops.hudi.org.apache.hadoop.hbase.master.balancer.LoadCandidateGenerator;
import io.hops.hudi.org.apache.hadoop.hbase.master.balancer.LocalityBasedCandidateGenerator;
import io.hops.hudi.org.apache.hadoop.hbase.master.balancer.MetricsStochasticBalancer;
import io.hops.hudi.org.apache.hadoop.hbase.master.balancer.RegionLocationFinder;
import io.hops.hudi.org.apache.hadoop.hbase.master.balancer.RegionReplicaCandidateGenerator;
import io.hops.hudi.org.apache.hadoop.hbase.namequeues.BalancerDecisionDetails;
import io.hops.hudi.org.apache.hadoop.hbase.namequeues.BalancerRejectionDetails;
import io.hops.hudi.org.apache.hadoop.hbase.namequeues.NamedQueueRecorder;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.compactions.OffPeakHours;
import io.hops.hudi.org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import io.hops.hudi.org.apache.hadoop.hbase.util.ReflectionUtils;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
@SuppressWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="Complaint is about costFunctions not being synchronized; not end of the world")
public class StochasticLoadBalancer
extends BaseLoadBalancer {
    protected static final String STEPS_PER_REGION_KEY = "hbase.master.balancer.stochastic.stepsPerRegion";
    protected static final String MAX_STEPS_KEY = "hbase.master.balancer.stochastic.maxSteps";
    protected static final String RUN_MAX_STEPS_KEY = "hbase.master.balancer.stochastic.runMaxSteps";
    protected static final String MAX_RUNNING_TIME_KEY = "hbase.master.balancer.stochastic.maxRunningTime";
    protected static final String KEEP_REGION_LOADS = "hbase.master.balancer.stochastic.numRegionLoadsToRemember";
    private static final String TABLE_FUNCTION_SEP = "_";
    protected static final String MIN_COST_NEED_BALANCE_KEY = "hbase.master.balancer.stochastic.minCostNeedBalance";
    protected static final String COST_FUNCTIONS_COST_FUNCTIONS_KEY = "hbase.master.balancer.stochastic.additionalCostFunctions";
    protected static final Random RANDOM = new Random(System.currentTimeMillis());
    private static final Logger LOG = LoggerFactory.getLogger(StochasticLoadBalancer.class);
    public static final double COST_EPSILON = 1.0E-4;
    Map<String, Deque<BalancerRegionLoad>> loads = new HashMap<String, Deque<BalancerRegionLoad>>();
    private int maxSteps = 1000000;
    private boolean runMaxSteps = false;
    private int stepsPerRegion = 800;
    private long maxRunningTime = 30000L;
    private int numRegionLoadsToRemember = 15;
    private float minCostNeedBalance = 0.025f;
    private boolean isBalancerDecisionRecording = false;
    private boolean isBalancerRejectionRecording = false;
    protected List<CandidateGenerator> candidateGenerators;
    private double[] weightsOfGenerators;
    private List<CostFunction> costFunctions;
    private float sumMultiplier;
    private double curOverallCost = 0.0;
    private double[] tempFunctionCosts;
    private double[] curFunctionCosts;
    private LocalityBasedCandidateGenerator localityCandidateGenerator;
    private ServerLocalityCostFunction localityCost;
    private RackLocalityCostFunction rackLocalityCost;
    private RegionReplicaHostCostFunction regionReplicaHostCostFunction;
    private RegionReplicaRackCostFunction regionReplicaRackCostFunction;
    NamedQueueRecorder namedQueueRecorder;

    public StochasticLoadBalancer() {
        super(new MetricsStochasticBalancer());
    }

    @Override
    public void onConfigurationChange(Configuration conf) {
        this.setConf(conf);
    }

    @Override
    public synchronized void setConf(Configuration conf) {
        super.setConf(conf);
        this.maxSteps = conf.getInt(MAX_STEPS_KEY, this.maxSteps);
        this.stepsPerRegion = conf.getInt(STEPS_PER_REGION_KEY, this.stepsPerRegion);
        this.maxRunningTime = conf.getLong(MAX_RUNNING_TIME_KEY, this.maxRunningTime);
        this.runMaxSteps = conf.getBoolean(RUN_MAX_STEPS_KEY, this.runMaxSteps);
        this.numRegionLoadsToRemember = conf.getInt(KEEP_REGION_LOADS, this.numRegionLoadsToRemember);
        this.minCostNeedBalance = conf.getFloat(MIN_COST_NEED_BALANCE_KEY, this.minCostNeedBalance);
        if (this.localityCandidateGenerator == null) {
            this.localityCandidateGenerator = new LocalityBasedCandidateGenerator();
        }
        this.localityCost = new ServerLocalityCostFunction(conf);
        this.rackLocalityCost = new RackLocalityCostFunction(conf);
        if (this.candidateGenerators == null) {
            this.candidateGenerators = Lists.newArrayList();
            this.candidateGenerators.add(GeneratorType.RANDOM.ordinal(), new RandomCandidateGenerator());
            this.candidateGenerators.add(GeneratorType.LOAD.ordinal(), new LoadCandidateGenerator());
            this.candidateGenerators.add(GeneratorType.LOCALITY.ordinal(), this.localityCandidateGenerator);
            this.candidateGenerators.add(GeneratorType.RACK.ordinal(), new RegionReplicaRackCandidateGenerator());
        }
        this.regionReplicaHostCostFunction = new RegionReplicaHostCostFunction(conf);
        this.regionReplicaRackCostFunction = new RegionReplicaRackCostFunction(conf);
        this.costFunctions = new ArrayList<CostFunction>();
        this.addCostFunction(new RegionCountSkewCostFunction(conf));
        this.addCostFunction(new PrimaryRegionCountSkewCostFunction(conf));
        this.addCostFunction(new MoveCostFunction(conf));
        this.addCostFunction(this.localityCost);
        this.addCostFunction(this.rackLocalityCost);
        this.addCostFunction(new TableSkewCostFunction(conf));
        this.addCostFunction(this.regionReplicaHostCostFunction);
        this.addCostFunction(this.regionReplicaRackCostFunction);
        this.addCostFunction(new ReadRequestCostFunction(conf));
        this.addCostFunction(new WriteRequestCostFunction(conf));
        this.addCostFunction(new MemStoreSizeCostFunction(conf));
        this.addCostFunction(new StoreFileCostFunction(conf));
        this.loadCustomCostFunctions(conf);
        this.curFunctionCosts = new double[this.costFunctions.size()];
        this.tempFunctionCosts = new double[this.costFunctions.size()];
        this.isBalancerDecisionRecording = this.getConf().getBoolean("hbase.master.balancer.decision.buffer.enabled", false);
        this.isBalancerRejectionRecording = this.getConf().getBoolean("hbase.master.balancer.rejection.buffer.enabled", false);
        if (this.namedQueueRecorder == null && (this.isBalancerDecisionRecording || this.isBalancerRejectionRecording)) {
            this.namedQueueRecorder = NamedQueueRecorder.getInstance(this.getConf());
        }
        LOG.info("Loaded config; maxSteps=" + this.maxSteps + ", runMaxSteps=" + this.runMaxSteps + ", stepsPerRegion=" + this.stepsPerRegion + ", maxRunningTime=" + this.maxRunningTime + ", isByTable=" + this.isByTable + ", CostFunctions=" + Arrays.toString(this.getCostFunctionNames()) + " , sum of multiplier of cost functions = " + this.sumMultiplier + " etc.");
    }

    private void loadCustomCostFunctions(Configuration conf) {
        String[] functionsNames = conf.getStrings(COST_FUNCTIONS_COST_FUNCTIONS_KEY);
        if (null == functionsNames) {
            return;
        }
        this.costFunctions.addAll(Arrays.stream(functionsNames).map(c -> {
            Class<CostFunction> klass = null;
            try {
                klass = Class.forName(c).asSubclass(CostFunction.class);
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Cannot load class " + c + "': " + e.getMessage());
            }
            if (null == klass) {
                return null;
            }
            CostFunction reflected = ReflectionUtils.newInstance(klass, conf);
            LOG.info("Successfully loaded custom CostFunction '" + reflected.getClass().getSimpleName() + "'");
            return reflected;
        }).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    protected void setCandidateGenerators(List<CandidateGenerator> customCandidateGenerators) {
        this.candidateGenerators = customCandidateGenerators;
    }

    public List<CandidateGenerator> getCandidateGenerators() {
        return this.candidateGenerators;
    }

    @Override
    protected void setSlop(Configuration conf) {
        this.slop = conf.getFloat("hbase.regions.slop", 0.001f);
    }

    @Override
    public synchronized void setClusterMetrics(ClusterMetrics st) {
        super.setClusterMetrics(st);
        this.updateRegionLoad();
        try {
            int tablesCount = this.isByTable ? this.services.getTableDescriptors().getAll().size() : 1;
            int functionsCount = this.getCostFunctionNames().length;
            this.updateMetricsSize(tablesCount * (functionsCount + 1));
        }
        catch (Exception e) {
            LOG.error("failed to get the size of all tables", (Throwable)e);
        }
    }

    public void updateMetricsSize(int size) {
        if (this.metricsBalancer instanceof MetricsStochasticBalancer) {
            ((MetricsStochasticBalancer)this.metricsBalancer).updateMetricsSize(size);
        }
    }

    @Override
    protected synchronized boolean areSomeRegionReplicasColocated(BaseLoadBalancer.Cluster c) {
        this.regionReplicaHostCostFunction.init(c);
        if (Math.abs(this.regionReplicaHostCostFunction.cost()) > 1.0E-4) {
            return true;
        }
        return Math.abs(this.regionReplicaRackCostFunction.cost()) > 1.0E-4;
    }

    @Override
    protected boolean needsBalance(TableName tableName, BaseLoadBalancer.Cluster cluster) {
        boolean balanced;
        ClusterLoadState cs = new ClusterLoadState(cluster.clusterState);
        if (cs.getNumServers() < 2) {
            LOG.info("Not running balancer because only " + cs.getNumServers() + " active regionserver(s)");
            this.sendRejectionReasonToRingBuffer("The number of RegionServers " + cs.getNumServers() + " < MIN_SERVER_BALANCE(" + 2 + ")", null);
            return false;
        }
        if (this.areSomeRegionReplicasColocated(cluster)) {
            LOG.info("Running balancer because at least one server hosts replicas of the same region. function cost={}", (Object)this.functionCost());
            return true;
        }
        if (this.idleRegionServerExist(cluster)) {
            LOG.info("Running balancer because cluster has idle server(s). function cost={}", (Object)this.functionCost());
            return true;
        }
        double total = 0.0;
        for (CostFunction c : this.costFunctions) {
            if (!c.isNeeded()) {
                LOG.trace("{} not needed", (Object)c.getClass().getSimpleName());
                continue;
            }
            total += c.cost() * (double)c.getMultiplier();
        }
        boolean bl = balanced = total / (double)this.sumMultiplier < (double)this.minCostNeedBalance;
        if (balanced) {
            if (this.isBalancerRejectionRecording) {
                String reason = "";
                if (total <= 0.0) {
                    reason = "(cost1*multiplier1)+(cost2*multiplier2)+...+(costn*multipliern) = " + total + " <= 0";
                } else if (this.sumMultiplier <= 0.0f) {
                    reason = "sumMultiplier = " + this.sumMultiplier + " <= 0";
                } else if (total / (double)this.sumMultiplier < (double)this.minCostNeedBalance) {
                    reason = "[(cost1*multiplier1)+(cost2*multiplier2)+...+(costn*multipliern)]/sumMultiplier = " + total / (double)this.sumMultiplier + " <= minCostNeedBalance(" + this.minCostNeedBalance + ")";
                }
                this.sendRejectionReasonToRingBuffer(reason, this.costFunctions);
            }
            LOG.info("{} - skipping load balancing because weighted average imbalance={} <= threshold({}). If you want more aggressive balancing, either lower hbase.master.balancer.stochastic.minCostNeedBalance from {} or increase the relative multiplier(s) of the specific cost function(s). functionCost={}", new Object[]{this.isByTable ? "Table specific (" + tableName + ")" : "Cluster wide", total / (double)this.sumMultiplier, Float.valueOf(this.minCostNeedBalance), Float.valueOf(this.minCostNeedBalance), this.functionCost()});
        } else {
            LOG.info("{} - Calculating plan. may take up to {}ms to complete.", (Object)(this.isByTable ? "Table specific (" + tableName + ")" : "Cluster wide"), (Object)this.maxRunningTime);
        }
        return !balanced;
    }

    @InterfaceAudience.Private
    BaseLoadBalancer.Cluster.Action nextAction(BaseLoadBalancer.Cluster cluster) {
        return this.getRandomGenerator().generate(cluster);
    }

    protected CandidateGenerator getRandomGenerator() {
        int i;
        double sum = 0.0;
        for (i = 0; i < this.weightsOfGenerators.length; ++i) {
            this.weightsOfGenerators[i] = sum += this.weightsOfGenerators[i];
        }
        if (sum == 0.0) {
            return this.candidateGenerators.get(0);
        }
        i = 0;
        while (i < this.weightsOfGenerators.length) {
            int n = i++;
            this.weightsOfGenerators[n] = this.weightsOfGenerators[n] / sum;
        }
        double rand = RANDOM.nextDouble();
        for (int i2 = 0; i2 < this.weightsOfGenerators.length; ++i2) {
            if (!(rand <= this.weightsOfGenerators[i2])) continue;
            return this.candidateGenerators.get(i2);
        }
        return this.candidateGenerators.get(this.candidateGenerators.size() - 1);
    }

    @Override
    public synchronized List<RegionPlan> balanceTable(TableName tableName, Map<ServerName, List<RegionInfo>> loadOfOneTable) {
        long step;
        long computedMaxSteps;
        double currentCost;
        List<RegionPlan> plans = this.balanceMasterRegions(loadOfOneTable);
        if (plans != null || loadOfOneTable == null || loadOfOneTable.size() <= 1) {
            return plans;
        }
        if (this.masterServerName != null && loadOfOneTable.containsKey(this.masterServerName)) {
            if (loadOfOneTable.size() <= 2) {
                return null;
            }
            loadOfOneTable = new HashMap<ServerName, List<RegionInfo>>(loadOfOneTable);
            loadOfOneTable.remove(this.masterServerName);
        }
        RegionLocationFinder finder = null;
        if (this.localityCost != null && this.localityCost.getMultiplier() > 0.0f || this.rackLocalityCost != null && this.rackLocalityCost.getMultiplier() > 0.0f) {
            finder = this.regionFinder;
        }
        BaseLoadBalancer.Cluster cluster = new BaseLoadBalancer.Cluster(loadOfOneTable, this.loads, finder, this.rackManager);
        long startTime = EnvironmentEdgeManager.currentTime();
        this.initCosts(cluster);
        this.sumMultiplier = 0.0f;
        for (CostFunction c : this.costFunctions) {
            if (!c.isNeeded()) continue;
            this.sumMultiplier += c.getMultiplier();
        }
        if (this.sumMultiplier <= 0.0f) {
            LOG.error("At least one cost function needs a multiplier > 0. For example, set hbase.master.balancer.stochastic.regionCountCost to a positive value or default");
            return null;
        }
        if (!this.needsBalance(tableName, cluster)) {
            return null;
        }
        this.curOverallCost = currentCost = this.computeCost(cluster, Double.MAX_VALUE);
        System.arraycopy(this.tempFunctionCosts, 0, this.curFunctionCosts, 0, this.curFunctionCosts.length);
        double initCost = currentCost;
        if (this.runMaxSteps) {
            computedMaxSteps = Math.max((long)this.maxSteps, (long)cluster.numRegions * (long)this.stepsPerRegion * (long)cluster.numServers);
        } else {
            long calculatedMaxSteps = (long)cluster.numRegions * (long)this.stepsPerRegion * (long)cluster.numServers;
            computedMaxSteps = Math.min((long)this.maxSteps, calculatedMaxSteps);
            if (calculatedMaxSteps > (long)this.maxSteps) {
                LOG.warn("calculatedMaxSteps:{} for loadbalancer's stochastic walk is larger than maxSteps:{}. Hence load balancing may not work well. Setting parameter \"hbase.master.balancer.stochastic.runMaxSteps\" to true can overcome this issue.(This config change does not require service restart)", (Object)calculatedMaxSteps, (Object)this.maxSteps);
            }
        }
        LOG.info("Start StochasticLoadBalancer.balancer, initial weighted average imbalance={}, functionCost={} computedMaxSteps={}", new Object[]{currentCost / (double)this.sumMultiplier, this.functionCost(), computedMaxSteps});
        String initFunctionTotalCosts = this.totalCostsPerFunc();
        for (step = 0L; step < computedMaxSteps; ++step) {
            BaseLoadBalancer.Cluster.Action action = this.nextAction(cluster);
            if (action.type == BaseLoadBalancer.Cluster.Action.Type.NULL) continue;
            cluster.doAction(action);
            this.updateCostsAndWeightsWithAction(cluster, action);
            double newCost = this.computeCost(cluster, currentCost);
            if (newCost < currentCost) {
                this.curOverallCost = currentCost = newCost;
                System.arraycopy(this.tempFunctionCosts, 0, this.curFunctionCosts, 0, this.curFunctionCosts.length);
            } else {
                BaseLoadBalancer.Cluster.Action undoAction = action.undoAction();
                cluster.doAction(undoAction);
                this.updateCostsAndWeightsWithAction(cluster, undoAction);
            }
            if (EnvironmentEdgeManager.currentTime() - startTime > this.maxRunningTime) break;
        }
        long endTime = EnvironmentEdgeManager.currentTime();
        this.metricsBalancer.balanceCluster(endTime - startTime);
        this.updateStochasticCosts(tableName, this.curOverallCost, this.curFunctionCosts);
        if (initCost > currentCost) {
            plans = this.createRegionPlans(cluster);
            LOG.info("Finished computing new moving plan. Computation took {} ms to try {} different iterations.  Found a solution that moves {} regions; Going from a computed imbalance of {} to a new imbalance of {}. funtionCost={}", new Object[]{endTime - startTime, step, plans.size(), initCost / (double)this.sumMultiplier, currentCost / (double)this.sumMultiplier, this.functionCost()});
            this.sendRegionPlansToRingBuffer(plans, currentCost, initCost, initFunctionTotalCosts, step);
            return plans;
        }
        LOG.info("Could not find a better moving plan.  Tried {} different configurations in {} ms, and did not find anything with an imbalance score less than {}", new Object[]{step, endTime - startTime, initCost / (double)this.sumMultiplier});
        return null;
    }

    private void sendRejectionReasonToRingBuffer(String reason, List<CostFunction> costFunctions) {
        if (this.isBalancerRejectionRecording) {
            BalancerRejection.Builder builder = new BalancerRejection.Builder().setReason(reason);
            if (costFunctions != null) {
                for (CostFunction c : costFunctions) {
                    if (!c.isNeeded()) continue;
                    builder.addCostFuncInfo(c.getClass().getName(), c.cost(), c.getMultiplier());
                }
            }
            this.namedQueueRecorder.addRecord(new BalancerRejectionDetails(builder.build()));
        }
    }

    private void sendRegionPlansToRingBuffer(List<RegionPlan> plans, double currentCost, double initCost, String initFunctionTotalCosts, long step) {
        if (this.isBalancerDecisionRecording) {
            ArrayList<String> regionPlans = new ArrayList<String>();
            for (RegionPlan plan : plans) {
                regionPlans.add("table: " + plan.getRegionInfo().getTable() + " , region: " + plan.getRegionName() + " , source: " + plan.getSource() + " , destination: " + plan.getDestination());
            }
            BalancerDecision balancerDecision = new BalancerDecision.Builder().setInitTotalCost(initCost).setInitialFunctionCosts(initFunctionTotalCosts).setComputedTotalCost(currentCost).setFinalFunctionCosts(this.totalCostsPerFunc()).setComputedSteps(step).setRegionPlans(regionPlans).build();
            this.namedQueueRecorder.addRecord(new BalancerDecisionDetails(balancerDecision));
        }
    }

    private void updateStochasticCosts(TableName tableName, double overall, double[] subCosts) {
        if (tableName == null) {
            return;
        }
        if (this.metricsBalancer instanceof MetricsStochasticBalancer) {
            MetricsStochasticBalancer balancer = (MetricsStochasticBalancer)this.metricsBalancer;
            balancer.updateStochasticCost(tableName.getNameAsString(), "Overall", "Overall cost", overall);
            for (int i = 0; i < this.costFunctions.size(); ++i) {
                CostFunction costFunction = this.costFunctions.get(i);
                String costFunctionName = costFunction.getClass().getSimpleName();
                double costPercent = overall == 0.0 ? 0.0 : subCosts[i] / overall;
                balancer.updateStochasticCost(tableName.getNameAsString(), costFunctionName, "The percent of " + costFunctionName, costPercent);
            }
        }
    }

    private void addCostFunction(CostFunction costFunction) {
        float multiplier = costFunction.getMultiplier();
        if (multiplier > 0.0f) {
            this.costFunctions.add(costFunction);
        }
    }

    private String functionCost() {
        StringBuilder builder = new StringBuilder();
        for (CostFunction c : this.costFunctions) {
            builder.append(c.getClass().getSimpleName());
            builder.append(" : (");
            if (c.isNeeded()) {
                builder.append("multiplier=" + c.getMultiplier());
                builder.append(", ");
                double cost = c.cost();
                builder.append("imbalance=" + cost);
                if (cost >= (double)this.minCostNeedBalance) {
                    builder.append(", need balance");
                }
            } else {
                builder.append("not needed");
            }
            builder.append("); ");
        }
        return builder.toString();
    }

    private String totalCostsPerFunc() {
        StringBuilder builder = new StringBuilder();
        for (CostFunction c : this.costFunctions) {
            double cost;
            if (!c.isNeeded() || !((cost = (double)c.getMultiplier() * c.cost()) > 0.0)) continue;
            builder.append(" ");
            builder.append(c.getClass().getSimpleName());
            builder.append(" : ");
            builder.append(cost);
            builder.append(";");
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    private List<RegionPlan> createRegionPlans(BaseLoadBalancer.Cluster cluster) {
        LinkedList<RegionPlan> plans = new LinkedList<RegionPlan>();
        for (int regionIndex = 0; regionIndex < cluster.regionIndexToServerIndex.length; ++regionIndex) {
            int initialServerIndex = cluster.initialRegionIndexToServerIndex[regionIndex];
            int newServerIndex = cluster.regionIndexToServerIndex[regionIndex];
            if (initialServerIndex == newServerIndex) continue;
            RegionInfo region = cluster.regions[regionIndex];
            ServerName initialServer = cluster.servers[initialServerIndex];
            ServerName newServer = cluster.servers[newServerIndex];
            if (LOG.isTraceEnabled()) {
                LOG.trace("Moving Region " + region.getEncodedName() + " from server " + initialServer.getHostname() + " to " + newServer.getHostname());
            }
            RegionPlan rp = new RegionPlan(region, initialServer, newServer);
            plans.add(rp);
        }
        return plans;
    }

    private synchronized void updateRegionLoad() {
        Map<String, Deque<BalancerRegionLoad>> oldLoads = this.loads;
        this.loads = new HashMap<String, Deque<BalancerRegionLoad>>();
        this.clusterStatus.getLiveServerMetrics().forEach((sn, sm) -> sm.getRegionMetrics().forEach((regionName, rm) -> {
            String regionNameAsString = RegionInfo.getRegionNameAsString(regionName);
            ArrayDeque<BalancerRegionLoad> rLoads = (ArrayDeque<BalancerRegionLoad>)oldLoads.get(regionNameAsString);
            if (rLoads == null) {
                rLoads = new ArrayDeque<BalancerRegionLoad>(this.numRegionLoadsToRemember + 1);
            } else if (rLoads.size() >= this.numRegionLoadsToRemember) {
                rLoads.remove();
            }
            rLoads.add(new BalancerRegionLoad((RegionMetrics)rm));
            this.loads.put(regionNameAsString, rLoads);
        }));
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*(/src/test/.*|StochasticLoadBalancer).java")
    void initCosts(BaseLoadBalancer.Cluster cluster) {
        this.weightsOfGenerators = new double[this.candidateGenerators.size()];
        for (CostFunction c : this.costFunctions) {
            c.init(cluster);
            c.updateWeight(this.weightsOfGenerators);
        }
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*(/src/test/.*|StochasticLoadBalancer).java")
    void updateCostsAndWeightsWithAction(BaseLoadBalancer.Cluster cluster, BaseLoadBalancer.Cluster.Action action) {
        for (int i = 0; i < this.weightsOfGenerators.length; ++i) {
            this.weightsOfGenerators[i] = 0.0;
        }
        for (CostFunction c : this.costFunctions) {
            if (!c.isNeeded()) continue;
            c.postAction(action);
            c.updateWeight(this.weightsOfGenerators);
        }
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*(/src/test/.*|StochasticLoadBalancer).java")
    String[] getCostFunctionNames() {
        String[] ret = new String[this.costFunctions.size()];
        for (int i = 0; i < this.costFunctions.size(); ++i) {
            CostFunction c = this.costFunctions.get(i);
            ret[i] = c.getClass().getSimpleName();
        }
        return ret;
    }

    @RestrictedApi(explanation="Should only be called in tests", link="", allowedOnPath=".*(/src/test/.*|StochasticLoadBalancer).java")
    double computeCost(BaseLoadBalancer.Cluster cluster, double previousCost) {
        double total = 0.0;
        for (int i = 0; i < this.costFunctions.size(); ++i) {
            CostFunction c = this.costFunctions.get(i);
            this.tempFunctionCosts[i] = 0.0;
            if (!c.isNeeded()) continue;
            Float multiplier = Float.valueOf(c.getMultiplier());
            double cost = c.cost();
            this.tempFunctionCosts[i] = (double)multiplier.floatValue() * cost;
            if ((total += this.tempFunctionCosts[i]) > previousCost) break;
        }
        return total;
    }

    public static String composeAttributeName(String tableName, String costFunctionName) {
        return tableName + TABLE_FUNCTION_SEP + costFunctionName;
    }

    static double scale(double min, double max, double value) {
        if (max <= min || value <= min || Math.abs(max - min) <= 1.0E-4 || Math.abs(value - min) <= 1.0E-4) {
            return 0.0;
        }
        if (max <= min || Math.abs(max - min) <= 1.0E-4) {
            return 0.0;
        }
        return Math.max(0.0, Math.min(1.0, (value - min) / (max - min)));
    }

    static class StoreFileCostFunction
    extends CostFromRegionLoadFunction {
        private static final String STOREFILE_SIZE_COST_KEY = "hbase.master.balancer.stochastic.storefileSizeCost";
        private static final float DEFAULT_STOREFILE_SIZE_COST = 5.0f;

        StoreFileCostFunction(Configuration conf) {
            super(conf);
            this.setMultiplier(conf.getFloat(STOREFILE_SIZE_COST_KEY, 5.0f));
        }

        @Override
        protected double getCostFromRl(BalancerRegionLoad rl) {
            return rl.getStorefileSizeMB();
        }
    }

    static class MemStoreSizeCostFunction
    extends CostFromRegionLoadAsRateFunction {
        private static final String MEMSTORE_SIZE_COST_KEY = "hbase.master.balancer.stochastic.memstoreSizeCost";
        private static final float DEFAULT_MEMSTORE_SIZE_COST = 5.0f;

        MemStoreSizeCostFunction(Configuration conf) {
            super(conf);
            this.setMultiplier(conf.getFloat(MEMSTORE_SIZE_COST_KEY, 5.0f));
        }

        @Override
        protected double getCostFromRl(BalancerRegionLoad rl) {
            return rl.getMemStoreSizeMB();
        }
    }

    static class RegionReplicaRackCostFunction
    extends RegionReplicaHostCostFunction {
        private static final String REGION_REPLICA_RACK_COST_KEY = "hbase.master.balancer.stochastic.regionReplicaRackCostKey";
        private static final float DEFAULT_REGION_REPLICA_RACK_COST_KEY = 10000.0f;

        public RegionReplicaRackCostFunction(Configuration conf) {
            super(conf);
            this.setMultiplier(conf.getFloat(REGION_REPLICA_RACK_COST_KEY, 10000.0f));
        }

        @Override
        void init(BaseLoadBalancer.Cluster cluster) {
            this.cluster = cluster;
            if (cluster.numRacks <= 1) {
                this.maxCost = 0L;
                return;
            }
            this.maxCost = this.getMaxCost(cluster);
            this.costsPerGroup = new long[cluster.numRacks];
            for (int i = 0; i < cluster.primariesOfRegionsPerRack.length; ++i) {
                this.costsPerGroup[i] = this.costPerGroup(cluster.primariesOfRegionsPerRack[i]);
            }
        }

        @Override
        protected void regionMoved(int region, int oldServer, int newServer) {
            if (this.maxCost <= 0L) {
                return;
            }
            int newRack = this.cluster.serverIndexToRackIndex[newServer];
            int oldRack = this.cluster.serverIndexToRackIndex[oldServer];
            if (newRack != oldRack) {
                this.costsPerGroup[oldRack] = this.costPerGroup(this.cluster.primariesOfRegionsPerRack[oldRack]);
                this.costsPerGroup[newRack] = this.costPerGroup(this.cluster.primariesOfRegionsPerRack[newRack]);
            }
        }
    }

    static class RegionReplicaHostCostFunction
    extends CostFunction {
        private static final String REGION_REPLICA_HOST_COST_KEY = "hbase.master.balancer.stochastic.regionReplicaHostCostKey";
        private static final float DEFAULT_REGION_REPLICA_HOST_COST_KEY = 100000.0f;
        long maxCost = 0L;
        long[] costsPerGroup;
        int[][] primariesOfRegionsPerGroup;

        public RegionReplicaHostCostFunction(Configuration conf) {
            super(conf);
            this.setMultiplier(conf.getFloat(REGION_REPLICA_HOST_COST_KEY, 100000.0f));
        }

        @Override
        void init(BaseLoadBalancer.Cluster cluster) {
            super.init(cluster);
            this.maxCost = cluster.numHosts > 1 ? this.getMaxCost(cluster) : 0L;
            this.costsPerGroup = new long[cluster.numHosts];
            this.primariesOfRegionsPerGroup = cluster.multiServersPerHost ? cluster.primariesOfRegionsPerHost : cluster.primariesOfRegionsPerServer;
            for (int i = 0; i < this.primariesOfRegionsPerGroup.length; ++i) {
                this.costsPerGroup[i] = this.costPerGroup(this.primariesOfRegionsPerGroup[i]);
            }
        }

        long getMaxCost(BaseLoadBalancer.Cluster cluster) {
            if (!cluster.hasRegionReplicas) {
                return 0L;
            }
            int[] primariesOfRegions = new int[cluster.numRegions];
            System.arraycopy(cluster.regionIndexToPrimaryIndex, 0, primariesOfRegions, 0, cluster.regions.length);
            Arrays.sort(primariesOfRegions);
            return this.costPerGroup(primariesOfRegions);
        }

        @Override
        boolean isNeeded() {
            return this.cluster.hasRegionReplicas;
        }

        @Override
        protected double cost() {
            if (this.maxCost <= 0L) {
                return 0.0;
            }
            long totalCost = 0L;
            for (int i = 0; i < this.costsPerGroup.length; ++i) {
                totalCost += this.costsPerGroup[i];
            }
            return StochasticLoadBalancer.scale(0.0, this.maxCost, totalCost);
        }

        protected long costPerGroup(int[] primariesOfRegions) {
            long cost = 0L;
            int currentPrimary = -1;
            int currentPrimaryIndex = -1;
            for (int j = 0; j <= primariesOfRegions.length; ++j) {
                int primary;
                int n = primary = j < primariesOfRegions.length ? primariesOfRegions[j] : -1;
                if (primary == currentPrimary) continue;
                int numReplicas = j - currentPrimaryIndex;
                if (numReplicas > 1) {
                    cost += (long)((numReplicas - 1) * (numReplicas - 1));
                }
                currentPrimary = primary;
                currentPrimaryIndex = j;
            }
            return cost;
        }

        @Override
        protected void regionMoved(int region, int oldServer, int newServer) {
            if (this.maxCost <= 0L) {
                return;
            }
            if (this.cluster.multiServersPerHost) {
                int newHost = this.cluster.serverIndexToHostIndex[newServer];
                int oldHost = this.cluster.serverIndexToHostIndex[oldServer];
                if (newHost != oldHost) {
                    this.costsPerGroup[oldHost] = this.costPerGroup(this.cluster.primariesOfRegionsPerHost[oldHost]);
                    this.costsPerGroup[newHost] = this.costPerGroup(this.cluster.primariesOfRegionsPerHost[newHost]);
                }
            } else {
                this.costsPerGroup[oldServer] = this.costPerGroup(this.cluster.primariesOfRegionsPerServer[oldServer]);
                this.costsPerGroup[newServer] = this.costPerGroup(this.cluster.primariesOfRegionsPerServer[newServer]);
            }
        }

        @Override
        public final void updateWeight(double[] weights) {
            int n = GeneratorType.RACK.ordinal();
            weights[n] = weights[n] + this.cost();
        }
    }

    static class WriteRequestCostFunction
    extends CostFromRegionLoadAsRateFunction {
        private static final String WRITE_REQUEST_COST_KEY = "hbase.master.balancer.stochastic.writeRequestCost";
        private static final float DEFAULT_WRITE_REQUEST_COST = 5.0f;

        WriteRequestCostFunction(Configuration conf) {
            super(conf);
            this.setMultiplier(conf.getFloat(WRITE_REQUEST_COST_KEY, 5.0f));
        }

        @Override
        protected double getCostFromRl(BalancerRegionLoad rl) {
            return rl.getWriteRequestsCount();
        }
    }

    static class ReadRequestCostFunction
    extends CostFromRegionLoadAsRateFunction {
        private static final String READ_REQUEST_COST_KEY = "hbase.master.balancer.stochastic.readRequestCost";
        private static final float DEFAULT_READ_REQUEST_COST = 5.0f;

        ReadRequestCostFunction(Configuration conf) {
            super(conf);
            this.setMultiplier(conf.getFloat(READ_REQUEST_COST_KEY, 5.0f));
        }

        @Override
        protected double getCostFromRl(BalancerRegionLoad rl) {
            return rl.getReadRequestsCount();
        }
    }

    static abstract class CostFromRegionLoadAsRateFunction
    extends CostFromRegionLoadFunction {
        CostFromRegionLoadAsRateFunction(Configuration conf) {
            super(conf);
        }

        @Override
        protected double getRegionLoadCost(Collection<BalancerRegionLoad> regionLoadList) {
            Iterator<BalancerRegionLoad> iter = regionLoadList.iterator();
            if (!iter.hasNext()) {
                return 0.0;
            }
            double previous = this.getCostFromRl(iter.next());
            if (!iter.hasNext()) {
                return 0.0;
            }
            double cost = 0.0;
            do {
                double current = this.getCostFromRl(iter.next());
                cost += current - previous;
                previous = current;
            } while (iter.hasNext());
            return Math.max(0.0, cost / (double)(regionLoadList.size() - 1));
        }
    }

    static abstract class CostFromRegionLoadFunction
    extends CostFunction {
        private final DoubleArrayCost cost = new DoubleArrayCost();

        CostFromRegionLoadFunction(Configuration conf) {
            super(conf);
        }

        private double computeCostForRegionServer(int regionServerIndex) {
            double cost = 0.0;
            for (int regionIndex : this.cluster.regionsPerServer[regionServerIndex]) {
                Deque<BalancerRegionLoad> regionLoadList = this.cluster.regionLoads[regionIndex];
                if (regionLoadList == null) continue;
                cost += this.getRegionLoadCost(regionLoadList);
            }
            return cost;
        }

        @Override
        void init(BaseLoadBalancer.Cluster cluster) {
            super.init(cluster);
            this.cost.prepare(cluster.numServers);
            this.cost.applyCostsChange(costs -> {
                for (int i = 0; i < ((double[])costs).length; ++i) {
                    costs[i] = this.computeCostForRegionServer(i);
                }
            });
        }

        @Override
        protected void regionMoved(int region, int oldServer, int newServer) {
            this.cost.applyCostsChange(costs -> {
                costs[oldServer] = this.computeCostForRegionServer(oldServer);
                costs[newServer] = this.computeCostForRegionServer(newServer);
            });
        }

        @Override
        protected final double cost() {
            return this.cost.cost();
        }

        protected double getRegionLoadCost(Collection<BalancerRegionLoad> regionLoadList) {
            double cost = 0.0;
            for (BalancerRegionLoad rl : regionLoadList) {
                cost += this.getCostFromRl(rl);
            }
            return cost / (double)regionLoadList.size();
        }

        protected abstract double getCostFromRl(BalancerRegionLoad var1);
    }

    static class RackLocalityCostFunction
    extends LocalityBasedCostFunction {
        private static final String RACK_LOCALITY_COST_KEY = "hbase.master.balancer.stochastic.rackLocalityCost";
        private static final float DEFAULT_RACK_LOCALITY_COST = 15.0f;

        public RackLocalityCostFunction(Configuration conf) {
            super(conf, BaseLoadBalancer.Cluster.LocalityType.RACK, RACK_LOCALITY_COST_KEY, 15.0f);
        }

        @Override
        int regionIndexToEntityIndex(int region) {
            return this.cluster.getRackForRegion(region);
        }
    }

    static class ServerLocalityCostFunction
    extends LocalityBasedCostFunction {
        private static final String LOCALITY_COST_KEY = "hbase.master.balancer.stochastic.localityCost";
        private static final float DEFAULT_LOCALITY_COST = 25.0f;

        ServerLocalityCostFunction(Configuration conf) {
            super(conf, BaseLoadBalancer.Cluster.LocalityType.SERVER, LOCALITY_COST_KEY, 25.0f);
        }

        @Override
        int regionIndexToEntityIndex(int region) {
            return this.cluster.regionIndexToServerIndex[region];
        }
    }

    static abstract class LocalityBasedCostFunction
    extends CostFunction {
        private final BaseLoadBalancer.Cluster.LocalityType type;
        private double bestLocality;
        private double locality;

        LocalityBasedCostFunction(Configuration conf, BaseLoadBalancer.Cluster.LocalityType type, String localityCostKey, float defaultLocalityCost) {
            super(conf);
            this.type = type;
            this.setMultiplier(conf.getFloat(localityCostKey, defaultLocalityCost));
            this.locality = 0.0;
            this.bestLocality = 0.0;
        }

        abstract int regionIndexToEntityIndex(int var1);

        @Override
        void init(BaseLoadBalancer.Cluster cluster) {
            super.init(cluster);
            this.locality = 0.0;
            this.bestLocality = 0.0;
            for (int region = 0; region < cluster.numRegions; ++region) {
                this.locality += this.getWeightedLocality(region, this.regionIndexToEntityIndex(region));
                this.bestLocality += this.getWeightedLocality(region, this.getMostLocalEntityForRegion(region));
            }
            this.locality = this.bestLocality == 0.0 ? 1.0 : this.locality / this.bestLocality;
        }

        @Override
        protected void regionMoved(int region, int oldServer, int newServer) {
            int oldEntity = this.type == BaseLoadBalancer.Cluster.LocalityType.SERVER ? oldServer : this.cluster.serverIndexToRackIndex[oldServer];
            int newEntity = this.type == BaseLoadBalancer.Cluster.LocalityType.SERVER ? newServer : this.cluster.serverIndexToRackIndex[newServer];
            double localityDelta = this.getWeightedLocality(region, newEntity) - this.getWeightedLocality(region, oldEntity);
            double normalizedDelta = this.bestLocality == 0.0 ? 0.0 : localityDelta / this.bestLocality;
            this.locality += normalizedDelta;
        }

        @Override
        protected double cost() {
            return 1.0 - this.locality;
        }

        private int getMostLocalEntityForRegion(int region) {
            return this.cluster.getOrComputeRegionsToMostLocalEntities(this.type)[region];
        }

        private double getWeightedLocality(int region, int entity) {
            return this.cluster.getOrComputeWeightedLocality(region, entity, this.type);
        }

        @Override
        public final void updateWeight(double[] weights) {
            int n = GeneratorType.LOCALITY.ordinal();
            weights[n] = weights[n] + this.cost();
        }
    }

    static class TableSkewCostFunction
    extends CostFunction {
        private static final String TABLE_SKEW_COST_KEY = "hbase.master.balancer.stochastic.tableSkewCost";
        private static final float DEFAULT_TABLE_SKEW_COST = 35.0f;
        DoubleArrayCost[] costsPerTable;

        TableSkewCostFunction(Configuration conf) {
            super(conf);
            this.setMultiplier(conf.getFloat(TABLE_SKEW_COST_KEY, 35.0f));
        }

        @Override
        void init(BaseLoadBalancer.Cluster cluster) {
            super.init(cluster);
            this.costsPerTable = new DoubleArrayCost[cluster.numTables];
            for (int tableIdx = 0; tableIdx < cluster.numTables; ++tableIdx) {
                this.costsPerTable[tableIdx] = new DoubleArrayCost();
                this.costsPerTable[tableIdx].prepare(cluster.numServers);
                int tableIndex = tableIdx;
                this.costsPerTable[tableIdx].applyCostsChange(costs -> {
                    for (int i = 0; i < cluster.numServers; ++i) {
                        costs[i] = cluster.numRegionsPerServerPerTable[tableIndex][i];
                    }
                });
            }
        }

        @Override
        protected void regionMoved(int region, int oldServer, int newServer) {
            int tableIdx = this.cluster.regionIndexToTableIndex[region];
            this.costsPerTable[tableIdx].applyCostsChange(costs -> {
                costs[oldServer] = this.cluster.numRegionsPerServerPerTable[tableIdx][oldServer];
                costs[newServer] = this.cluster.numRegionsPerServerPerTable[tableIdx][newServer];
            });
        }

        @Override
        protected double cost() {
            double cost = 0.0;
            for (int tableIdx = 0; tableIdx < this.cluster.numTables; ++tableIdx) {
                cost += this.costsPerTable[tableIdx].cost();
            }
            return cost;
        }
    }

    static class PrimaryRegionCountSkewCostFunction
    extends CostFunction {
        private static final String PRIMARY_REGION_COUNT_SKEW_COST_KEY = "hbase.master.balancer.stochastic.primaryRegionCountCost";
        private static final float DEFAULT_PRIMARY_REGION_COUNT_SKEW_COST = 500.0f;
        private final DoubleArrayCost cost = new DoubleArrayCost();

        PrimaryRegionCountSkewCostFunction(Configuration conf) {
            super(conf);
            this.setMultiplier(conf.getFloat(PRIMARY_REGION_COUNT_SKEW_COST_KEY, 500.0f));
        }

        private double computeCostForRegionServer(int regionServerIndex) {
            int cost = 0;
            for (int regionIdx : this.cluster.regionsPerServer[regionServerIndex]) {
                if (regionIdx != this.cluster.regionIndexToPrimaryIndex[regionIdx]) continue;
                ++cost;
            }
            return cost;
        }

        @Override
        void init(BaseLoadBalancer.Cluster cluster) {
            super.init(cluster);
            if (!this.isNeeded()) {
                return;
            }
            this.cost.prepare(cluster.numServers);
            this.cost.applyCostsChange(costs -> {
                for (int i = 0; i < ((double[])costs).length; ++i) {
                    costs[i] = this.computeCostForRegionServer(i);
                }
            });
        }

        @Override
        boolean isNeeded() {
            return this.cluster.hasRegionReplicas;
        }

        @Override
        protected void regionMoved(int region, int oldServer, int newServer) {
            this.cost.applyCostsChange(costs -> {
                costs[oldServer] = this.computeCostForRegionServer(oldServer);
                costs[newServer] = this.computeCostForRegionServer(newServer);
            });
        }

        @Override
        protected double cost() {
            return this.cost.cost();
        }
    }

    static class RegionCountSkewCostFunction
    extends CostFunction {
        static final String REGION_COUNT_SKEW_COST_KEY = "hbase.master.balancer.stochastic.regionCountCost";
        static final float DEFAULT_REGION_COUNT_SKEW_COST = 500.0f;
        private final DoubleArrayCost cost = new DoubleArrayCost();

        RegionCountSkewCostFunction(Configuration conf) {
            super(conf);
            this.setMultiplier(conf.getFloat(REGION_COUNT_SKEW_COST_KEY, 500.0f));
        }

        @Override
        void init(BaseLoadBalancer.Cluster cluster) {
            super.init(cluster);
            this.cost.prepare(cluster.numServers);
            this.cost.applyCostsChange(costs -> {
                for (int i = 0; i < cluster.numServers; ++i) {
                    costs[i] = cluster.regionsPerServer[i].length;
                }
            });
        }

        @Override
        protected double cost() {
            return this.cost.cost();
        }

        @Override
        protected void regionMoved(int region, int oldServer, int newServer) {
            this.cost.applyCostsChange(costs -> {
                costs[oldServer] = this.cluster.regionsPerServer[oldServer].length;
                costs[newServer] = this.cluster.regionsPerServer[newServer].length;
            });
        }

        @Override
        public final void updateWeight(double[] weights) {
            int n = GeneratorType.LOAD.ordinal();
            weights[n] = weights[n] + this.cost();
        }
    }

    static class MoveCostFunction
    extends CostFunction {
        private static final String MOVE_COST_KEY = "hbase.master.balancer.stochastic.moveCost";
        private static final String MOVE_COST_OFFPEAK_KEY = "hbase.master.balancer.stochastic.moveCost.offpeak";
        private static final String MAX_MOVES_PERCENT_KEY = "hbase.master.balancer.stochastic.maxMovePercent";
        static final float DEFAULT_MOVE_COST = 7.0f;
        static final float DEFAULT_MOVE_COST_OFFPEAK = 3.0f;
        private static final int DEFAULT_MAX_MOVES = 600;
        private static final float DEFAULT_MAX_MOVE_PERCENT = 1.0f;
        private final float maxMovesPercent;
        private final OffPeakHours offPeakHours;
        private final float moveCost;
        private final float moveCostOffPeak;

        MoveCostFunction(Configuration conf) {
            super(conf);
            this.maxMovesPercent = conf.getFloat(MAX_MOVES_PERCENT_KEY, 1.0f);
            this.offPeakHours = OffPeakHours.getInstance(conf);
            this.moveCost = conf.getFloat(MOVE_COST_KEY, 7.0f);
            this.moveCostOffPeak = conf.getFloat(MOVE_COST_OFFPEAK_KEY, 3.0f);
            this.setMultiplier(this.moveCost);
        }

        @Override
        void init(BaseLoadBalancer.Cluster cluster) {
            super.init(cluster);
            if (this.offPeakHours.isOffPeakHour()) {
                this.setMultiplier(this.moveCostOffPeak);
            } else {
                this.setMultiplier(this.moveCost);
            }
        }

        @Override
        protected double cost() {
            double moveCost = this.cluster.numMovedRegions;
            int maxMoves = Math.max((int)((float)this.cluster.numRegions * this.maxMovesPercent), 600);
            if (moveCost > (double)maxMoves) {
                return 1000000.0;
            }
            return StochasticLoadBalancer.scale(0.0, Math.min(this.cluster.numRegions, maxMoves), moveCost);
        }
    }

    public static abstract class CostFunction {
        public static final double COST_EPSILON = 1.0E-4;
        private float multiplier = 0.0f;
        protected BaseLoadBalancer.Cluster cluster;

        public CostFunction(Configuration c) {
        }

        boolean isNeeded() {
            return true;
        }

        float getMultiplier() {
            return this.multiplier;
        }

        void setMultiplier(float m) {
            this.multiplier = m;
        }

        void init(BaseLoadBalancer.Cluster cluster) {
            this.cluster = cluster;
        }

        void postAction(BaseLoadBalancer.Cluster.Action action) {
            switch (action.type) {
                case NULL: {
                    break;
                }
                case ASSIGN_REGION: {
                    BaseLoadBalancer.Cluster.AssignRegionAction ar = (BaseLoadBalancer.Cluster.AssignRegionAction)action;
                    this.regionMoved(ar.region, -1, ar.server);
                    break;
                }
                case MOVE_REGION: {
                    BaseLoadBalancer.Cluster.MoveRegionAction mra = (BaseLoadBalancer.Cluster.MoveRegionAction)action;
                    this.regionMoved(mra.region, mra.fromServer, mra.toServer);
                    break;
                }
                case SWAP_REGIONS: {
                    BaseLoadBalancer.Cluster.SwapRegionsAction a = (BaseLoadBalancer.Cluster.SwapRegionsAction)action;
                    this.regionMoved(a.fromRegion, a.fromServer, a.toServer);
                    this.regionMoved(a.toRegion, a.toServer, a.fromServer);
                    break;
                }
                default: {
                    throw new RuntimeException("Uknown action:" + (Object)((Object)action.type));
                }
            }
        }

        protected void regionMoved(int region, int oldServer, int newServer) {
        }

        protected abstract double cost();

        public void updateWeight(double[] weights) {
            int n = GeneratorType.RANDOM.ordinal();
            weights[n] = weights[n] + this.cost();
        }
    }

    static class RegionReplicaRackCandidateGenerator
    extends RegionReplicaCandidateGenerator {
        RegionReplicaRackCandidateGenerator() {
        }

        @Override
        BaseLoadBalancer.Cluster.Action generate(BaseLoadBalancer.Cluster cluster) {
            int rackIndex = this.pickRandomRack(cluster);
            if (cluster.numRacks <= 1 || rackIndex == -1) {
                return super.generate(cluster);
            }
            int regionIndex = this.selectCoHostedRegionPerGroup(cluster.primariesOfRegionsPerRack[rackIndex], cluster.regionsPerRack[rackIndex], cluster.regionIndexToPrimaryIndex);
            if (regionIndex == -1) {
                return this.randomGenerator.generate(cluster);
            }
            int serverIndex = cluster.regionIndexToServerIndex[regionIndex];
            int toRackIndex = this.pickOtherRandomRack(cluster, rackIndex);
            int rand = RANDOM.nextInt(cluster.serversPerRack[toRackIndex].length);
            int toServerIndex = cluster.serversPerRack[toRackIndex][rand];
            int toRegionIndex = this.pickRandomRegion(cluster, toServerIndex, 0.9f);
            return this.getAction(serverIndex, regionIndex, toServerIndex, toRegionIndex);
        }
    }

    static class RandomCandidateGenerator
    extends CandidateGenerator {
        RandomCandidateGenerator() {
        }

        @Override
        BaseLoadBalancer.Cluster.Action generate(BaseLoadBalancer.Cluster cluster) {
            int thisServer = this.pickRandomServer(cluster);
            int otherServer = this.pickOtherRandomServer(cluster, thisServer);
            return this.pickRandomRegions(cluster, thisServer, otherServer);
        }
    }

    public static enum GeneratorType {
        RANDOM,
        LOAD,
        LOCALITY,
        RACK;

    }
}

