/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.master.normalizer;

import io.hops.hudi.org.apache.hadoop.hbase.Abortable;
import io.hops.hudi.org.apache.hadoop.hbase.TableName;
import io.hops.hudi.org.apache.hadoop.hbase.master.HMaster;
import io.hops.hudi.org.apache.hadoop.hbase.master.normalizer.RegionNormalizer;
import io.hops.hudi.org.apache.hadoop.hbase.master.normalizer.RegionNormalizerChore;
import io.hops.hudi.org.apache.hadoop.hbase.master.normalizer.RegionNormalizerManager;
import io.hops.hudi.org.apache.hadoop.hbase.master.normalizer.RegionNormalizerWorkQueue;
import io.hops.hudi.org.apache.hadoop.hbase.master.normalizer.RegionNormalizerWorker;
import io.hops.hudi.org.apache.hadoop.hbase.master.normalizer.SimpleRegionNormalizer;
import io.hops.hudi.org.apache.hadoop.hbase.zookeeper.RegionNormalizerTracker;
import io.hops.hudi.org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class RegionNormalizerFactory {
    private RegionNormalizerFactory() {
    }

    public static RegionNormalizerManager createNormalizerManager(Configuration conf, ZKWatcher zkWatcher, HMaster master) {
        RegionNormalizer regionNormalizer = RegionNormalizerFactory.getRegionNormalizer(conf);
        regionNormalizer.setMasterServices(master);
        RegionNormalizerTracker tracker = new RegionNormalizerTracker(zkWatcher, (Abortable)master);
        RegionNormalizerChore chore = master.isInMaintenanceMode() ? null : new RegionNormalizerChore(master);
        RegionNormalizerWorkQueue<TableName> workQueue = master.isInMaintenanceMode() ? null : new RegionNormalizerWorkQueue<TableName>();
        RegionNormalizerWorker worker = master.isInMaintenanceMode() ? null : new RegionNormalizerWorker(conf, master, regionNormalizer, workQueue);
        return new RegionNormalizerManager(tracker, chore, workQueue, worker);
    }

    private static RegionNormalizer getRegionNormalizer(Configuration conf) {
        Class balancerKlass = conf.getClass("hbase.master.normalizer.class", SimpleRegionNormalizer.class, RegionNormalizer.class);
        return (RegionNormalizer)ReflectionUtils.newInstance((Class)balancerKlass, (Configuration)conf);
    }
}

