/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.master.replication;

import io.hops.hudi.org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import io.hops.hudi.org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import io.hops.hudi.org.apache.hadoop.hbase.master.procedure.PeerProcedureInterface;
import io.hops.hudi.org.apache.hadoop.hbase.master.replication.ModifyPeerProcedure;
import io.hops.hudi.org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import io.hops.hudi.org.apache.hadoop.hbase.replication.ReplicationException;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.protobuf.Message;
import java.io.IOException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class EnablePeerProcedure
extends ModifyPeerProcedure {
    private static final Logger LOG = LoggerFactory.getLogger(EnablePeerProcedure.class);

    public EnablePeerProcedure() {
    }

    public EnablePeerProcedure(String peerId) {
        super(peerId);
    }

    @Override
    public PeerProcedureInterface.PeerOperationType getPeerOperationType() {
        return PeerProcedureInterface.PeerOperationType.ENABLE;
    }

    @Override
    protected void prePeerModification(MasterProcedureEnv env) throws IOException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.preEnableReplicationPeer(this.peerId);
        }
        env.getReplicationPeerManager().preEnablePeer(this.peerId);
    }

    @Override
    protected void updatePeerStorage(MasterProcedureEnv env) throws ReplicationException {
        env.getReplicationPeerManager().enablePeer(this.peerId);
    }

    @Override
    protected void postPeerModification(MasterProcedureEnv env) throws IOException {
        LOG.info("Successfully enabled peer {}", (Object)this.peerId);
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.postEnableReplicationPeer(this.peerId);
        }
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        serializer.serialize((Message)MasterProcedureProtos.EnablePeerStateData.getDefaultInstance());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        serializer.deserialize(MasterProcedureProtos.EnablePeerStateData.class);
    }
}

