/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.mob.compactions;

import io.hops.hudi.org.apache.hadoop.hbase.TableName;
import io.hops.hudi.org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import io.hops.hudi.org.apache.hadoop.hbase.mob.MobUtils;
import io.hops.hudi.org.apache.hadoop.hbase.util.CommonFSUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class MobCompactor {
    protected FileSystem fs;
    protected Configuration conf;
    protected TableName tableName;
    protected ColumnFamilyDescriptor column;
    protected Path mobTableDir;
    protected Path mobFamilyDir;
    protected ExecutorService pool;

    public MobCompactor(Configuration conf, FileSystem fs, TableName tableName, ColumnFamilyDescriptor column, ExecutorService pool) {
        this.conf = conf;
        this.fs = fs;
        this.tableName = tableName;
        this.column = column;
        this.pool = pool;
        this.mobTableDir = CommonFSUtils.getTableDir(MobUtils.getMobHome(conf), tableName);
        this.mobFamilyDir = MobUtils.getMobFamilyPath(conf, tableName, column.getNameAsString());
    }

    public List<Path> compact() throws IOException {
        return this.compact(false);
    }

    public List<Path> compact(boolean allFiles) throws IOException {
        return this.compact(Arrays.asList(this.fs.listStatus(this.mobFamilyDir)), allFiles);
    }

    public abstract List<Path> compact(List<FileStatus> var1, boolean var2) throws IOException;
}

