/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.quotas;

import io.hops.hudi.org.apache.hadoop.hbase.quotas.RegionSize;
import io.hops.hudi.org.apache.hadoop.hbase.util.ClassSize;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RegionSizeImpl
implements RegionSize {
    private static final Logger LOG = LoggerFactory.getLogger(RegionSizeImpl.class);
    private static final long HEAP_SIZE = ClassSize.OBJECT + ClassSize.ATOMIC_LONG + ClassSize.REFERENCE;
    private final AtomicLong size;

    public RegionSizeImpl(long initialSize) {
        if (initialSize < 0L && LOG.isTraceEnabled()) {
            LOG.trace("Nonsensical negative Region size being constructed, this is likely an error", (Throwable)new Exception());
        }
        this.size = new AtomicLong(initialSize < 0L ? 0L : initialSize);
    }

    @Override
    public long heapSize() {
        return HEAP_SIZE;
    }

    @Override
    public RegionSizeImpl setSize(long newSize) {
        this.size.set(newSize);
        return this;
    }

    @Override
    public RegionSizeImpl incrementSize(long delta) {
        this.size.addAndGet(delta);
        return this;
    }

    @Override
    public long getSize() {
        return this.size.get();
    }
}

