/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.quotas;

import io.hops.hudi.org.apache.hadoop.hbase.TableName;
import io.hops.hudi.org.apache.hadoop.hbase.client.Connection;
import io.hops.hudi.org.apache.hadoop.hbase.client.Put;
import io.hops.hudi.org.apache.hadoop.hbase.client.Table;
import io.hops.hudi.org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import io.hops.hudi.org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import io.hops.hudi.org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshotNotifier;
import java.io.IOException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class TableSpaceQuotaSnapshotNotifier
implements SpaceQuotaSnapshotNotifier {
    private static final Logger LOG = LoggerFactory.getLogger(TableSpaceQuotaSnapshotNotifier.class);
    private Connection conn;

    @Override
    public void transitionTable(TableName tableName, SpaceQuotaSnapshot snapshot) throws IOException {
        Put p = QuotaTableUtil.createPutForSpaceSnapshot(tableName, snapshot);
        try (Table quotaTable = this.conn.getTable(QuotaTableUtil.QUOTA_TABLE_NAME);){
            if (LOG.isTraceEnabled()) {
                LOG.trace("Persisting a space quota snapshot " + snapshot + " for " + tableName);
            }
            quotaTable.put(p);
        }
    }

    @Override
    public void initialize(Connection conn) {
        this.conn = conn;
    }
}

