/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.regionserver;

import io.hops.hudi.org.apache.hadoop.hbase.Cell;
import io.hops.hudi.org.apache.hadoop.hbase.CellComparator;
import io.hops.hudi.org.apache.hadoop.hbase.ExtendedCell;
import io.hops.hudi.org.apache.hadoop.hbase.exceptions.UnexpectedStateException;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.MemStore;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.MemStoreSize;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.MemStoreSizing;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.MutableSegment;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.NonThreadSafeMemStoreSizing;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.RegionServicesForStores;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.Segment;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.SegmentFactory;
import io.hops.hudi.org.apache.hadoop.hbase.util.ClassSize;
import io.hops.hudi.org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import java.io.IOException;
import java.util.List;
import java.util.NavigableSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;

@InterfaceAudience.Private
public abstract class AbstractMemStore
implements MemStore {
    private static final long NO_SNAPSHOT_ID = -1L;
    private final Configuration conf;
    private final CellComparator comparator;
    private volatile MutableSegment active;
    protected volatile ImmutableSegment snapshot;
    protected volatile long snapshotId;
    private volatile long timeOfOldestEdit;
    protected RegionServicesForStores regionServices;
    public static final long FIXED_OVERHEAD;
    public static final long DEEP_OVERHEAD;

    public static void addToScanners(List<? extends Segment> segments, long readPt, List<KeyValueScanner> scanners) {
        for (Segment segment : segments) {
            AbstractMemStore.addToScanners(segment, readPt, scanners);
        }
    }

    protected static void addToScanners(Segment segment, long readPt, List<KeyValueScanner> scanners) {
        if (!segment.isEmpty()) {
            scanners.add(segment.getScanner(readPt));
        }
    }

    protected AbstractMemStore(Configuration conf, CellComparator c, RegionServicesForStores regionServices) {
        this.conf = conf;
        this.comparator = c;
        this.regionServices = regionServices;
        this.resetActive();
        this.resetTimeOfOldestEdit();
        this.snapshot = SegmentFactory.instance().createImmutableSegment(c);
        this.snapshotId = -1L;
    }

    protected void resetActive() {
        NonThreadSafeMemStoreSizing memstoreAccounting = new NonThreadSafeMemStoreSizing();
        this.active = SegmentFactory.instance().createMutableSegment(this.conf, this.comparator, memstoreAccounting);
        if (this.regionServices != null) {
            this.regionServices.addMemStoreSize(memstoreAccounting.getDataSize(), memstoreAccounting.getHeapSize(), memstoreAccounting.getOffHeapSize(), memstoreAccounting.getCellsCount());
        }
    }

    protected void resetTimeOfOldestEdit() {
        this.timeOfOldestEdit = Long.MAX_VALUE;
    }

    public abstract void updateLowestUnflushedSequenceIdInWAL(boolean var1);

    @Override
    public void add(Iterable<Cell> cells, MemStoreSizing memstoreSizing) {
        for (Cell cell : cells) {
            this.add(cell, memstoreSizing);
        }
    }

    @Override
    public void add(Cell cell, MemStoreSizing memstoreSizing) {
        this.doAddOrUpsert(cell, 0L, memstoreSizing, true);
    }

    private void upsert(Cell cell, long readpoint, MemStoreSizing memstoreSizing) {
        this.doAddOrUpsert(cell, readpoint, memstoreSizing, false);
    }

    private void doAddOrUpsert(Cell cell, long readpoint, MemStoreSizing memstoreSizing, boolean doAdd) {
        boolean succ = false;
        while (!succ) {
            MutableSegment currentActive = this.getActive();
            succ = this.preUpdate(currentActive, cell, memstoreSizing);
            if (!succ) continue;
            if (doAdd) {
                this.doAdd(currentActive, cell, memstoreSizing);
            } else {
                this.doUpsert(currentActive, cell, readpoint, memstoreSizing);
            }
            this.postUpdate(currentActive);
        }
    }

    protected void doAdd(MutableSegment currentActive, Cell cell, MemStoreSizing memstoreSizing) {
        boolean mslabUsed;
        Cell toAdd = this.maybeCloneWithAllocator(currentActive, cell, false);
        boolean bl = mslabUsed = toAdd != cell;
        if (!mslabUsed) {
            toAdd = AbstractMemStore.deepCopyIfNeeded(toAdd);
        }
        this.internalAdd(currentActive, toAdd, mslabUsed, memstoreSizing);
    }

    private void doUpsert(MutableSegment currentActive, Cell cell, long readpoint, MemStoreSizing memstoreSizing) {
        cell = AbstractMemStore.deepCopyIfNeeded(cell);
        boolean sizeAddedPreOperation = this.sizeAddedPreOperation();
        currentActive.upsert(cell, readpoint, memstoreSizing, sizeAddedPreOperation);
        this.setOldestEditTimeToNow();
    }

    protected abstract boolean preUpdate(MutableSegment var1, Cell var2, MemStoreSizing var3);

    protected abstract void postUpdate(MutableSegment var1);

    private static Cell deepCopyIfNeeded(Cell cell) {
        if (cell instanceof ExtendedCell) {
            return ((ExtendedCell)cell).deepClone();
        }
        return cell;
    }

    @Override
    public void upsert(Iterable<Cell> cells, long readpoint, MemStoreSizing memstoreSizing) {
        for (Cell cell : cells) {
            this.upsert(cell, readpoint, memstoreSizing);
        }
    }

    @Override
    public long timeOfOldestEdit() {
        return this.timeOfOldestEdit;
    }

    @Override
    public void clearSnapshot(long id) throws UnexpectedStateException {
        if (this.snapshotId == -1L) {
            return;
        }
        if (this.snapshotId != id) {
            throw new UnexpectedStateException("Current snapshot id is " + this.snapshotId + ",passed " + id);
        }
        this.doClearSnapShot();
    }

    protected void doClearSnapShot() {
        ImmutableSegment oldSnapshot = this.snapshot;
        if (!this.snapshot.isEmpty()) {
            this.snapshot = SegmentFactory.instance().createImmutableSegment(this.comparator);
        }
        this.snapshotId = -1L;
        oldSnapshot.close();
    }

    @Override
    public MemStoreSize getSnapshotSize() {
        return this.snapshot.getMemStoreSize();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        int i = 1;
        try {
            for (Segment segment : this.getSegments()) {
                buf.append("Segment (").append(i).append(") ").append(segment.toString()).append("; ");
                ++i;
            }
        }
        catch (IOException e) {
            return e.toString();
        }
        return buf.toString();
    }

    protected Configuration getConfiguration() {
        return this.conf;
    }

    protected void dump(Logger log) {
        this.getActive().dump(log);
        this.snapshot.dump(log);
    }

    protected Cell getLowest(Cell a, Cell b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return this.comparator.compareRows(a, b) <= 0 ? a : b;
    }

    protected Cell getNextRow(Cell key, NavigableSet<Cell> set) {
        Cell result = null;
        NavigableSet<Cell> tail = key == null ? set : set.tailSet(key);
        for (Cell cell : tail) {
            if (this.comparator.compareRows(cell, key) <= 0) continue;
            result = cell;
            break;
        }
        return result;
    }

    private Cell maybeCloneWithAllocator(MutableSegment currentActive, Cell cell, boolean forceCloneOfBigCell) {
        return currentActive.maybeCloneWithAllocator(cell, forceCloneOfBigCell);
    }

    private void internalAdd(MutableSegment currentActive, Cell toAdd, boolean mslabUsed, MemStoreSizing memstoreSizing) {
        boolean sizeAddedPreOperation = this.sizeAddedPreOperation();
        currentActive.add(toAdd, mslabUsed, memstoreSizing, sizeAddedPreOperation);
        this.setOldestEditTimeToNow();
    }

    protected abstract boolean sizeAddedPreOperation();

    private void setOldestEditTimeToNow() {
        if (this.timeOfOldestEdit == Long.MAX_VALUE) {
            this.timeOfOldestEdit = EnvironmentEdgeManager.currentTime();
        }
    }

    protected abstract long keySize();

    protected abstract long heapSize();

    protected CellComparator getComparator() {
        return this.comparator;
    }

    MutableSegment getActive() {
        return this.active;
    }

    ImmutableSegment getSnapshot() {
        return this.snapshot;
    }

    protected abstract List<Segment> getSegments() throws IOException;

    static {
        DEEP_OVERHEAD = FIXED_OVERHEAD = (long)ClassSize.OBJECT + (long)(5 * ClassSize.REFERENCE) + 16L;
    }
}

