/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.regionserver;

import io.hops.hudi.org.apache.hadoop.hbase.Cell;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.AbstractMultiFileWriter;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class DateTieredMultiFileWriter
extends AbstractMultiFileWriter {
    private final NavigableMap<Long, StoreFileWriter> lowerBoundary2Writer = new TreeMap<Long, StoreFileWriter>();
    private final boolean needEmptyFile;
    private final Map<Long, String> lowerBoundariesPolicies;

    public DateTieredMultiFileWriter(List<Long> lowerBoundaries, Map<Long, String> lowerBoundariesPolicies, boolean needEmptyFile) {
        for (Long lowerBoundary : lowerBoundaries) {
            this.lowerBoundary2Writer.put(lowerBoundary, null);
        }
        this.needEmptyFile = needEmptyFile;
        this.lowerBoundariesPolicies = lowerBoundariesPolicies;
    }

    @Override
    public void append(Cell cell) throws IOException {
        Map.Entry<Long, StoreFileWriter> entry = this.lowerBoundary2Writer.floorEntry(cell.getTimestamp());
        StoreFileWriter writer = entry.getValue();
        if (writer == null) {
            String lowerBoundaryStoragePolicy = this.lowerBoundariesPolicies.get(entry.getKey());
            writer = lowerBoundaryStoragePolicy != null ? this.writerFactory.createWriterWithStoragePolicy(lowerBoundaryStoragePolicy) : this.writerFactory.createWriter();
            this.lowerBoundary2Writer.put(entry.getKey(), writer);
        }
        writer.append(cell);
    }

    @Override
    protected Collection<StoreFileWriter> writers() {
        return this.lowerBoundary2Writer.values();
    }

    @Override
    protected void preCommitWriters() throws IOException {
        if (!this.needEmptyFile) {
            return;
        }
        for (StoreFileWriter writer : this.lowerBoundary2Writer.values()) {
            if (writer == null) continue;
            return;
        }
        this.lowerBoundary2Writer.put((Long)this.lowerBoundary2Writer.firstKey(), this.writerFactory.createWriter());
    }
}

