/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.regionserver;

import io.hops.hudi.org.apache.hadoop.hbase.regionserver.FlushLargeStoresPolicy;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.HRegion;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.HStore;
import java.util.Collection;
import java.util.HashSet;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class FlushNonSloppyStoresFirstPolicy
extends FlushLargeStoresPolicy {
    private Collection<HStore> regularStores = new HashSet<HStore>();
    private Collection<HStore> sloppyStores = new HashSet<HStore>();

    @Override
    public Collection<HStore> selectStoresToFlush() {
        HashSet<HStore> specificStoresToFlush = new HashSet<HStore>();
        for (HStore store : this.regularStores) {
            if (!this.shouldFlush(store) && !this.region.shouldFlushStore(store)) continue;
            specificStoresToFlush.add(store);
        }
        if (!specificStoresToFlush.isEmpty()) {
            return specificStoresToFlush;
        }
        for (HStore store : this.sloppyStores) {
            if (!this.shouldFlush(store)) continue;
            specificStoresToFlush.add(store);
        }
        if (!specificStoresToFlush.isEmpty()) {
            return specificStoresToFlush;
        }
        return this.region.stores.values();
    }

    @Override
    protected void configureForRegion(HRegion region) {
        super.configureForRegion(region);
        this.setFlushSizeLowerBounds(region);
        for (HStore store : region.stores.values()) {
            if (store.isSloppyMemStore()) {
                this.sloppyStores.add(store);
                continue;
            }
            this.regularStores.add(store);
        }
    }
}

