/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.regionserver;

import io.hops.hudi.org.apache.hadoop.hbase.Cell;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.Chunk;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.ChunkCreator;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.MemStoreLAB;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ImmutableMemStoreLAB
implements MemStoreLAB {
    private final AtomicInteger openScannerCount = new AtomicInteger();
    private volatile boolean closed = false;
    private final List<MemStoreLAB> mslabs;

    public ImmutableMemStoreLAB(List<MemStoreLAB> mslabs) {
        this.mslabs = mslabs;
    }

    @Override
    public Cell copyCellInto(Cell cell) {
        throw new IllegalStateException("This is an Immutable MemStoreLAB.");
    }

    @Override
    public Cell forceCopyOfBigCellInto(Cell cell) {
        MemStoreLAB mslab = this.mslabs.get(0);
        return mslab.forceCopyOfBigCellInto(cell);
    }

    @Override
    public Chunk getNewExternalChunk(ChunkCreator.ChunkType chunkType) {
        MemStoreLAB mslab = this.mslabs.get(0);
        return mslab.getNewExternalChunk(chunkType);
    }

    @Override
    public Chunk getNewExternalChunk(int size) {
        MemStoreLAB mslab = this.mslabs.get(0);
        return mslab.getNewExternalChunk(size);
    }

    @Override
    public void close() {
        this.closed = true;
        this.checkAndCloseMSLABs(this.openScannerCount.get());
    }

    private void checkAndCloseMSLABs(int openScanners) {
        if (openScanners == 0) {
            for (MemStoreLAB mslab : this.mslabs) {
                mslab.close();
            }
        }
    }

    @Override
    public void incScannerCount() {
        this.openScannerCount.incrementAndGet();
    }

    @Override
    public void decScannerCount() {
        int count = this.openScannerCount.decrementAndGet();
        if (this.closed) {
            this.checkAndCloseMSLABs(count);
        }
    }

    @Override
    public boolean isOnHeap() {
        return !this.isOffHeap();
    }

    @Override
    public boolean isOffHeap() {
        return ChunkCreator.getInstance().isOffheap();
    }
}

