/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.regionserver;

import io.hops.hudi.org.apache.hadoop.hbase.Cell;
import io.hops.hudi.org.apache.hadoop.hbase.CellComparator;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.AbstractMemStore;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.KeyValueHeap;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.MemStoreSegmentsIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MemStoreMergerSegmentsIterator
extends MemStoreSegmentsIterator {
    private KeyValueHeap heap = null;
    List<KeyValueScanner> scanners = new ArrayList<KeyValueScanner>();
    private boolean closed = false;

    public MemStoreMergerSegmentsIterator(List<ImmutableSegment> segments, CellComparator comparator, int compactionKVMax) throws IOException {
        super(compactionKVMax);
        AbstractMemStore.addToScanners(segments, Long.MAX_VALUE, this.scanners);
        this.heap = new KeyValueHeap(this.scanners, comparator);
    }

    @Override
    public boolean hasNext() {
        if (this.closed) {
            return false;
        }
        if (this.heap != null) {
            return this.heap.peek() != null;
        }
        return false;
    }

    @Override
    public Cell next() {
        try {
            if (!this.closed && this.heap != null) {
                return this.heap.next();
            }
        }
        catch (IOException ie) {
            throw new IllegalStateException(ie);
        }
        return null;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        if (this.heap != null) {
            this.heap.close();
            this.heap = null;
        } else {
            for (KeyValueScanner scanner : this.scanners) {
                scanner.close();
            }
        }
        this.closed = true;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

