/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.regionserver;

import io.hops.hudi.org.apache.hadoop.hbase.Cell;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.NonReversedNonLazyKeyValueScanner;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.Segment;
import java.util.Iterator;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class SnapshotSegmentScanner
extends NonReversedNonLazyKeyValueScanner {
    private final ImmutableSegment segment;
    private Iterator<Cell> iter;
    private Cell current;

    public SnapshotSegmentScanner(ImmutableSegment segment) {
        this.segment = segment;
        this.segment.incScannerCount();
        this.iter = SnapshotSegmentScanner.createIterator(this.segment);
        if (this.iter.hasNext()) {
            this.current = this.iter.next();
        }
    }

    private static Iterator<Cell> createIterator(Segment segment) {
        return segment.getCellSet().iterator();
    }

    @Override
    public Cell peek() {
        return this.current;
    }

    @Override
    public Cell next() {
        Cell oldCurrent = this.current;
        this.current = this.iter.hasNext() ? this.iter.next() : null;
        return oldCurrent;
    }

    @Override
    public boolean seek(Cell seekCell) {
        this.iter = SnapshotSegmentScanner.createIterator(this.segment);
        return this.reseek(seekCell);
    }

    @Override
    public boolean reseek(Cell seekCell) {
        while (this.iter.hasNext()) {
            Cell next = this.iter.next();
            int ret = this.segment.getComparator().compare(next, seekCell);
            if (ret < 0) continue;
            this.current = next;
            return true;
        }
        return false;
    }

    @Override
    public long getScannerOrder() {
        return 0L;
    }

    @Override
    public void close() {
        this.segment.decScannerCount();
    }
}

