/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.regionserver;

import io.hops.hudi.org.apache.hadoop.hbase.TableName;
import io.hops.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import io.hops.hudi.org.apache.hadoop.hbase.client.RegionInfoBuilder;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.HRegionServer;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.Region;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.RegionServerServices;
import io.hops.hudi.org.apache.hadoop.hbase.security.User;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import io.hops.hudi.org.apache.hadoop.hbase.util.Bytes;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class SplitRequest
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(SplitRequest.class);
    private final RegionInfo parent;
    private final byte[] midKey;
    private final HRegionServer server;
    private final User user;

    SplitRequest(Region region, byte[] midKey, HRegionServer hrs, User user) {
        Preconditions.checkNotNull(hrs);
        this.parent = region.getRegionInfo();
        this.midKey = midKey;
        this.server = hrs;
        this.user = user;
    }

    public String toString() {
        return "regionName=" + this.parent + ", midKey=" + Bytes.toStringBinary(this.midKey);
    }

    private void doSplitting() {
        this.server.getMetrics().incrSplitRequest();
        if (this.user != null && this.user.getUGI() != null) {
            this.user.getUGI().doAs(() -> {
                this.requestRegionSplit();
                return null;
            });
        } else {
            this.requestRegionSplit();
        }
    }

    private void requestRegionSplit() {
        TableName table = this.parent.getTable();
        RegionInfo hri_a = RegionInfoBuilder.newBuilder(table).setStartKey(this.parent.getStartKey()).setEndKey(this.midKey).build();
        RegionInfo hri_b = RegionInfoBuilder.newBuilder(table).setStartKey(this.midKey).setEndKey(this.parent.getEndKey()).build();
        if (!this.server.reportRegionStateTransition(new RegionServerServices.RegionStateTransitionContext(RegionServerStatusProtos.RegionStateTransition.TransitionCode.READY_TO_SPLIT, -1L, -1L, this.parent, hri_a, hri_b))) {
            LOG.error("Unable to ask master to split " + this.parent.getRegionNameAsString());
        }
    }

    @Override
    public void run() {
        if (this.server.isStopping() || this.server.isStopped()) {
            LOG.debug("Skipping split because server is stopping=" + this.server.isStopping() + " or stopped=" + this.server.isStopped());
            return;
        }
        this.doSplitting();
    }
}

