/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.regionserver;

import io.hops.hudi.org.apache.hadoop.hbase.regionserver.MemStoreSize;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.MemStoreSizing;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class ThreadSafeMemStoreSizing
implements MemStoreSizing {
    private final AtomicLong dataSize = new AtomicLong();
    private final AtomicLong heapSize = new AtomicLong();
    private final AtomicLong offHeapSize = new AtomicLong();
    private final AtomicInteger cellsCount = new AtomicInteger();

    ThreadSafeMemStoreSizing() {
        this(0L, 0L, 0L, 0);
    }

    ThreadSafeMemStoreSizing(MemStoreSize mss) {
        this(mss.getDataSize(), mss.getHeapSize(), mss.getOffHeapSize(), mss.getCellsCount());
    }

    ThreadSafeMemStoreSizing(long dataSize, long heapSize, long offHeapSize, int cellsCount) {
        this.incMemStoreSize(dataSize, heapSize, offHeapSize, cellsCount);
    }

    @Override
    public MemStoreSize getMemStoreSize() {
        return new MemStoreSize(this.getDataSize(), this.getHeapSize(), this.getOffHeapSize(), this.getCellsCount());
    }

    @Override
    public long incMemStoreSize(long dataSizeDelta, long heapSizeDelta, long offHeapSizeDelta, int cellsCountDelta) {
        this.offHeapSize.addAndGet(offHeapSizeDelta);
        this.heapSize.addAndGet(heapSizeDelta);
        this.cellsCount.addAndGet(cellsCountDelta);
        return this.dataSize.addAndGet(dataSizeDelta);
    }

    @Override
    public boolean compareAndSetDataSize(long expected, long updated) {
        return this.dataSize.compareAndSet(expected, updated);
    }

    @Override
    public long getDataSize() {
        return this.dataSize.get();
    }

    @Override
    public long getHeapSize() {
        return this.heapSize.get();
    }

    @Override
    public long getOffHeapSize() {
        return this.offHeapSize.get();
    }

    @Override
    public int getCellsCount() {
        return this.cellsCount.get();
    }

    public String toString() {
        return this.getMemStoreSize().toString();
    }
}

