/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.regionserver.compactions;

import io.hops.hudi.org.apache.hadoop.hbase.regionserver.compactions.CompactionConfiguration;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.compactions.CompactionWindow;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.compactions.CompactionWindowFactory;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.math.LongMath;
import org.apache.hadoop.conf.Configuration;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class ExponentialCompactionWindowFactory
extends CompactionWindowFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ExponentialCompactionWindowFactory.class);
    public static final String BASE_WINDOW_MILLIS_KEY = "hbase.hstore.compaction.date.tiered.base.window.millis";
    public static final String WINDOWS_PER_TIER_KEY = "hbase.hstore.compaction.date.tiered.windows.per.tier";
    public static final String MAX_TIER_AGE_MILLIS_KEY = "hbase.hstore.compaction.date.tiered.max.tier.age.millis";
    private final long baseWindowMillis;
    private final int windowsPerTier;
    private final long maxTierAgeMillis;

    private long getMaxTierAgeCutoff(long now) {
        try {
            return LongMath.checkedSubtract(now, this.maxTierAgeMillis);
        }
        catch (ArithmeticException ae) {
            LOG.warn("Value for hbase.hstore.compaction.date.tiered.max.tier.age.millis: " + this.maxTierAgeMillis + ". Will always promote to next tier.");
            return Long.MIN_VALUE;
        }
    }

    public ExponentialCompactionWindowFactory(CompactionConfiguration comConf) {
        Configuration conf = comConf.conf;
        this.baseWindowMillis = conf.getLong(BASE_WINDOW_MILLIS_KEY, 21600000L);
        this.windowsPerTier = conf.getInt(WINDOWS_PER_TIER_KEY, 4);
        this.maxTierAgeMillis = conf.getLong(MAX_TIER_AGE_MILLIS_KEY, comConf.getDateTieredMaxStoreFileAgeMillis());
        LOG.info(this.toString());
    }

    @Override
    public CompactionWindow newIncomingWindow(long now) {
        return new Window(this.baseWindowMillis, now / this.baseWindowMillis, this.getMaxTierAgeCutoff(now));
    }

    public String toString() {
        return String.format("%s [base window in milliseconds %d, windows per tier %d, max tier age in milliseconds %d]", this.getClass().getSimpleName(), this.baseWindowMillis, this.windowsPerTier, this.maxTierAgeMillis);
    }

    private final class Window
    extends CompactionWindow {
        private final long maxTierAgeCutoff;
        private final long windowMillis;
        private final long divPosition;

        public Window(long baseWindowMillis, long divPosition, long maxTierAgeCutoff) {
            this.windowMillis = baseWindowMillis;
            this.divPosition = divPosition;
            this.maxTierAgeCutoff = maxTierAgeCutoff;
        }

        @Override
        public int compareToTimestamp(long timestamp) {
            long pos;
            if (timestamp < 0L) {
                try {
                    timestamp = LongMath.checkedSubtract(timestamp, this.windowMillis - 1L);
                }
                catch (ArithmeticException ae) {
                    timestamp = Long.MIN_VALUE;
                }
            }
            return this.divPosition == (pos = timestamp / this.windowMillis) ? 0 : (this.divPosition < pos ? -1 : 1);
        }

        @Override
        public Window nextEarlierWindow() {
            if (this.divPosition % (long)ExponentialCompactionWindowFactory.this.windowsPerTier > 0L || this.startMillis() - this.windowMillis * (long)ExponentialCompactionWindowFactory.this.windowsPerTier < this.maxTierAgeCutoff) {
                return new Window(this.windowMillis, this.divPosition - 1L, this.maxTierAgeCutoff);
            }
            return new Window(this.windowMillis * (long)ExponentialCompactionWindowFactory.this.windowsPerTier, this.divPosition / (long)ExponentialCompactionWindowFactory.this.windowsPerTier - 1L, this.maxTierAgeCutoff);
        }

        @Override
        public long startMillis() {
            try {
                return LongMath.checkedMultiply(this.windowMillis, this.divPosition);
            }
            catch (ArithmeticException ae) {
                return Long.MIN_VALUE;
            }
        }

        @Override
        public long endMillis() {
            try {
                return LongMath.checkedMultiply(this.windowMillis, this.divPosition + 1L);
            }
            catch (ArithmeticException ae) {
                return Long.MAX_VALUE;
            }
        }
    }
}

