/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.regionserver.wal;

import io.hops.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import io.hops.hudi.org.apache.hadoop.hbase.wal.WALEdit;
import io.hops.hudi.org.apache.hadoop.hbase.wal.WALKey;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public interface WALActionsListener {
    default public void preLogRoll(Path oldPath, Path newPath) throws IOException {
    }

    default public void postLogRoll(Path oldPath, Path newPath) throws IOException {
    }

    default public void preLogArchive(Path oldPath, Path newPath) throws IOException {
    }

    default public void postLogArchive(Path oldPath, Path newPath) throws IOException {
    }

    default public void logRollRequested(RollRequestReason reason) {
    }

    default public void logCloseRequested() {
    }

    default public void visitLogEntryBeforeWrite(RegionInfo info, WALKey logKey, WALEdit logEdit) {
    }

    default public void visitLogEntryBeforeWrite(WALKey logKey, WALEdit logEdit) throws IOException {
    }

    default public void postAppend(long entryLen, long elapsedTimeMillis, WALKey logKey, WALEdit logEdit) throws IOException {
    }

    default public void postSync(long timeInNanos, int handlerSyncs) {
    }

    public static enum RollRequestReason {
        SIZE,
        LOW_REPLICATION,
        SLOW_SYNC,
        ERROR;

    }
}

