/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.security.token;

import io.hops.hudi.org.apache.hadoop.hbase.security.token.AuthenticationTokenIdentifier;
import java.util.Collection;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenSelector;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class AuthenticationTokenSelector
implements TokenSelector<AuthenticationTokenIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationTokenSelector.class);

    public Token<AuthenticationTokenIdentifier> selectToken(Text serviceName, Collection<Token<? extends TokenIdentifier>> tokens) {
        if (serviceName != null) {
            for (Token<? extends TokenIdentifier> ident : tokens) {
                if (!serviceName.equals((Object)ident.getService()) || !AuthenticationTokenIdentifier.AUTH_TOKEN_TYPE.equals((Object)ident.getKind())) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Returning token " + ident);
                }
                return ident;
            }
        }
        LOG.debug("No matching token found");
        return null;
    }
}

