/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.security.visibility;

import io.hops.hudi.com.google.protobuf.ByteString;
import io.hops.hudi.org.apache.hadoop.hbase.ArrayBackedTag;
import io.hops.hudi.org.apache.hadoop.hbase.Cell;
import io.hops.hudi.org.apache.hadoop.hbase.PrivateCellUtil;
import io.hops.hudi.org.apache.hadoop.hbase.Tag;
import io.hops.hudi.org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import io.hops.hudi.org.apache.hadoop.hbase.exceptions.DeserializationException;
import io.hops.hudi.org.apache.hadoop.hbase.filter.Filter;
import io.hops.hudi.org.apache.hadoop.hbase.io.util.StreamUtils;
import io.hops.hudi.org.apache.hadoop.hbase.ipc.RpcServer;
import io.hops.hudi.org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import io.hops.hudi.org.apache.hadoop.hbase.protobuf.generated.VisibilityLabelsProtos;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.Region;
import io.hops.hudi.org.apache.hadoop.hbase.security.AccessDeniedException;
import io.hops.hudi.org.apache.hadoop.hbase.security.User;
import io.hops.hudi.org.apache.hadoop.hbase.security.visibility.Authorizations;
import io.hops.hudi.org.apache.hadoop.hbase.security.visibility.DefinedSetFilterScanLabelGenerator;
import io.hops.hudi.org.apache.hadoop.hbase.security.visibility.ExpressionExpander;
import io.hops.hudi.org.apache.hadoop.hbase.security.visibility.ExpressionParser;
import io.hops.hudi.org.apache.hadoop.hbase.security.visibility.FeedUserAuthScanLabelGenerator;
import io.hops.hudi.org.apache.hadoop.hbase.security.visibility.InvalidLabelException;
import io.hops.hudi.org.apache.hadoop.hbase.security.visibility.ParseException;
import io.hops.hudi.org.apache.hadoop.hbase.security.visibility.ScanLabelGenerator;
import io.hops.hudi.org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import io.hops.hudi.org.apache.hadoop.hbase.security.visibility.VisibilityLabelFilter;
import io.hops.hudi.org.apache.hadoop.hbase.security.visibility.VisibilityLabelOrdinalProvider;
import io.hops.hudi.org.apache.hadoop.hbase.security.visibility.VisibilityLabelService;
import io.hops.hudi.org.apache.hadoop.hbase.security.visibility.VisibilityLabelServiceManager;
import io.hops.hudi.org.apache.hadoop.hbase.security.visibility.expression.ExpressionNode;
import io.hops.hudi.org.apache.hadoop.hbase.security.visibility.expression.LeafExpressionNode;
import io.hops.hudi.org.apache.hadoop.hbase.security.visibility.expression.NonLeafExpressionNode;
import io.hops.hudi.org.apache.hadoop.hbase.security.visibility.expression.Operator;
import io.hops.hudi.org.apache.hadoop.hbase.util.ByteRange;
import io.hops.hudi.org.apache.hadoop.hbase.util.Bytes;
import io.hops.hudi.org.apache.hadoop.hbase.util.SimpleMutableByteRange;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class VisibilityUtils {
    private static final Logger LOG = LoggerFactory.getLogger(VisibilityUtils.class);
    public static final String VISIBILITY_LABEL_GENERATOR_CLASS = "hbase.regionserver.scan.visibility.label.generator.class";
    public static final String SYSTEM_LABEL = "system";
    public static final Tag SORTED_ORDINAL_SERIALIZATION_FORMAT_TAG = new ArrayBackedTag(4, VisibilityConstants.SORTED_ORDINAL_SERIALIZATION_FORMAT_TAG_VAL);
    private static final String COMMA = ",";
    private static final ExpressionParser EXP_PARSER = new ExpressionParser();
    private static final ExpressionExpander EXP_EXPANDER = new ExpressionExpander();

    public static byte[] getDataToWriteToZooKeeper(Map<String, Integer> existingLabels) {
        VisibilityLabelsProtos.VisibilityLabelsRequest.Builder visReqBuilder = VisibilityLabelsProtos.VisibilityLabelsRequest.newBuilder();
        for (Map.Entry<String, Integer> entry : existingLabels.entrySet()) {
            VisibilityLabelsProtos.VisibilityLabel.Builder visLabBuilder = VisibilityLabelsProtos.VisibilityLabel.newBuilder();
            visLabBuilder.setLabel(ByteString.copyFrom(Bytes.toBytes(entry.getKey())));
            visLabBuilder.setOrdinal(entry.getValue());
            visReqBuilder.addVisLabel(visLabBuilder.build());
        }
        return ProtobufUtil.prependPBMagic(visReqBuilder.build().toByteArray());
    }

    public static byte[] getUserAuthsDataToWriteToZooKeeper(Map<String, List<Integer>> userAuths) {
        VisibilityLabelsProtos.MultiUserAuthorizations.Builder builder = VisibilityLabelsProtos.MultiUserAuthorizations.newBuilder();
        for (Map.Entry<String, List<Integer>> entry : userAuths.entrySet()) {
            VisibilityLabelsProtos.UserAuthorizations.Builder userAuthsBuilder = VisibilityLabelsProtos.UserAuthorizations.newBuilder();
            userAuthsBuilder.setUser(ByteString.copyFrom(Bytes.toBytes(entry.getKey())));
            for (Integer label : entry.getValue()) {
                userAuthsBuilder.addAuth(label);
            }
            builder.addUserAuths(userAuthsBuilder.build());
        }
        return ProtobufUtil.prependPBMagic(builder.build().toByteArray());
    }

    public static List<VisibilityLabelsProtos.VisibilityLabel> readLabelsFromZKData(byte[] data) throws DeserializationException {
        if (ProtobufUtil.isPBMagicPrefix(data)) {
            int pblen = ProtobufUtil.lengthOfPBMagic();
            try {
                VisibilityLabelsProtos.VisibilityLabelsRequest.Builder builder = VisibilityLabelsProtos.VisibilityLabelsRequest.newBuilder();
                ProtobufUtil.mergeFrom(builder, data, pblen, data.length - pblen);
                return builder.getVisLabelList();
            }
            catch (IOException e) {
                throw new DeserializationException(e);
            }
        }
        return null;
    }

    public static VisibilityLabelsProtos.MultiUserAuthorizations readUserAuthsFromZKData(byte[] data) throws DeserializationException {
        if (ProtobufUtil.isPBMagicPrefix(data)) {
            int pblen = ProtobufUtil.lengthOfPBMagic();
            try {
                VisibilityLabelsProtos.MultiUserAuthorizations.Builder builder = VisibilityLabelsProtos.MultiUserAuthorizations.newBuilder();
                ProtobufUtil.mergeFrom(builder, data, pblen, data.length - pblen);
                return builder.build();
            }
            catch (IOException e) {
                throw new DeserializationException(e);
            }
        }
        return null;
    }

    public static List<ScanLabelGenerator> getScanLabelGenerators(Configuration conf) {
        String slgClassesCommaSeparated = conf.get(VISIBILITY_LABEL_GENERATOR_CLASS);
        ArrayList<ScanLabelGenerator> slgs = new ArrayList<ScanLabelGenerator>();
        if (StringUtils.isNotEmpty((CharSequence)slgClassesCommaSeparated)) {
            String[] slgClasses;
            for (String slgClass : slgClasses = slgClassesCommaSeparated.split(COMMA)) {
                try {
                    Class slgKlass = conf.getClassByName(slgClass.trim());
                    slgs.add((ScanLabelGenerator)ReflectionUtils.newInstance((Class)slgKlass, (Configuration)conf));
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Unable to find " + slgClass, e);
                }
            }
        }
        if (slgs.isEmpty()) {
            slgs.add((ScanLabelGenerator)ReflectionUtils.newInstance(FeedUserAuthScanLabelGenerator.class, (Configuration)conf));
            slgs.add((ScanLabelGenerator)ReflectionUtils.newInstance(DefinedSetFilterScanLabelGenerator.class, (Configuration)conf));
        }
        return slgs;
    }

    public static Byte extractVisibilityTags(Cell cell, List<Tag> tags) {
        Byte serializationFormat = null;
        Iterator<Tag> tagsIterator = PrivateCellUtil.tagsIterator(cell);
        while (tagsIterator.hasNext()) {
            Tag tag = tagsIterator.next();
            if (tag.getType() == 4) {
                serializationFormat = Tag.getValueAsByte(tag);
                continue;
            }
            if (tag.getType() != 2) continue;
            tags.add(tag);
        }
        return serializationFormat;
    }

    public static Byte extractAndPartitionTags(Cell cell, List<Tag> visTags, List<Tag> nonVisTags) {
        Byte serializationFormat = null;
        Iterator<Tag> tagsIterator = PrivateCellUtil.tagsIterator(cell);
        while (tagsIterator.hasNext()) {
            Tag tag = tagsIterator.next();
            if (tag.getType() == 4) {
                serializationFormat = Tag.getValueAsByte(tag);
                continue;
            }
            if (tag.getType() == 2) {
                visTags.add(tag);
                continue;
            }
            nonVisTags.add(tag);
        }
        return serializationFormat;
    }

    public static boolean isVisibilityTagsPresent(Cell cell) {
        Iterator<Tag> tagsIterator = PrivateCellUtil.tagsIterator(cell);
        while (tagsIterator.hasNext()) {
            Tag tag = tagsIterator.next();
            if (tag.getType() != 2) continue;
            return true;
        }
        return false;
    }

    public static Filter createVisibilityLabelFilter(Region region, Authorizations authorizations) throws IOException {
        HashMap<ByteRange, Integer> cfVsMaxVersions = new HashMap<ByteRange, Integer>();
        for (ColumnFamilyDescriptor hcd : region.getTableDescriptor().getColumnFamilies()) {
            cfVsMaxVersions.put(new SimpleMutableByteRange(hcd.getName()), hcd.getMaxVersions());
        }
        VisibilityLabelService vls = VisibilityLabelServiceManager.getInstance().getVisibilityLabelService();
        VisibilityLabelFilter visibilityLabelFilter = new VisibilityLabelFilter(vls.getVisibilityExpEvaluator(authorizations), cfVsMaxVersions);
        return visibilityLabelFilter;
    }

    public static User getActiveUser() throws IOException {
        Optional<User> optionalUser = RpcServer.getRequestUser();
        User user = optionalUser.isPresent() ? optionalUser.get() : User.getCurrent();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Current active user name is " + user.getShortName());
        }
        return user;
    }

    public static List<Tag> createVisibilityExpTags(String visExpression, boolean withSerializationFormat, boolean checkAuths, Set<Integer> auths, VisibilityLabelOrdinalProvider ordinalProvider) throws IOException {
        ExpressionNode node = null;
        try {
            node = EXP_PARSER.parse(visExpression);
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
        node = EXP_EXPANDER.expand(node);
        ArrayList<Tag> tags = new ArrayList<Tag>();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        ArrayList<Integer> labelOrdinals = new ArrayList<Integer>();
        if (withSerializationFormat) {
            tags.add(SORTED_ORDINAL_SERIALIZATION_FORMAT_TAG);
        }
        if (node.isSingleNode()) {
            VisibilityUtils.getLabelOrdinals(node, labelOrdinals, auths, checkAuths, ordinalProvider);
            VisibilityUtils.writeLabelOrdinalsToStream(labelOrdinals, dos);
            tags.add(new ArrayBackedTag(2, baos.toByteArray()));
            baos.reset();
        } else {
            NonLeafExpressionNode nlNode = (NonLeafExpressionNode)node;
            if (nlNode.getOperator() == Operator.OR) {
                for (ExpressionNode child : nlNode.getChildExps()) {
                    VisibilityUtils.getLabelOrdinals(child, labelOrdinals, auths, checkAuths, ordinalProvider);
                    VisibilityUtils.writeLabelOrdinalsToStream(labelOrdinals, dos);
                    tags.add(new ArrayBackedTag(2, baos.toByteArray()));
                    baos.reset();
                    labelOrdinals.clear();
                }
            } else {
                VisibilityUtils.getLabelOrdinals(nlNode, labelOrdinals, auths, checkAuths, ordinalProvider);
                VisibilityUtils.writeLabelOrdinalsToStream(labelOrdinals, dos);
                tags.add(new ArrayBackedTag(2, baos.toByteArray()));
                baos.reset();
            }
        }
        return tags;
    }

    private static void getLabelOrdinals(ExpressionNode node, List<Integer> labelOrdinals, Set<Integer> auths, boolean checkAuths, VisibilityLabelOrdinalProvider ordinalProvider) throws IOException, InvalidLabelException {
        if (node.isSingleNode()) {
            String identifier = null;
            int labelOrdinal = 0;
            if (node instanceof LeafExpressionNode) {
                identifier = ((LeafExpressionNode)node).getIdentifier();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("The identifier is " + identifier);
                }
                labelOrdinal = ordinalProvider.getLabelOrdinal(identifier);
                VisibilityUtils.checkAuths(auths, labelOrdinal, identifier, checkAuths);
            } else {
                LeafExpressionNode lNode = (LeafExpressionNode)((NonLeafExpressionNode)node).getChildExps().get(0);
                identifier = lNode.getIdentifier();
                labelOrdinal = ordinalProvider.getLabelOrdinal(identifier);
                VisibilityUtils.checkAuths(auths, labelOrdinal, identifier, checkAuths);
                labelOrdinal = -1 * labelOrdinal;
            }
            if (labelOrdinal == 0) {
                throw new InvalidLabelException("Invalid visibility label " + identifier);
            }
            labelOrdinals.add(labelOrdinal);
        } else {
            List<ExpressionNode> childExps = ((NonLeafExpressionNode)node).getChildExps();
            for (ExpressionNode child : childExps) {
                VisibilityUtils.getLabelOrdinals(child, labelOrdinals, auths, checkAuths, ordinalProvider);
            }
        }
    }

    private static void writeLabelOrdinalsToStream(List<Integer> labelOrdinals, DataOutputStream dos) throws IOException {
        Collections.sort(labelOrdinals);
        for (Integer labelOrdinal : labelOrdinals) {
            StreamUtils.writeRawVInt32(dos, labelOrdinal);
        }
    }

    private static void checkAuths(Set<Integer> auths, int labelOrdinal, String identifier, boolean checkAuths) throws IOException {
        if (checkAuths && (auths == null || !auths.contains(labelOrdinal))) {
            throw new AccessDeniedException("Visibility label " + identifier + " not authorized for the user " + VisibilityUtils.getActiveUser().getShortName());
        }
    }
}

