/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.snapshot;

import io.hops.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import io.hops.hudi.org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import io.hops.hudi.org.apache.hadoop.hbase.util.CommonFSUtils;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.protobuf.CodedInputStream;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class SnapshotManifestV2 {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotManifestV2.class);
    public static final int DESCRIPTOR_VERSION = 2;
    public static final String SNAPSHOT_MANIFEST_PREFIX = "region-manifest.";

    private SnapshotManifestV2() {
    }

    static List<SnapshotProtos.SnapshotRegionManifest> loadRegionManifests(Configuration conf, Executor executor, final FileSystem fs, Path snapshotDir, SnapshotProtos.SnapshotDescription desc, final int manifestSizeLimit) throws IOException {
        FileStatus[] manifestFiles = CommonFSUtils.listStatus(fs, snapshotDir, new PathFilter(){

            public boolean accept(Path path) {
                return path.getName().startsWith(SnapshotManifestV2.SNAPSHOT_MANIFEST_PREFIX);
            }
        });
        if (manifestFiles == null || manifestFiles.length == 0) {
            return null;
        }
        ExecutorCompletionService<SnapshotProtos.SnapshotRegionManifest> completionService = new ExecutorCompletionService<SnapshotProtos.SnapshotRegionManifest>(executor);
        for (final FileStatus st : manifestFiles) {
            completionService.submit(new Callable<SnapshotProtos.SnapshotRegionManifest>(){

                @Override
                public SnapshotProtos.SnapshotRegionManifest call() throws IOException {
                    try (FSDataInputStream stream = fs.open(st.getPath());){
                        CodedInputStream cin = CodedInputStream.newInstance((InputStream)stream);
                        cin.setSizeLimit(manifestSizeLimit);
                        SnapshotProtos.SnapshotRegionManifest snapshotRegionManifest = SnapshotProtos.SnapshotRegionManifest.parseFrom(cin);
                        return snapshotRegionManifest;
                    }
                }
            });
        }
        ArrayList<SnapshotProtos.SnapshotRegionManifest> regionsManifest = new ArrayList<SnapshotProtos.SnapshotRegionManifest>(manifestFiles.length);
        try {
            for (int i = 0; i < manifestFiles.length; ++i) {
                regionsManifest.add((SnapshotProtos.SnapshotRegionManifest)completionService.take().get());
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.getMessage());
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof InvalidProtocolBufferException) {
                throw (InvalidProtocolBufferException)t;
            }
            throw new IOException("ExecutionException", e.getCause());
        }
        return regionsManifest;
    }

    static void deleteRegionManifest(FileSystem fs, Path snapshotDir, SnapshotProtos.SnapshotRegionManifest manifest) throws IOException {
        fs.delete(SnapshotManifestV2.getRegionManifestPath(snapshotDir, manifest), true);
    }

    private static Path getRegionManifestPath(Path snapshotDir, SnapshotProtos.SnapshotRegionManifest manifest) {
        String regionName = SnapshotManifest.getRegionNameFromManifest(manifest);
        return new Path(snapshotDir, SNAPSHOT_MANIFEST_PREFIX + regionName);
    }

    static class ManifestBuilder
    implements SnapshotManifest.RegionVisitor<SnapshotProtos.SnapshotRegionManifest.Builder, SnapshotProtos.SnapshotRegionManifest.FamilyFiles.Builder> {
        private final Configuration conf;
        private final Path snapshotDir;
        private final FileSystem rootFs;

        public ManifestBuilder(Configuration conf, FileSystem rootFs, Path snapshotDir) {
            this.snapshotDir = snapshotDir;
            this.conf = conf;
            this.rootFs = rootFs;
        }

        @Override
        public SnapshotProtos.SnapshotRegionManifest.Builder regionOpen(RegionInfo regionInfo) {
            SnapshotProtos.SnapshotRegionManifest.Builder manifest = SnapshotProtos.SnapshotRegionManifest.newBuilder();
            manifest.setRegionInfo(ProtobufUtil.toRegionInfo(regionInfo));
            return manifest;
        }

        @Override
        public void regionClose(SnapshotProtos.SnapshotRegionManifest.Builder region) throws IOException {
            FileSystem workingDirFs = this.snapshotDir.getFileSystem(this.conf);
            if (workingDirFs.exists(this.snapshotDir)) {
                SnapshotProtos.SnapshotRegionManifest manifest = region.build();
                try (FSDataOutputStream stream = workingDirFs.create(SnapshotManifestV2.getRegionManifestPath(this.snapshotDir, manifest));){
                    manifest.writeTo((OutputStream)stream);
                }
            } else {
                LOG.warn("can't write manifest without parent dir, maybe it has been deleted by master?");
            }
        }

        @Override
        public SnapshotProtos.SnapshotRegionManifest.FamilyFiles.Builder familyOpen(SnapshotProtos.SnapshotRegionManifest.Builder region, byte[] familyName) {
            SnapshotProtos.SnapshotRegionManifest.FamilyFiles.Builder family = SnapshotProtos.SnapshotRegionManifest.FamilyFiles.newBuilder();
            family.setFamilyName(UnsafeByteOperations.unsafeWrap(familyName));
            return family;
        }

        @Override
        public void familyClose(SnapshotProtos.SnapshotRegionManifest.Builder region, SnapshotProtos.SnapshotRegionManifest.FamilyFiles.Builder family) {
            region.addFamilyFiles(family.build());
        }

        @Override
        public void storeFile(SnapshotProtos.SnapshotRegionManifest.Builder region, SnapshotProtos.SnapshotRegionManifest.FamilyFiles.Builder family, StoreFileInfo storeFile) throws IOException {
            SnapshotProtos.SnapshotRegionManifest.StoreFile.Builder sfManifest = SnapshotProtos.SnapshotRegionManifest.StoreFile.newBuilder();
            sfManifest.setName(storeFile.getPath().getName());
            if (storeFile.isReference()) {
                sfManifest.setReference(storeFile.getReference().convert());
            }
            if (!storeFile.isReference() && !storeFile.isLink()) {
                sfManifest.setFileSize(storeFile.getSize());
            } else {
                sfManifest.setFileSize(storeFile.getReferencedFileStatus(this.rootFs).getLen());
            }
            family.addStoreFiles(sfManifest.build());
        }
    }
}

