/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.util;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class Addressing {
    public static final String VALID_PORT_REGEX = "[\\d]+";
    public static final String HOSTNAME_PORT_SEPARATOR = ":";

    public static InetSocketAddress createInetSocketAddressFromHostAndPortStr(String hostAndPort) {
        return new InetSocketAddress(Addressing.parseHostname(hostAndPort), Addressing.parsePort(hostAndPort));
    }

    public static String createHostAndPortStr(String hostname, int port) {
        return hostname + HOSTNAME_PORT_SEPARATOR + port;
    }

    public static String parseHostname(String hostAndPort) {
        int colonIndex = hostAndPort.lastIndexOf(HOSTNAME_PORT_SEPARATOR);
        if (colonIndex < 0) {
            throw new IllegalArgumentException("Not a host:port pair: " + hostAndPort);
        }
        return hostAndPort.substring(0, colonIndex);
    }

    public static int parsePort(String hostAndPort) {
        int colonIndex = hostAndPort.lastIndexOf(HOSTNAME_PORT_SEPARATOR);
        if (colonIndex < 0) {
            throw new IllegalArgumentException("Not a host:port pair: " + hostAndPort);
        }
        return Integer.parseInt(hostAndPort.substring(colonIndex + 1));
    }

    public static InetAddress getIpAddress() throws SocketException {
        return Addressing.getIpAddress(new AddressSelectionCondition(){

            @Override
            public boolean isAcceptableAddress(InetAddress addr) {
                return addr instanceof Inet4Address || addr instanceof Inet6Address;
            }
        });
    }

    public static InetAddress getIp4Address() throws SocketException {
        return Addressing.getIpAddress(new AddressSelectionCondition(){

            @Override
            public boolean isAcceptableAddress(InetAddress addr) {
                return addr instanceof Inet4Address;
            }
        });
    }

    public static InetAddress getIp6Address() throws SocketException {
        return Addressing.getIpAddress(new AddressSelectionCondition(){

            @Override
            public boolean isAcceptableAddress(InetAddress addr) {
                return addr instanceof Inet6Address;
            }
        });
    }

    private static InetAddress getIpAddress(AddressSelectionCondition condition) throws SocketException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface current = interfaces.nextElement();
            if (!current.isUp() || current.isLoopback() || current.isVirtual()) continue;
            Enumeration<InetAddress> addresses = current.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress addr = addresses.nextElement();
                if (addr.isLoopbackAddress() || !condition.isAcceptableAddress(addr)) continue;
                return addr;
            }
        }
        throw new SocketException("Can't get our ip address, interfaces are: " + interfaces);
    }

    public static boolean isLocalAddress(InetAddress addr) {
        boolean local;
        boolean bl = local = addr.isAnyLocalAddress() || addr.isLoopbackAddress();
        if (!local) {
            try {
                local = NetworkInterface.getByInetAddress(addr) != null;
            }
            catch (SocketException e) {
                local = false;
            }
        }
        return local;
    }

    public static String inetSocketAddress2String(InetSocketAddress address) {
        return address.isUnresolved() ? address.toString().replace("/<unresolved>", "") : address.toString();
    }

    public static interface AddressSelectionCondition {
        public boolean isAcceptableAddress(InetAddress var1);
    }
}

