/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.util;

import io.hops.hudi.com.google.protobuf.ByteString;
import io.hops.hudi.com.google.protobuf.HBaseZeroCopyByteString;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ByteStringer {
    private static final Logger LOG = LoggerFactory.getLogger(ByteStringer.class);
    private static boolean USE_ZEROCOPYBYTESTRING = true;

    private ByteStringer() {
    }

    public static ByteString wrap(byte[] array) {
        return USE_ZEROCOPYBYTESTRING ? HBaseZeroCopyByteString.wrap(array) : ByteString.copyFrom(array);
    }

    public static ByteString wrap(byte[] array, int offset, int length) {
        return USE_ZEROCOPYBYTESTRING ? HBaseZeroCopyByteString.wrap(array, offset, length) : ByteString.copyFrom(array, offset, length);
    }

    static {
        try {
            HBaseZeroCopyByteString.wrap(new byte[0]);
        }
        catch (IllegalAccessError iae) {
            USE_ZEROCOPYBYTESTRING = false;
            LOG.debug("Failed to classload HBaseZeroCopyByteString: " + iae.toString());
        }
    }
}

