/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.util;

import io.hops.hudi.org.apache.hadoop.hbase.util.WindowMovingAverage;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ExponentialMovingAverage
extends WindowMovingAverage {
    private double alpha;
    private double previousAverage = -1.0;
    private double currentAverage = 0.0;

    public ExponentialMovingAverage(String label) {
        this(label, 5);
    }

    public ExponentialMovingAverage(String label, double alpha) {
        this(label, 5, alpha);
    }

    public ExponentialMovingAverage(String label, int size) {
        this(label, size, 2.0 / (double)(1 + size));
    }

    public ExponentialMovingAverage(String label, int size, double alpha) {
        super(label, size);
        this.alpha = alpha;
    }

    @Override
    public void updateMostRecentTime(long elapsed) {
        if (!this.enoughStatistics()) {
            this.previousAverage = super.getAverageTime();
            super.updateMostRecentTime(elapsed);
            if (!this.enoughStatistics()) {
                return;
            }
        }
        this.previousAverage = this.currentAverage = ((double)elapsed - this.previousAverage) * this.alpha + this.previousAverage;
    }

    @Override
    public double getAverageTime() {
        if (!this.enoughStatistics()) {
            return super.getAverageTime();
        }
        return this.currentAverage;
    }

    double getPrevious() {
        return this.previousAverage;
    }
}

