/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.wal;

import io.hops.hudi.org.apache.hadoop.hbase.Abortable;
import io.hops.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import io.hops.hudi.org.apache.hadoop.hbase.replication.regionserver.WALFileLengthProvider;
import io.hops.hudi.org.apache.hadoop.hbase.wal.WAL;
import io.hops.hudi.org.apache.hadoop.hbase.wal.WALFactory;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.conf.Configuration;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public interface WALProvider {
    public void init(WALFactory var1, Configuration var2, String var3, Abortable var4) throws IOException;

    public WAL getWAL(RegionInfo var1) throws IOException;

    public List<WAL> getWALs();

    public void shutdown() throws IOException;

    public void close() throws IOException;

    public long getNumLogFiles();

    public long getLogFileSize();

    public void addWALActionsListener(WALActionsListener var1);

    default public WALFileLengthProvider getWALFileLengthProvider() {
        return path -> this.getWALs().stream().map(w -> w.getLogFileSizeIfBeingWritten(path)).filter(o -> o.isPresent()).findAny().orElse(OptionalLong.empty());
    }

    public static interface AsyncWriter
    extends WriterBase {
        public CompletableFuture<Long> sync(boolean var1);

        public void append(WAL.Entry var1);
    }

    public static interface Writer
    extends WriterBase {
        public void sync(boolean var1) throws IOException;

        public void append(WAL.Entry var1) throws IOException;
    }

    public static interface WriterBase
    extends Closeable {
        public long getLength();

        public long getSyncedLength();
    }
}

