/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.http.impl.client;

import io.hops.hudi.org.apache.http.Header;
import io.hops.hudi.org.apache.http.HttpHost;
import io.hops.hudi.org.apache.http.HttpRequest;
import io.hops.hudi.org.apache.http.HttpResponse;
import io.hops.hudi.org.apache.http.ProtocolException;
import io.hops.hudi.org.apache.http.annotation.Immutable;
import io.hops.hudi.org.apache.http.client.CircularRedirectException;
import io.hops.hudi.org.apache.http.client.RedirectStrategy;
import io.hops.hudi.org.apache.http.client.config.RequestConfig;
import io.hops.hudi.org.apache.http.client.methods.HttpGet;
import io.hops.hudi.org.apache.http.client.methods.HttpHead;
import io.hops.hudi.org.apache.http.client.methods.HttpUriRequest;
import io.hops.hudi.org.apache.http.client.methods.RequestBuilder;
import io.hops.hudi.org.apache.http.client.protocol.HttpClientContext;
import io.hops.hudi.org.apache.http.client.utils.URIBuilder;
import io.hops.hudi.org.apache.http.client.utils.URIUtils;
import io.hops.hudi.org.apache.http.impl.client.RedirectLocations;
import io.hops.hudi.org.apache.http.protocol.HttpContext;
import io.hops.hudi.org.apache.http.util.Args;
import io.hops.hudi.org.apache.http.util.Asserts;
import io.hops.hudi.org.apache.http.util.TextUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Immutable
public class DefaultRedirectStrategy
implements RedirectStrategy {
    private final Log log = LogFactory.getLog(this.getClass());
    @Deprecated
    public static final String REDIRECT_LOCATIONS = "http.protocol.redirect-locations";
    public static final DefaultRedirectStrategy INSTANCE = new DefaultRedirectStrategy();
    private static final String[] REDIRECT_METHODS = new String[]{"GET", "HEAD"};

    @Override
    public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        Args.notNull(request, "HTTP request");
        Args.notNull(response, "HTTP response");
        int statusCode = response.getStatusLine().getStatusCode();
        String method = request.getRequestLine().getMethod();
        Header locationHeader = response.getFirstHeader("location");
        switch (statusCode) {
            case 302: {
                return this.isRedirectable(method) && locationHeader != null;
            }
            case 301: 
            case 307: {
                return this.isRedirectable(method);
            }
            case 303: {
                return true;
            }
        }
        return false;
    }

    public URI getLocationURI(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        Args.notNull(request, "HTTP request");
        Args.notNull(response, "HTTP response");
        Args.notNull(context, "HTTP context");
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        Header locationHeader = response.getFirstHeader("location");
        if (locationHeader == null) {
            throw new ProtocolException("Received redirect response " + response.getStatusLine() + " but no location header");
        }
        String location = locationHeader.getValue();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Redirect requested to location '" + location + "'"));
        }
        RequestConfig config = clientContext.getRequestConfig();
        URI uri2 = this.createLocationURI(location);
        try {
            if (!uri2.isAbsolute()) {
                if (!config.isRelativeRedirectsAllowed()) {
                    throw new ProtocolException("Relative redirect location '" + uri2 + "' not allowed");
                }
                HttpHost target = clientContext.getTargetHost();
                Asserts.notNull(target, "Target host");
                URI requestURI = new URI(request.getRequestLine().getUri());
                URI absoluteRequestURI = URIUtils.rewriteURI(requestURI, target, false);
                uri2 = URIUtils.resolve(absoluteRequestURI, uri2);
            }
        }
        catch (URISyntaxException ex) {
            throw new ProtocolException(ex.getMessage(), ex);
        }
        RedirectLocations redirectLocations = (RedirectLocations)clientContext.getAttribute(REDIRECT_LOCATIONS);
        if (redirectLocations == null) {
            redirectLocations = new RedirectLocations();
            context.setAttribute(REDIRECT_LOCATIONS, redirectLocations);
        }
        if (!config.isCircularRedirectsAllowed() && redirectLocations.contains(uri2)) {
            throw new CircularRedirectException("Circular redirect to '" + uri2 + "'");
        }
        redirectLocations.add(uri2);
        return uri2;
    }

    protected URI createLocationURI(String location) throws ProtocolException {
        try {
            String path;
            URIBuilder b = new URIBuilder(new URI(location).normalize());
            String host2 = b.getHost();
            if (host2 != null) {
                b.setHost(host2.toLowerCase(Locale.ROOT));
            }
            if (TextUtils.isEmpty(path = b.getPath())) {
                b.setPath("/");
            }
            return b.build();
        }
        catch (URISyntaxException ex) {
            throw new ProtocolException("Invalid redirect URI: " + location, ex);
        }
    }

    protected boolean isRedirectable(String method) {
        for (String m : REDIRECT_METHODS) {
            if (!m.equalsIgnoreCase(method)) continue;
            return true;
        }
        return false;
    }

    @Override
    public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        URI uri2 = this.getLocationURI(request, response, context);
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("HEAD")) {
            return new HttpHead(uri2);
        }
        if (method.equalsIgnoreCase("GET")) {
            return new HttpGet(uri2);
        }
        int status = response.getStatusLine().getStatusCode();
        if (status == 307) {
            return RequestBuilder.copy(request).setUri(uri2).build();
        }
        return new HttpGet(uri2);
    }
}

