/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.http.impl.entity;

import io.hops.hudi.org.apache.http.HttpException;
import io.hops.hudi.org.apache.http.HttpMessage;
import io.hops.hudi.org.apache.http.ProtocolException;
import io.hops.hudi.org.apache.http.annotation.Immutable;
import io.hops.hudi.org.apache.http.entity.ContentLengthStrategy;
import io.hops.hudi.org.apache.http.impl.entity.LaxContentLengthStrategy;

@Immutable
public class DisallowIdentityContentLengthStrategy
implements ContentLengthStrategy {
    public static final DisallowIdentityContentLengthStrategy INSTANCE = new DisallowIdentityContentLengthStrategy(new LaxContentLengthStrategy(0));
    private final ContentLengthStrategy contentLengthStrategy;

    public DisallowIdentityContentLengthStrategy(ContentLengthStrategy contentLengthStrategy) {
        this.contentLengthStrategy = contentLengthStrategy;
    }

    @Override
    public long determineLength(HttpMessage message) throws HttpException {
        long result = this.contentLengthStrategy.determineLength(message);
        if (result == -1L) {
            throw new ProtocolException("Identity transfer encoding cannot be used");
        }
        return result;
    }
}

