/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.eclipse.jetty.util;

import io.hops.hudi.org.eclipse.jetty.util.AbstractTrie;
import io.hops.hudi.org.eclipse.jetty.util.MathUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ArrayTrie<V>
extends AbstractTrie<V> {
    private static final int ROW_SIZE = 32;
    private static final int MAX_CAPACITY = 65534;
    private static final int[] __lookup = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26, -1, 27, 30, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 28, 29, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1};
    private final char[] _rowIndex;
    private final String[] _key;
    private final V[] _value;
    private char[][] _bigIndex;
    private char _rows;

    public ArrayTrie() {
        this(128);
    }

    public ArrayTrie(int capacity) {
        super(true);
        if (capacity > 65534) {
            throw new IllegalArgumentException("Capacity " + capacity + " > " + 65534);
        }
        this._value = new Object[capacity + 1];
        this._rowIndex = new char[(capacity + 1) * 32];
        this._key = new String[capacity + 1];
    }

    @Override
    public void clear() {
        this._rows = '\u0000';
        Arrays.fill(this._value, null);
        Arrays.fill(this._rowIndex, '\u0000');
        Arrays.fill(this._key, null);
    }

    @Override
    public boolean put(String s, V v) {
        int t = 0;
        int limit = s.length();
        if (limit > 65534) {
            return false;
        }
        for (int k = 0; k < limit; ++k) {
            char c = s.charAt(k);
            int index = __lookup[c & 0x7F];
            if (index >= 0) {
                int idx = t * 32 + index;
                if ((t = this._rowIndex[idx]) != 0) continue;
                this._rows = (char)MathUtils.cappedAdd(this._rows, 1, this._value.length);
                if (this._rows == this._value.length) {
                    return false;
                }
                this._rowIndex[idx] = this._rows;
                t = this._rowIndex[idx];
                continue;
            }
            if (c > '\u007f') {
                throw new IllegalArgumentException("non ascii character");
            }
            if (this._bigIndex == null) {
                this._bigIndex = new char[this._value.length][];
            }
            if (t >= this._bigIndex.length) {
                return false;
            }
            char[] big = this._bigIndex[t];
            if (big == null) {
                this._bigIndex[t] = new char[128];
                big = this._bigIndex[t];
            }
            if ((t = big[c]) != 0) continue;
            this._rows = (char)MathUtils.cappedAdd(this._rows, 1, this._value.length);
            if (this._rows == this._value.length) {
                return false;
            }
            big[c] = this._rows;
            t = big[c];
        }
        if (t >= this._key.length) {
            this._rows = (char)this._key.length;
            return false;
        }
        this._key[t] = v == null ? null : s;
        this._value[t] = v;
        return true;
    }

    @Override
    public V get(String s, int offset, int len) {
        int t = 0;
        for (int i = 0; i < len; ++i) {
            char[] big;
            char c = s.charAt(offset + i);
            if (c > '\u007f') {
                return null;
            }
            int index = __lookup[c & 0x7F];
            if (index >= 0) {
                int idx = t * 32 + index;
                if ((t = this._rowIndex[idx]) != 0) continue;
                return null;
            }
            char[] cArray = big = this._bigIndex == null ? null : this._bigIndex[t];
            if (big == null) {
                return null;
            }
            t = big[c & 0x7F];
            if (t != 0) continue;
            return null;
        }
        return this._value[t];
    }

    @Override
    public V get(ByteBuffer b, int offset, int len) {
        int t = 0;
        for (int i = 0; i < len; ++i) {
            char[] big;
            byte c = b.get(offset + i);
            int index = __lookup[c & 0x7F];
            if (index >= 0) {
                int idx = t * 32 + index;
                if ((t = this._rowIndex[idx]) != 0) continue;
                return null;
            }
            char[] cArray = big = this._bigIndex == null ? null : this._bigIndex[t];
            if (big == null) {
                return null;
            }
            t = big[c];
            if (t != 0) continue;
            return null;
        }
        return this._value[t];
    }

    @Override
    public V getBest(byte[] b, int offset, int len) {
        return this.getBest(0, b, offset, len);
    }

    @Override
    public V getBest(ByteBuffer b, int offset, int len) {
        if (b.hasArray()) {
            return this.getBest(0, b.array(), b.arrayOffset() + b.position() + offset, len);
        }
        return this.getBest(0, b, offset, len);
    }

    @Override
    public V getBest(String s, int offset, int len) {
        return this.getBest(0, s, offset, len);
    }

    private V getBest(int t, String s, int offset, int len) {
        int pos = offset;
        for (int i = 0; i < len; ++i) {
            int nt;
            char c;
            int index;
            if ((index = __lookup[(c = s.charAt(pos++)) & 0x7F]) >= 0) {
                int idx = t * 32 + index;
                nt = this._rowIndex[idx];
                if (nt == 0) {
                    break;
                }
            } else {
                char[] big;
                char[] cArray = big = this._bigIndex == null ? null : this._bigIndex[t];
                if (big == null || (nt = big[c]) == 0) break;
            }
            if (this._key[t] != null) {
                V best = this.getBest(nt, s, offset + i + 1, len - i - 1);
                if (best != null) {
                    return best;
                }
                return this._value[t];
            }
            t = nt;
        }
        return this._value[t];
    }

    private V getBest(int t, byte[] b, int offset, int len) {
        for (int i = 0; i < len; ++i) {
            int nt;
            byte c = b[offset + i];
            int index = __lookup[c & 0x7F];
            if (index >= 0) {
                int idx = t * 32 + index;
                nt = this._rowIndex[idx];
                if (nt == 0) {
                    break;
                }
            } else {
                char[] big;
                char[] cArray = big = this._bigIndex == null ? null : this._bigIndex[t];
                if (big == null || (nt = big[c]) == 0) break;
            }
            if (this._key[t] != null) {
                V best = this.getBest(nt, b, offset + i + 1, len - i - 1);
                if (best == null) break;
                return best;
            }
            t = nt;
        }
        return this._value[t];
    }

    private V getBest(int t, ByteBuffer b, int offset, int len) {
        int pos = b.position() + offset;
        for (int i = 0; i < len; ++i) {
            int nt;
            byte c;
            int index;
            if (pos >= b.limit()) {
                return null;
            }
            if ((index = __lookup[(c = b.get(pos++)) & 0x7F]) >= 0) {
                int idx = t * 32 + index;
                nt = this._rowIndex[idx];
                if (nt == 0) {
                    break;
                }
            } else {
                char[] big;
                char[] cArray = big = this._bigIndex == null ? null : this._bigIndex[t];
                if (big == null || (nt = big[c]) == 0) break;
                t = nt;
            }
            if (this._key[t] != null) {
                V best = this.getBest(nt, b, offset + i + 1, len - i - 1);
                if (best == null) break;
                return best;
            }
            t = nt;
        }
        return this._value[t];
    }

    public String toString() {
        int rows = this._rows;
        if (rows == 0) {
            return "{}";
        }
        StringBuilder buf = new StringBuilder();
        int c = 123;
        for (int i = 0; i <= rows; ++i) {
            String key = this._key[i];
            if (key == null) continue;
            buf.append((char)c).append(key).append('=').append(this._value[i]);
            c = 44;
        }
        buf.append('}');
        return buf.toString();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keys2 = new HashSet<String>();
        for (String k : this._key) {
            if (k == null) continue;
            keys2.add(k);
        }
        return keys2;
    }

    @Override
    public boolean isFull() {
        return this._rows >= this._key.length;
    }
}

