/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.eclipse.jetty.websocket.client;

import io.hops.hudi.org.eclipse.jetty.client.HttpClient;
import io.hops.hudi.org.eclipse.jetty.io.ByteBufferPool;
import io.hops.hudi.org.eclipse.jetty.io.MappedByteBufferPool;
import io.hops.hudi.org.eclipse.jetty.util.ssl.SslContextFactory;
import io.hops.hudi.org.eclipse.jetty.util.thread.QueuedThreadPool;
import io.hops.hudi.org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import java.util.concurrent.Executor;

class DefaultHttpClientProvider {
    DefaultHttpClientProvider() {
    }

    public static HttpClient newHttpClient(WebSocketContainerScope scope) {
        SslContextFactory sslContextFactory = null;
        Executor executor = null;
        ByteBufferPool bufferPool = null;
        if (scope != null) {
            sslContextFactory = scope.getSslContextFactory();
            executor = scope.getExecutor();
            bufferPool = scope.getBufferPool();
        }
        if (sslContextFactory == null) {
            sslContextFactory = new SslContextFactory.Client();
            sslContextFactory.setTrustAll(false);
            sslContextFactory.setEndpointIdentificationAlgorithm("HTTPS");
        }
        HttpClient client = new HttpClient(sslContextFactory);
        if (executor == null) {
            QueuedThreadPool threadPool = new QueuedThreadPool();
            String name = "WebSocketClient@" + client.hashCode();
            threadPool.setName(name);
            threadPool.setDaemon(true);
            executor = threadPool;
        }
        client.setExecutor(executor);
        if (bufferPool == null) {
            bufferPool = new MappedByteBufferPool();
        }
        client.setByteBufferPool(bufferPool);
        return client;
    }
}

