/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.eclipse.jetty.websocket.client;

import io.hops.hudi.org.eclipse.jetty.client.HttpClient;
import io.hops.hudi.org.eclipse.jetty.util.log.Log;
import io.hops.hudi.org.eclipse.jetty.util.log.Logger;
import io.hops.hudi.org.eclipse.jetty.util.resource.Resource;
import io.hops.hudi.org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import io.hops.hudi.org.eclipse.jetty.xml.XmlConfiguration;
import java.net.URL;

class XmlBasedHttpClientProvider {
    public static final Logger LOG = Log.getLogger(XmlBasedHttpClientProvider.class);

    XmlBasedHttpClientProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpClient get(WebSocketContainerScope scope) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader == null) {
            return null;
        }
        URL resource = contextClassLoader.getResource("jetty-websocket-httpclient.xml");
        if (resource == null) {
            return null;
        }
        try {
            Thread.currentThread().setContextClassLoader(HttpClient.class.getClassLoader());
            HttpClient httpClient = XmlBasedHttpClientProvider.newHttpClient(resource);
            return httpClient;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private static HttpClient newHttpClient(URL resource) {
        try {
            XmlConfiguration configuration = new XmlConfiguration(Resource.newResource(resource));
            return (HttpClient)configuration.configure();
        }
        catch (Throwable t) {
            LOG.warn("Failure to load HttpClient from XML {}", resource, t);
            return null;
        }
    }
}

