/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.eclipse.jetty.websocket.common.events.annotated;

import io.hops.hudi.org.eclipse.jetty.util.log.Log;
import io.hops.hudi.org.eclipse.jetty.util.log.Logger;
import io.hops.hudi.org.eclipse.jetty.websocket.api.Session;
import io.hops.hudi.org.eclipse.jetty.websocket.api.WebSocketException;
import io.hops.hudi.org.eclipse.jetty.websocket.api.util.QuoteUtil;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class EventMethod {
    private static final Logger LOG = Log.getLogger(EventMethod.class);
    protected Class<?> pojo;
    protected Method method;
    private boolean hasSession = false;
    private boolean isStreaming = false;
    private Class<?>[] paramTypes;

    private static Object[] dropFirstArg(Object[] args2) {
        if (args2.length == 1) {
            return new Object[0];
        }
        Object[] ret = new Object[args2.length - 1];
        System.arraycopy(args2, 1, ret, 0, ret.length);
        return ret;
    }

    public EventMethod(Class<?> pojo, Method method) {
        this.pojo = pojo;
        this.paramTypes = method.getParameterTypes();
        this.method = method;
        this.identifyPresentParamTypes();
    }

    public EventMethod(Class<?> pojo, String methodName, Class<?> ... paramTypes) {
        try {
            this.pojo = pojo;
            this.paramTypes = paramTypes;
            this.method = pojo.getMethod(methodName, paramTypes);
            this.identifyPresentParamTypes();
        }
        catch (NoSuchMethodException | SecurityException e) {
            LOG.warn("Cannot use method {}({}): {}", methodName, paramTypes, e.getMessage());
            this.method = null;
        }
    }

    public void call(Object obj, Object ... args2) {
        if (this.pojo == null || this.method == null) {
            LOG.warn("Cannot execute call: pojo={}, method={}", this.pojo, this.method);
            return;
        }
        if (obj == null) {
            LOG.warn("Cannot call {} on null object", this.method);
            return;
        }
        if (args2.length > this.paramTypes.length) {
            Object[] trimArgs = EventMethod.dropFirstArg(args2);
            this.call(obj, trimArgs);
            return;
        }
        if (args2.length < this.paramTypes.length) {
            throw new IllegalArgumentException("Call arguments length [" + args2.length + "] must always be greater than or equal to captured args length [" + this.paramTypes.length + "]");
        }
        try {
            this.method.invoke(obj, args2);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            String err = String.format("Cannot call method %s on %s with args: %s", this.method, this.pojo, QuoteUtil.join(args2, ","));
            throw new WebSocketException(err, e);
        }
    }

    public Method getMethod() {
        return this.method;
    }

    protected Class<?>[] getParamTypes() {
        return this.paramTypes;
    }

    private void identifyPresentParamTypes() {
        this.hasSession = false;
        this.isStreaming = false;
        if (this.paramTypes == null) {
            return;
        }
        for (Class<?> paramType : this.paramTypes) {
            if (Session.class.isAssignableFrom(paramType)) {
                this.hasSession = true;
            }
            if (!Reader.class.isAssignableFrom(paramType) && !InputStream.class.isAssignableFrom(paramType)) continue;
            this.isStreaming = true;
        }
    }

    public boolean isHasSession() {
        return this.hasSession;
    }

    public boolean isStreaming() {
        return this.isStreaming;
    }
}

