/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.eclipse.jetty.websocket.server;

import io.hops.hudi.org.eclipse.jetty.http.pathmap.MatchedResource;
import io.hops.hudi.org.eclipse.jetty.io.ByteBufferPool;
import io.hops.hudi.org.eclipse.jetty.io.MappedByteBufferPool;
import io.hops.hudi.org.eclipse.jetty.server.Request;
import io.hops.hudi.org.eclipse.jetty.server.handler.HandlerWrapper;
import io.hops.hudi.org.eclipse.jetty.servlet.ServletContextHandler;
import io.hops.hudi.org.eclipse.jetty.websocket.server.MappedWebSocketCreator;
import io.hops.hudi.org.eclipse.jetty.websocket.server.NativeWebSocketConfiguration;
import io.hops.hudi.org.eclipse.jetty.websocket.server.WebSocketServerFactory;
import io.hops.hudi.org.eclipse.jetty.websocket.server.pathmap.PathSpec;
import io.hops.hudi.org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebSocketUpgradeHandlerWrapper
extends HandlerWrapper
implements MappedWebSocketCreator {
    private NativeWebSocketConfiguration configuration;

    public WebSocketUpgradeHandlerWrapper(ServletContextHandler context) {
        this(context, new MappedByteBufferPool());
    }

    public WebSocketUpgradeHandlerWrapper(ServletContextHandler context, ByteBufferPool bufferPool) {
        this.configuration = new NativeWebSocketConfiguration(new WebSocketServerFactory((ServletContext)context.getServletContext(), bufferPool));
    }

    @Override
    public void addMapping(io.hops.hudi.org.eclipse.jetty.http.pathmap.PathSpec spec, WebSocketCreator creator) {
        this.configuration.addMapping(spec, creator);
    }

    @Override
    @Deprecated
    public void addMapping(PathSpec spec, WebSocketCreator creator) {
        this.configuration.addMapping(spec, creator);
    }

    @Override
    public void addMapping(String spec, WebSocketCreator creator) {
        this.configuration.addMapping(spec, creator);
    }

    @Override
    public boolean removeMapping(String spec) {
        return this.configuration.removeMapping(spec);
    }

    @Override
    public WebSocketCreator getMapping(String target) {
        return this.configuration.getMapping(target);
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.configuration.getFactory().isUpgradeRequest(request, response)) {
            MatchedResource<WebSocketCreator> resource = this.configuration.getMatched(target);
            if (resource == null) {
                response.sendError(404, "No websocket endpoint matching path: " + target);
                return;
            }
            WebSocketCreator creator = resource.getResource();
            request.setAttribute(io.hops.hudi.org.eclipse.jetty.http.pathmap.PathSpec.class.getName(), resource);
            if (this.configuration.getFactory().acceptWebSocket(creator, request, response)) {
                return;
            }
            if (response.isCommitted()) {
                return;
            }
        }
        super.handle(target, baseRequest, request, response);
    }
}

