/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.openjdk.jol.info;

import io.hops.hudi.org.openjdk.jol.util.ClassUtils;
import io.hops.hudi.org.openjdk.jol.vm.ContendedSupport;
import java.lang.reflect.Field;

public class FieldData {
    private final String name;
    private final String type;
    private final String klass;
    private final Field refField;
    private final boolean isContended;
    private final String contendedGroup;

    public static FieldData create(String hostKlass, String fieldName, String fieldType) {
        return new FieldData(null, hostKlass, fieldName, fieldType, false, null);
    }

    public static FieldData create(String hostKlass, String fieldName, String fieldType, boolean isContended, String contendedGroup) {
        return new FieldData(null, hostKlass, fieldName, fieldType, isContended, contendedGroup);
    }

    public static FieldData parse(Field field2) {
        return new FieldData(field2, ClassUtils.getSafeName(field2.getDeclaringClass()), field2.getName(), ClassUtils.getSafeName(field2.getType()), ContendedSupport.isContended(field2), ContendedSupport.contendedGroup(field2));
    }

    private FieldData(Field refField, String hostKlass, String fieldName, String fieldType, boolean isContended, String contendedGroup) {
        this.klass = hostKlass;
        this.name = fieldName;
        this.type = fieldType;
        this.refField = refField;
        this.isContended = isContended;
        this.contendedGroup = contendedGroup;
    }

    public String typeClass() {
        return this.type;
    }

    public boolean isPrimitive() {
        switch (this.type) {
            case "boolean": 
            case "byte": 
            case "short": 
            case "char": 
            case "int": 
            case "float": 
            case "long": 
            case "double": {
                return true;
            }
        }
        return false;
    }

    public String hostClass() {
        return this.klass;
    }

    public String name() {
        return this.name;
    }

    public boolean isContended() {
        return this.isContended;
    }

    public String contendedGroup() {
        return this.contendedGroup;
    }

    public Field refField() {
        return this.refField;
    }

    public String toString() {
        return this.name + ": " + this.type;
    }
}

