/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.openjdk.jol.layouters;

import io.hops.hudi.org.openjdk.jol.datamodel.DataModel;
import io.hops.hudi.org.openjdk.jol.info.ClassData;
import io.hops.hudi.org.openjdk.jol.info.ClassLayout;
import io.hops.hudi.org.openjdk.jol.info.FieldData;
import io.hops.hudi.org.openjdk.jol.info.FieldLayout;
import io.hops.hudi.org.openjdk.jol.layouters.FieldAllocationType;
import io.hops.hudi.org.openjdk.jol.layouters.Layouter;
import io.hops.hudi.org.openjdk.jol.util.MathUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class HotSpotLayouter
implements Layouter {
    private static Set<String> PREDEF_OFFSETS = new HashSet<String>(Arrays.asList("java.lang.AssertionStatusDirectives", "java.lang.Class", "java.lang.ClassLoader", "java.lang.ref.Reference", "java.lang.ref.SoftReference", "java.lang.StackTraceElement", "java.lang.String", "java.lang.Throwable", "java.lang.Boolean", "java.lang.Character", "java.lang.Float", "java.lang.Double", "java.lang.Byte", "java.lang.Short", "java.lang.Integer", "java.lang.Long"));
    static final int CONTENDED_PADDING_WIDTH = Integer.getInteger("contendedPaddingWidth", 128);
    private final DataModel model;
    private final int jdkVersion;

    public HotSpotLayouter(DataModel model, int jdkVersion) {
        this.model = model;
        this.jdkVersion = jdkVersion;
    }

    @Override
    public ClassLayout layout(ClassData cd) {
        if (cd.isArray()) {
            int base = this.model.arrayHeaderSize();
            int scale = this.model.sizeOf(cd.arrayComponentType());
            long instanceSize = (long)base + cd.arrayLength() * (long)scale;
            instanceSize = MathUtil.align(instanceSize, this.model.objectAlignment());
            base = MathUtil.align(base, Math.max(4, scale));
            TreeSet<FieldLayout> result = new TreeSet<FieldLayout>();
            result.add(new FieldLayout(FieldData.create(cd.arrayClass(), "<elements>", cd.arrayComponentType()), base, (long)scale * cd.arrayLength()));
            return ClassLayout.create(cd, result, this.model, instanceSize, false);
        }
        if (this.jdkVersion >= 15) {
            return this.newLayouter(cd);
        }
        return this.oldLayouter(cd);
    }

    private ClassLayout newLayouter(ClassData cd) {
        TreeSet<FieldLayout> result = new TreeSet<FieldLayout>();
        List<String> hierarchy = cd.classHierarchy();
        BitSet claimed = new BitSet();
        claimed.set(0, this.model.headerSize());
        for (String k : hierarchy) {
            int t;
            int fSize;
            List<FieldData> fields = cd.fieldsFor(k);
            TreeSet<FieldLayout> current = new TreeSet<FieldLayout>();
            for (int size : new int[]{8, 4, 2, 1}) {
                block2: for (FieldData f : fields) {
                    if (!f.isPrimitive() || (fSize = this.model.sizeOf(f.typeClass())) != size) continue;
                    for (t = 0; t < Integer.MAX_VALUE; ++t) {
                        if (!claimed.get(t * size, (t + 1) * size).isEmpty()) continue;
                        claimed.set(t * size, (t + 1) * size);
                        current.add(new FieldLayout(f, t * size, size));
                        continue block2;
                    }
                }
            }
            for (int size : new int[]{8, 4, 2, 1}) {
                block5: for (FieldData f : fields) {
                    if (f.isPrimitive() || (fSize = this.model.sizeOf(f.typeClass())) != size) continue;
                    for (t = 0; t < Integer.MAX_VALUE; ++t) {
                        if (!claimed.get(t * size, (t + 1) * size).isEmpty()) continue;
                        claimed.set(t * size, (t + 1) * size);
                        current.add(new FieldLayout(f, t * size, size));
                        continue block5;
                    }
                }
            }
            result.addAll(current);
        }
        int instanceSize = MathUtil.align(claimed.length(), this.model.objectAlignment());
        return ClassLayout.create(cd, result, this.model, instanceSize, true);
    }

    private ClassLayout oldLayouter(ClassData cd) {
        TreeSet<FieldLayout> result = new TreeSet<FieldLayout>();
        ArrayList<ClassData> classDataClassHierarchy = new ArrayList<ClassData>();
        ClassData cld = cd;
        classDataClassHierarchy.add(cld);
        while ((cld = cld.superClass()) != null) {
            classDataClassHierarchy.add(0, cld);
        }
        int superClassFieldsSize = 0;
        int nextPaddedOffset = 0;
        for (ClassData classData : classDataClassHierarchy) {
            EnumMap<FieldAllocationType, Integer> fieldsAllocationCount = new EnumMap<FieldAllocationType, Integer>(FieldAllocationType.class);
            EnumMap<FieldAllocationType, Integer> nextOffset = new EnumMap<FieldAllocationType, Integer>(FieldAllocationType.class);
            EnumMap spaceOffset = new EnumMap(FieldAllocationType.class);
            EnumMap<FieldAllocationType, Integer> allocationTypeSizes = new EnumMap<FieldAllocationType, Integer>(FieldAllocationType.class);
            for (FieldAllocationType atype : FieldAllocationType.values()) {
                fieldsAllocationCount.put(atype, 0);
                nextOffset.put(atype, 0);
                spaceOffset.put(atype, new ArrayDeque());
            }
            allocationTypeSizes.put(FieldAllocationType.OOP, this.model.sizeOf("oop"));
            allocationTypeSizes.put(FieldAllocationType.BYTE, this.model.sizeOf("byte"));
            allocationTypeSizes.put(FieldAllocationType.SHORT, this.model.sizeOf("short"));
            allocationTypeSizes.put(FieldAllocationType.WORD, this.model.sizeOf("int"));
            allocationTypeSizes.put(FieldAllocationType.DOUBLE, this.model.sizeOf("long"));
            for (FieldData f : classData.ownFields()) {
                FieldAllocationType atype = FieldAllocationType.allocationTypeFor(f);
                Integer count = (Integer)fieldsAllocationCount.get((Object)atype);
                count = count + 1;
                fieldsAllocationCount.put(atype, count);
            }
            int contendedCount = 0;
            EnumMap<FieldAllocationType, Integer> facContended = new EnumMap<FieldAllocationType, Integer>(FieldAllocationType.class);
            for (FieldData f : classData.ownFields()) {
                int n;
                FieldAllocationType atype = FieldAllocationType.allocationTypeFor(f);
                if (!f.isContended()) continue;
                Integer count = (Integer)facContended.get((Object)atype);
                if (count == null) {
                    n = 1;
                } else {
                    count = count + 1;
                    n = count;
                }
                facContended.put(atype, n);
                ++contendedCount;
            }
            int nextFieldOffset = (classData.superClass() == null ? this.model.headerSize() : 0) + superClassFieldsSize;
            boolean isContendedClass = classData.isContended();
            if (isContendedClass) {
                nextFieldOffset += CONTENDED_PADDING_WIDTH;
            }
            int doubleCount = (Integer)fieldsAllocationCount.get((Object)FieldAllocationType.DOUBLE) - (facContended.containsKey((Object)FieldAllocationType.DOUBLE) ? (Integer)facContended.get((Object)FieldAllocationType.DOUBLE) : 0);
            int wordCount = (Integer)fieldsAllocationCount.get((Object)FieldAllocationType.WORD) - (facContended.containsKey((Object)FieldAllocationType.WORD) ? (Integer)facContended.get((Object)FieldAllocationType.WORD) : 0);
            int shortCount = (Integer)fieldsAllocationCount.get((Object)FieldAllocationType.SHORT) - (facContended.containsKey((Object)FieldAllocationType.SHORT) ? (Integer)facContended.get((Object)FieldAllocationType.SHORT) : 0);
            int byteCount = (Integer)fieldsAllocationCount.get((Object)FieldAllocationType.BYTE) - (facContended.containsKey((Object)FieldAllocationType.BYTE) ? (Integer)facContended.get((Object)FieldAllocationType.BYTE) : 0);
            int oopCount = (Integer)fieldsAllocationCount.get((Object)FieldAllocationType.OOP) - (facContended.containsKey((Object)FieldAllocationType.OOP) ? (Integer)facContended.get((Object)FieldAllocationType.OOP) : 0);
            int firstOopOffset = 0;
            boolean compactFields = true;
            boolean allocationStyle = true;
            if (PREDEF_OFFSETS.contains(classData.name())) {
                allocationStyle = false;
                compactFields = false;
            }
            if (!allocationStyle) {
                nextOffset.put(FieldAllocationType.OOP, nextFieldOffset);
                nextOffset.put(FieldAllocationType.DOUBLE, (Integer)nextOffset.get((Object)FieldAllocationType.OOP) + oopCount * this.model.sizeOf("oop"));
            } else {
                nextOffset.put(FieldAllocationType.DOUBLE, nextFieldOffset);
            }
            if (doubleCount > 0) {
                int offset = (Integer)nextOffset.get((Object)FieldAllocationType.DOUBLE);
                nextOffset.put(FieldAllocationType.DOUBLE, MathUtil.align(offset, (int)((Integer)allocationTypeSizes.get((Object)FieldAllocationType.DOUBLE))));
                if (offset != (Integer)nextOffset.get((Object)FieldAllocationType.DOUBLE)) {
                    int length = (Integer)nextOffset.get((Object)FieldAllocationType.DOUBLE) - offset;
                    if (compactFields) {
                        if (wordCount > 0) {
                            --wordCount;
                            ((ArrayDeque)spaceOffset.get((Object)FieldAllocationType.WORD)).push(offset);
                            length -= ((Integer)allocationTypeSizes.get((Object)FieldAllocationType.WORD)).intValue();
                            offset += ((Integer)allocationTypeSizes.get((Object)FieldAllocationType.WORD)).intValue();
                        }
                        while (length >= (Integer)allocationTypeSizes.get((Object)FieldAllocationType.SHORT) && shortCount > 0) {
                            --shortCount;
                            ((ArrayDeque)spaceOffset.get((Object)FieldAllocationType.SHORT)).push(offset);
                            length -= ((Integer)allocationTypeSizes.get((Object)FieldAllocationType.SHORT)).intValue();
                            offset += ((Integer)allocationTypeSizes.get((Object)FieldAllocationType.SHORT)).intValue();
                        }
                        while (length > 0 && byteCount > 0) {
                            --byteCount;
                            ((ArrayDeque)spaceOffset.get((Object)FieldAllocationType.BYTE)).push(offset);
                            length -= ((Integer)allocationTypeSizes.get((Object)FieldAllocationType.BYTE)).intValue();
                            offset += ((Integer)allocationTypeSizes.get((Object)FieldAllocationType.BYTE)).intValue();
                        }
                        if (length >= (Integer)allocationTypeSizes.get((Object)FieldAllocationType.OOP) && oopCount > 0) {
                            --oopCount;
                            ((ArrayDeque)spaceOffset.get((Object)FieldAllocationType.OOP)).push(offset);
                        }
                    }
                }
            }
            nextOffset.put(FieldAllocationType.WORD, (Integer)nextOffset.get((Object)FieldAllocationType.DOUBLE) + doubleCount * (Integer)allocationTypeSizes.get((Object)FieldAllocationType.DOUBLE));
            nextOffset.put(FieldAllocationType.SHORT, (Integer)nextOffset.get((Object)FieldAllocationType.WORD) + wordCount * (Integer)allocationTypeSizes.get((Object)FieldAllocationType.WORD));
            nextOffset.put(FieldAllocationType.BYTE, (Integer)nextOffset.get((Object)FieldAllocationType.SHORT) + shortCount * (Integer)allocationTypeSizes.get((Object)FieldAllocationType.SHORT));
            nextPaddedOffset = (Integer)nextOffset.get((Object)FieldAllocationType.BYTE) + byteCount;
            if (allocationStyle) {
                nextOffset.put(FieldAllocationType.OOP, nextPaddedOffset);
                if (oopCount > 0) {
                    nextOffset.put(FieldAllocationType.OOP, MathUtil.align((Integer)nextOffset.get((Object)FieldAllocationType.OOP), (int)((Integer)allocationTypeSizes.get((Object)FieldAllocationType.OOP))));
                }
                nextPaddedOffset = (Integer)nextOffset.get((Object)FieldAllocationType.OOP) + oopCount * (Integer)allocationTypeSizes.get((Object)FieldAllocationType.OOP);
            }
            HashSet<FieldData> layoutedFields = new HashSet<FieldData>();
            for (FieldData f : classData.ownFields()) {
                int realOffset;
                if (layoutedFields.contains(f) || f.isContended()) continue;
                FieldAllocationType atype = FieldAllocationType.allocationTypeFor(f);
                int allocationTypeSize = (Integer)allocationTypeSizes.get((Object)atype);
                Integer allocationTypeSpaceOffset = (Integer)((ArrayDeque)spaceOffset.get((Object)atype)).poll();
                if (atype == FieldAllocationType.DOUBLE) {
                    int nextDoubleOffset = (Integer)nextOffset.get((Object)FieldAllocationType.DOUBLE);
                    realOffset = (Integer)nextOffset.get((Object)FieldAllocationType.DOUBLE);
                    nextOffset.put(atype, nextDoubleOffset + allocationTypeSize);
                } else if (allocationTypeSpaceOffset != null) {
                    realOffset = allocationTypeSpaceOffset;
                } else {
                    int allocationTypeNextOffset;
                    realOffset = allocationTypeNextOffset = ((Integer)nextOffset.get((Object)atype)).intValue();
                    nextOffset.put(atype, allocationTypeNextOffset + allocationTypeSize);
                }
                layoutedFields.add(f);
                result.add(new FieldLayout(f, realOffset, this.model.sizeOf(f.typeClass())));
            }
            if (contendedCount > 0) {
                nextPaddedOffset += CONTENDED_PADDING_WIDTH;
                HashSet<String> contendedGroups = new HashSet<String>();
                for (FieldData f : classData.ownFields()) {
                    if (!f.isContended()) continue;
                    contendedGroups.add(f.contendedGroup());
                }
                for (String currentGroup : contendedGroups) {
                    for (FieldData f : classData.ownFields()) {
                        if (layoutedFields.contains(f) || !f.isContended() || !f.contendedGroup().equals(currentGroup)) continue;
                        FieldAllocationType atype = FieldAllocationType.allocationTypeFor(f);
                        int allocationTypeSize = (Integer)allocationTypeSizes.get((Object)atype);
                        int realOffset = nextPaddedOffset = MathUtil.align(nextPaddedOffset, allocationTypeSize);
                        nextPaddedOffset += allocationTypeSize;
                        if (atype == FieldAllocationType.OOP && firstOopOffset == 0) {
                            firstOopOffset = realOffset;
                        }
                        if (f.contendedGroup().equals("")) {
                            nextPaddedOffset += CONTENDED_PADDING_WIDTH;
                        }
                        result.add(new FieldLayout(f, realOffset, this.model.sizeOf(f.typeClass())));
                    }
                    if (currentGroup.equals("")) continue;
                    nextPaddedOffset += CONTENDED_PADDING_WIDTH;
                }
            }
            if (isContendedClass) {
                nextPaddedOffset += CONTENDED_PADDING_WIDTH;
            }
            superClassFieldsSize = MathUtil.align(nextPaddedOffset, this.model.sizeOf("oop"));
        }
        int minAlignment = this.model.objectAlignment();
        for (String k : cd.classHierarchy()) {
            List<FieldData> fields = cd.fieldsFor(k);
            for (FieldData f : fields) {
                minAlignment = Math.max(minAlignment, this.model.sizeOf(f.typeClass()));
            }
        }
        int n = MathUtil.align(nextPaddedOffset, minAlignment);
        return ClassLayout.create(cd, result, this.model, n, true);
    }

    public String toString() {
        return "Hotspot Layout Simulation (JDK " + this.jdkVersion + ", " + this.model + ")";
    }
}

