/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common;

import io.hops.hudi.com.esotericsoftware.kryo.Serializer;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.Archiveable;
import org.apache.flink.api.common.ArchivedExecutionConfig;
import org.apache.flink.api.common.ExecutionMode;
import org.apache.flink.api.common.InputDependencyConstraint;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.DescribedEnum;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.StateChangelogOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.TextElement;
import org.apache.flink.util.Preconditions;

@Public
public class ExecutionConfig
implements Serializable,
Archiveable<ArchivedExecutionConfig> {
    private static final long serialVersionUID = 1L;
    @Deprecated
    public static final int PARALLELISM_AUTO_MAX = Integer.MAX_VALUE;
    public static final int PARALLELISM_DEFAULT = -1;
    public static final int PARALLELISM_UNKNOWN = -2;
    private static final long DEFAULT_RESTART_DELAY = 10000L;
    private static final ConfigOption<ExecutionMode> EXECUTION_MODE = ConfigOptions.key("hidden.execution.mode").enumType(ExecutionMode.class).defaultValue(ExecutionMode.PIPELINED).withDescription("Defines how data exchange happens - batch or pipelined");
    @Deprecated
    private static final ConfigOption<Integer> EXECUTION_RETRIES = ConfigOptions.key("hidden.execution.retries").intType().defaultValue(-1).withDescription("Should no longer be used because it is subsumed by RestartStrategyConfiguration");
    private final Configuration configuration = new Configuration();
    @Deprecated
    private long executionRetryDelay = 10000L;
    private RestartStrategies.RestartStrategyConfiguration restartStrategyConfiguration = new RestartStrategies.FallbackRestartStrategyConfiguration();
    private GlobalJobParameters globalJobParameters = new GlobalJobParameters();
    private LinkedHashMap<Class<?>, SerializableSerializer<?>> registeredTypesWithKryoSerializers = new LinkedHashMap();
    private LinkedHashMap<Class<?>, Class<? extends Serializer<?>>> registeredTypesWithKryoSerializerClasses = new LinkedHashMap();
    private LinkedHashMap<Class<?>, SerializableSerializer<?>> defaultKryoSerializers = new LinkedHashMap();
    private LinkedHashMap<Class<?>, Class<? extends Serializer<?>>> defaultKryoSerializerClasses = new LinkedHashMap();
    private LinkedHashSet<Class<?>> registeredKryoTypes = new LinkedHashSet();
    private LinkedHashSet<Class<?>> registeredPojoTypes = new LinkedHashSet();

    public ExecutionConfig enableClosureCleaner() {
        return this.setClosureCleanerLevel(ClosureCleanerLevel.RECURSIVE);
    }

    public ExecutionConfig disableClosureCleaner() {
        return this.setClosureCleanerLevel(ClosureCleanerLevel.NONE);
    }

    public boolean isClosureCleanerEnabled() {
        return this.getClosureCleanerLevel() != ClosureCleanerLevel.NONE;
    }

    public ExecutionConfig setClosureCleanerLevel(ClosureCleanerLevel level) {
        this.configuration.set((ConfigOption)PipelineOptions.CLOSURE_CLEANER_LEVEL, level);
        return this;
    }

    public ClosureCleanerLevel getClosureCleanerLevel() {
        return this.configuration.get(PipelineOptions.CLOSURE_CLEANER_LEVEL);
    }

    @PublicEvolving
    public ExecutionConfig setAutoWatermarkInterval(long interval) {
        Preconditions.checkArgument(interval >= 0L, "Auto watermark interval must not be negative.");
        return this.setAutoWatermarkInterval(Duration.ofMillis(interval));
    }

    private ExecutionConfig setAutoWatermarkInterval(Duration autoWatermarkInterval) {
        this.configuration.set((ConfigOption)PipelineOptions.AUTO_WATERMARK_INTERVAL, autoWatermarkInterval);
        return this;
    }

    @PublicEvolving
    public long getAutoWatermarkInterval() {
        return this.configuration.get(PipelineOptions.AUTO_WATERMARK_INTERVAL).toMillis();
    }

    @PublicEvolving
    public ExecutionConfig setLatencyTrackingInterval(long interval) {
        this.configuration.set((ConfigOption)MetricOptions.LATENCY_INTERVAL, (Object)interval);
        return this;
    }

    @PublicEvolving
    public long getLatencyTrackingInterval() {
        return this.configuration.get(MetricOptions.LATENCY_INTERVAL);
    }

    @Internal
    public boolean isLatencyTrackingConfigured() {
        return this.configuration.getOptional(MetricOptions.LATENCY_INTERVAL).isPresent();
    }

    @Internal
    public long getPeriodicMaterializeIntervalMillis() {
        return this.configuration.get(StateChangelogOptions.PERIODIC_MATERIALIZATION_INTERVAL).toMillis();
    }

    @Internal
    public void setPeriodicMaterializeIntervalMillis(Duration periodicMaterializeInterval) {
        this.configuration.set((ConfigOption)StateChangelogOptions.PERIODIC_MATERIALIZATION_INTERVAL, periodicMaterializeInterval);
    }

    @Internal
    public int getMaterializationMaxAllowedFailures() {
        return this.configuration.get(StateChangelogOptions.MATERIALIZATION_MAX_FAILURES_ALLOWED);
    }

    @Internal
    public void setMaterializationMaxAllowedFailures(int materializationMaxAllowedFailures) {
        this.configuration.set((ConfigOption)StateChangelogOptions.MATERIALIZATION_MAX_FAILURES_ALLOWED, (Object)materializationMaxAllowedFailures);
    }

    public int getParallelism() {
        return this.configuration.get(CoreOptions.DEFAULT_PARALLELISM);
    }

    public ExecutionConfig setParallelism(int parallelism) {
        if (parallelism != -2) {
            if (parallelism < 1 && parallelism != -1) {
                throw new IllegalArgumentException("Parallelism must be at least one, or ExecutionConfig.PARALLELISM_DEFAULT (use system default).");
            }
            this.configuration.set((ConfigOption)CoreOptions.DEFAULT_PARALLELISM, (Object)parallelism);
        }
        return this;
    }

    @Internal
    public void resetParallelism() {
        this.configuration.removeConfig(CoreOptions.DEFAULT_PARALLELISM);
    }

    @PublicEvolving
    public int getMaxParallelism() {
        return this.configuration.get(PipelineOptions.MAX_PARALLELISM);
    }

    @PublicEvolving
    public void setMaxParallelism(int maxParallelism) {
        Preconditions.checkArgument(maxParallelism > 0, "The maximum parallelism must be greater than 0.");
        this.configuration.set((ConfigOption)PipelineOptions.MAX_PARALLELISM, (Object)maxParallelism);
    }

    public long getTaskCancellationInterval() {
        return this.configuration.get(TaskManagerOptions.TASK_CANCELLATION_INTERVAL);
    }

    public ExecutionConfig setTaskCancellationInterval(long interval) {
        this.configuration.set((ConfigOption)TaskManagerOptions.TASK_CANCELLATION_INTERVAL, (Object)interval);
        return this;
    }

    @PublicEvolving
    public long getTaskCancellationTimeout() {
        return this.configuration.get(TaskManagerOptions.TASK_CANCELLATION_TIMEOUT);
    }

    @PublicEvolving
    public ExecutionConfig setTaskCancellationTimeout(long timeout) {
        Preconditions.checkArgument(timeout >= 0L, "Timeout needs to be >= 0.");
        this.configuration.set((ConfigOption)TaskManagerOptions.TASK_CANCELLATION_TIMEOUT, (Object)timeout);
        return this;
    }

    @PublicEvolving
    public void setRestartStrategy(RestartStrategies.RestartStrategyConfiguration restartStrategyConfiguration) {
        this.restartStrategyConfiguration = Preconditions.checkNotNull(restartStrategyConfiguration);
    }

    @PublicEvolving
    public RestartStrategies.RestartStrategyConfiguration getRestartStrategy() {
        if (this.restartStrategyConfiguration instanceof RestartStrategies.FallbackRestartStrategyConfiguration) {
            if (this.getNumberOfExecutionRetries() > 0 && this.getExecutionRetryDelay() >= 0L) {
                return RestartStrategies.fixedDelayRestart(this.getNumberOfExecutionRetries(), this.getExecutionRetryDelay());
            }
            if (this.getNumberOfExecutionRetries() == 0) {
                return RestartStrategies.noRestart();
            }
            return this.restartStrategyConfiguration;
        }
        return this.restartStrategyConfiguration;
    }

    @Internal
    public Optional<JobManagerOptions.SchedulerType> getSchedulerType() {
        return this.configuration.getOptional(JobManagerOptions.SCHEDULER);
    }

    @Deprecated
    public int getNumberOfExecutionRetries() {
        return this.configuration.get(EXECUTION_RETRIES);
    }

    @Deprecated
    public long getExecutionRetryDelay() {
        return this.executionRetryDelay;
    }

    @Deprecated
    public ExecutionConfig setNumberOfExecutionRetries(int numberOfExecutionRetries) {
        if (numberOfExecutionRetries < -1) {
            throw new IllegalArgumentException("The number of execution retries must be non-negative, or -1 (use system default)");
        }
        this.configuration.set((ConfigOption)EXECUTION_RETRIES, (Object)numberOfExecutionRetries);
        return this;
    }

    @Deprecated
    public ExecutionConfig setExecutionRetryDelay(long executionRetryDelay) {
        if (executionRetryDelay < 0L) {
            throw new IllegalArgumentException("The delay between retries must be non-negative.");
        }
        this.executionRetryDelay = executionRetryDelay;
        return this;
    }

    public void setExecutionMode(ExecutionMode executionMode) {
        this.configuration.set((ConfigOption)EXECUTION_MODE, (Object)executionMode);
    }

    public ExecutionMode getExecutionMode() {
        return this.configuration.get(EXECUTION_MODE);
    }

    @Deprecated
    @PublicEvolving
    public void setDefaultInputDependencyConstraint(InputDependencyConstraint ignored) {
    }

    @Deprecated
    @PublicEvolving
    public InputDependencyConstraint getDefaultInputDependencyConstraint() {
        return InputDependencyConstraint.ANY;
    }

    public void enableForceKryo() {
        this.setForceKryo(true);
    }

    public void disableForceKryo() {
        this.setForceKryo(false);
    }

    private void setForceKryo(boolean forceKryo) {
        this.configuration.set((ConfigOption)PipelineOptions.FORCE_KRYO, (Object)forceKryo);
    }

    public boolean isForceKryoEnabled() {
        return this.configuration.get(PipelineOptions.FORCE_KRYO);
    }

    public void enableGenericTypes() {
        this.setGenericTypes(true);
    }

    public void disableGenericTypes() {
        this.setGenericTypes(false);
    }

    private void setGenericTypes(boolean genericTypes) {
        this.configuration.set((ConfigOption)PipelineOptions.GENERIC_TYPES, (Object)genericTypes);
    }

    public boolean hasGenericTypesDisabled() {
        return this.configuration.get(PipelineOptions.GENERIC_TYPES) == false;
    }

    public void enableAutoGeneratedUIDs() {
        this.setAutoGeneratedUids(true);
    }

    public void disableAutoGeneratedUIDs() {
        this.setAutoGeneratedUids(false);
    }

    private void setAutoGeneratedUids(boolean autoGeneratedUids) {
        this.configuration.set((ConfigOption)PipelineOptions.AUTO_GENERATE_UIDS, (Object)autoGeneratedUids);
    }

    public boolean hasAutoGeneratedUIDsEnabled() {
        return this.configuration.get(PipelineOptions.AUTO_GENERATE_UIDS);
    }

    public void enableForceAvro() {
        this.setForceAvro(true);
    }

    public void disableForceAvro() {
        this.setForceAvro(false);
    }

    private void setForceAvro(boolean forceAvro) {
        this.configuration.set((ConfigOption)PipelineOptions.FORCE_AVRO, (Object)forceAvro);
    }

    public boolean isForceAvroEnabled() {
        return this.configuration.get(PipelineOptions.FORCE_AVRO);
    }

    public ExecutionConfig enableObjectReuse() {
        return this.setObjectReuse(true);
    }

    public ExecutionConfig disableObjectReuse() {
        return this.setObjectReuse(false);
    }

    private ExecutionConfig setObjectReuse(boolean objectReuse) {
        this.configuration.set((ConfigOption)PipelineOptions.OBJECT_REUSE, (Object)objectReuse);
        return this;
    }

    public boolean isObjectReuseEnabled() {
        return this.configuration.get(PipelineOptions.OBJECT_REUSE);
    }

    public GlobalJobParameters getGlobalJobParameters() {
        return this.globalJobParameters;
    }

    public void setGlobalJobParameters(GlobalJobParameters globalJobParameters) {
        Preconditions.checkNotNull(globalJobParameters, "globalJobParameters shouldn't be null");
        this.globalJobParameters = globalJobParameters;
    }

    public <T extends Serializer<?>> void addDefaultKryoSerializer(Class<?> type, T serializer) {
        if (type == null || serializer == null) {
            throw new NullPointerException("Cannot register null class or serializer.");
        }
        this.defaultKryoSerializers.put(type, new SerializableSerializer<T>(serializer));
    }

    public void addDefaultKryoSerializer(Class<?> type, Class<? extends Serializer<?>> serializerClass) {
        if (type == null || serializerClass == null) {
            throw new NullPointerException("Cannot register null class or serializer.");
        }
        this.defaultKryoSerializerClasses.put(type, serializerClass);
    }

    public <T extends Serializer<?>> void registerTypeWithKryoSerializer(Class<?> type, T serializer) {
        if (type == null || serializer == null) {
            throw new NullPointerException("Cannot register null class or serializer.");
        }
        this.registeredTypesWithKryoSerializers.put(type, new SerializableSerializer<T>(serializer));
    }

    public void registerTypeWithKryoSerializer(Class<?> type, Class<? extends Serializer> serializerClass) {
        if (type == null || serializerClass == null) {
            throw new NullPointerException("Cannot register null class or serializer.");
        }
        Class<? extends Serializer> castedSerializerClass = serializerClass;
        this.registeredTypesWithKryoSerializerClasses.put(type, castedSerializerClass);
    }

    public void registerPojoType(Class<?> type) {
        if (type == null) {
            throw new NullPointerException("Cannot register null type class.");
        }
        if (!this.registeredPojoTypes.contains(type)) {
            this.registeredPojoTypes.add(type);
        }
    }

    public void registerKryoType(Class<?> type) {
        if (type == null) {
            throw new NullPointerException("Cannot register null type class.");
        }
        this.registeredKryoTypes.add(type);
    }

    public LinkedHashMap<Class<?>, SerializableSerializer<?>> getRegisteredTypesWithKryoSerializers() {
        return this.registeredTypesWithKryoSerializers;
    }

    public LinkedHashMap<Class<?>, Class<? extends Serializer<?>>> getRegisteredTypesWithKryoSerializerClasses() {
        return this.registeredTypesWithKryoSerializerClasses;
    }

    public LinkedHashMap<Class<?>, SerializableSerializer<?>> getDefaultKryoSerializers() {
        return this.defaultKryoSerializers;
    }

    public LinkedHashMap<Class<?>, Class<? extends Serializer<?>>> getDefaultKryoSerializerClasses() {
        return this.defaultKryoSerializerClasses;
    }

    public LinkedHashSet<Class<?>> getRegisteredKryoTypes() {
        if (this.isForceKryoEnabled()) {
            LinkedHashSet result = new LinkedHashSet();
            result.addAll(this.registeredKryoTypes);
            for (Class clazz : this.registeredPojoTypes) {
                if (result.contains(clazz)) continue;
                result.add(clazz);
            }
            return result;
        }
        return this.registeredKryoTypes;
    }

    public LinkedHashSet<Class<?>> getRegisteredPojoTypes() {
        return this.registeredPojoTypes;
    }

    public boolean isAutoTypeRegistrationDisabled() {
        return this.configuration.get(PipelineOptions.AUTO_TYPE_REGISTRATION) == false;
    }

    public void disableAutoTypeRegistration() {
        this.setAutoTypeRegistration(false);
    }

    private void setAutoTypeRegistration(Boolean autoTypeRegistration) {
        this.configuration.set((ConfigOption)PipelineOptions.AUTO_TYPE_REGISTRATION, autoTypeRegistration);
    }

    public boolean isUseSnapshotCompression() {
        return this.configuration.get(ExecutionOptions.SNAPSHOT_COMPRESSION);
    }

    public void setUseSnapshotCompression(boolean useSnapshotCompression) {
        this.configuration.set((ConfigOption)ExecutionOptions.SNAPSHOT_COMPRESSION, (Object)useSnapshotCompression);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExecutionConfig) {
            ExecutionConfig other = (ExecutionConfig)obj;
            return other.canEqual(this) && Objects.equals(this.configuration, other.configuration) && (this.restartStrategyConfiguration == null && other.restartStrategyConfiguration == null || null != this.restartStrategyConfiguration && this.restartStrategyConfiguration.equals(other.restartStrategyConfiguration)) && Objects.equals(this.globalJobParameters, other.globalJobParameters) && this.registeredTypesWithKryoSerializerClasses.equals(other.registeredTypesWithKryoSerializerClasses) && this.defaultKryoSerializerClasses.equals(other.defaultKryoSerializerClasses) && this.registeredKryoTypes.equals(other.registeredKryoTypes) && this.registeredPojoTypes.equals(other.registeredPojoTypes);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.configuration, this.restartStrategyConfiguration, this.globalJobParameters, this.registeredTypesWithKryoSerializerClasses, this.defaultKryoSerializerClasses, this.registeredKryoTypes, this.registeredPojoTypes);
    }

    public String toString() {
        return "ExecutionConfig{configuration=" + this.configuration + ", executionRetryDelay=" + this.executionRetryDelay + ", restartStrategyConfiguration=" + this.restartStrategyConfiguration + ", globalJobParameters=" + this.globalJobParameters + ", registeredTypesWithKryoSerializers=" + this.registeredTypesWithKryoSerializers + ", registeredTypesWithKryoSerializerClasses=" + this.registeredTypesWithKryoSerializerClasses + ", defaultKryoSerializers=" + this.defaultKryoSerializers + ", defaultKryoSerializerClasses=" + this.defaultKryoSerializerClasses + ", registeredKryoTypes=" + this.registeredKryoTypes + ", registeredPojoTypes=" + this.registeredPojoTypes + '}';
    }

    public boolean canEqual(Object obj) {
        return obj instanceof ExecutionConfig;
    }

    @Override
    @Internal
    public ArchivedExecutionConfig archive() {
        return new ArchivedExecutionConfig(this);
    }

    public void configure(ReadableConfig configuration, ClassLoader classLoader) {
        configuration.getOptional(PipelineOptions.AUTO_TYPE_REGISTRATION).ifPresent(this::setAutoTypeRegistration);
        configuration.getOptional(PipelineOptions.AUTO_GENERATE_UIDS).ifPresent(this::setAutoGeneratedUids);
        configuration.getOptional(PipelineOptions.AUTO_WATERMARK_INTERVAL).ifPresent(this::setAutoWatermarkInterval);
        configuration.getOptional(PipelineOptions.CLOSURE_CLEANER_LEVEL).ifPresent(this::setClosureCleanerLevel);
        configuration.getOptional(PipelineOptions.FORCE_AVRO).ifPresent(this::setForceAvro);
        configuration.getOptional(PipelineOptions.GENERIC_TYPES).ifPresent(this::setGenericTypes);
        configuration.getOptional(PipelineOptions.FORCE_KRYO).ifPresent(this::setForceKryo);
        configuration.getOptional(PipelineOptions.GLOBAL_JOB_PARAMETERS).map(x$0 -> new MapBasedJobParameters((Map)x$0)).ifPresent(this::setGlobalJobParameters);
        configuration.getOptional(MetricOptions.LATENCY_INTERVAL).ifPresent(this::setLatencyTrackingInterval);
        configuration.getOptional(StateChangelogOptions.PERIODIC_MATERIALIZATION_INTERVAL).ifPresent(this::setPeriodicMaterializeIntervalMillis);
        configuration.getOptional(StateChangelogOptions.MATERIALIZATION_MAX_FAILURES_ALLOWED).ifPresent(this::setMaterializationMaxAllowedFailures);
        configuration.getOptional(PipelineOptions.MAX_PARALLELISM).ifPresent(this::setMaxParallelism);
        configuration.getOptional(CoreOptions.DEFAULT_PARALLELISM).ifPresent(this::setParallelism);
        configuration.getOptional(PipelineOptions.OBJECT_REUSE).ifPresent(this::setObjectReuse);
        configuration.getOptional(TaskManagerOptions.TASK_CANCELLATION_INTERVAL).ifPresent(this::setTaskCancellationInterval);
        configuration.getOptional(TaskManagerOptions.TASK_CANCELLATION_TIMEOUT).ifPresent(this::setTaskCancellationTimeout);
        configuration.getOptional(ExecutionOptions.SNAPSHOT_COMPRESSION).ifPresent(this::setUseSnapshotCompression);
        RestartStrategies.fromConfiguration(configuration).ifPresent(this::setRestartStrategy);
        configuration.getOptional(PipelineOptions.KRYO_DEFAULT_SERIALIZERS).map(s -> this.parseKryoSerializersWithExceptionHandling(classLoader, (List<String>)s)).ifPresent(s -> {
            this.defaultKryoSerializerClasses = s;
        });
        configuration.getOptional(PipelineOptions.POJO_REGISTERED_CLASSES).map(c -> this.loadClasses((List<String>)c, classLoader, "Could not load pojo type to be registered.")).ifPresent(c -> {
            this.registeredPojoTypes = c;
        });
        configuration.getOptional(PipelineOptions.KRYO_REGISTERED_CLASSES).map(c -> this.loadClasses((List<String>)c, classLoader, "Could not load kryo type to be registered.")).ifPresent(c -> {
            this.registeredKryoTypes = c;
        });
        configuration.getOptional(JobManagerOptions.SCHEDULER).ifPresent(t -> this.configuration.set((ConfigOption)JobManagerOptions.SCHEDULER, t));
    }

    @Internal
    public Configuration toConfiguration() {
        return new Configuration(this.configuration);
    }

    private LinkedHashSet<Class<?>> loadClasses(List<String> classNames, ClassLoader classLoader, String errorMessage) {
        return classNames.stream().map(name -> this.loadClass((String)name, classLoader, errorMessage)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private LinkedHashMap<Class<?>, Class<? extends Serializer<?>>> parseKryoSerializersWithExceptionHandling(ClassLoader classLoader, List<String> kryoSerializers) {
        try {
            return this.parseKryoSerializers(classLoader, kryoSerializers);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Could not configure kryo serializers from %s. The expected format is:'class:<fully qualified class name>,serializer:<fully qualified serializer name>;...", kryoSerializers), e);
        }
    }

    private LinkedHashMap<Class<?>, Class<? extends Serializer<?>>> parseKryoSerializers(ClassLoader classLoader, List<String> kryoSerializers) {
        return kryoSerializers.stream().map(ConfigurationUtils::parseMap).collect(Collectors.toMap(m -> this.loadClass((String)m.get("class"), classLoader, "Could not load class for kryo serialization"), m -> this.loadClass((String)m.get("serializer"), classLoader, "Could not load serializer's class"), (m1, m2) -> {
            throw new IllegalArgumentException("Duplicated serializer for class: " + m1);
        }, LinkedHashMap::new));
    }

    private <T extends Class> T loadClass(String className, ClassLoader classLoader, String errorMessage) {
        try {
            return (T)Class.forName(className, false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(errorMessage, e);
        }
    }

    private static class MapBasedJobParameters
    extends GlobalJobParameters {
        private final Map<String, String> properties;

        private MapBasedJobParameters(Map<String, String> properties) {
            this.properties = properties;
        }

        @Override
        public Map<String, String> toMap() {
            return this.properties;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof GlobalJobParameters)) {
                return false;
            }
            GlobalJobParameters that = (GlobalJobParameters)o;
            return Objects.equals(this.properties, that.toMap());
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.properties);
        }
    }

    public static enum ClosureCleanerLevel implements DescribedEnum
    {
        NONE(TextElement.text("Disables the closure cleaner completely.")),
        TOP_LEVEL(TextElement.text("Cleans only the top-level class without recursing into fields.")),
        RECURSIVE(TextElement.text("Cleans all fields recursively."));

        private final InlineElement description;

        private ClosureCleanerLevel(InlineElement description) {
            this.description = description;
        }

        @Override
        public InlineElement getDescription() {
            return this.description;
        }
    }

    public static class GlobalJobParameters
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public Map<String, String> toMap() {
            return Collections.emptyMap();
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass() == obj.getClass();
        }

        public int hashCode() {
            return Objects.hash(new Object[0]);
        }
    }

    public static class SerializableSerializer<T extends Serializer<?>>
    implements Serializable {
        private static final long serialVersionUID = 4687893502781067189L;
        private T serializer;

        public SerializableSerializer(T serializer) {
            this.serializer = serializer;
        }

        public T getSerializer() {
            return this.serializer;
        }
    }
}

