/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import io.hops.hudi.com.esotericsoftware.kryo.Kryo;
import io.hops.hudi.com.esotericsoftware.kryo.KryoException;
import io.hops.hudi.com.esotericsoftware.kryo.Serializer;
import java.io.IOException;
import java.util.Collection;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.KryoRegistration;
import org.apache.flink.util.InstantiationUtil;

@Internal
public class KryoUtils {
    public static <T> T copy(T from, Kryo kryo, TypeSerializer<T> serializer) {
        try {
            return kryo.copy(from);
        }
        catch (KryoException ke) {
            try {
                byte[] byteArray = InstantiationUtil.serializeToByteArray(serializer, from);
                return InstantiationUtil.deserializeFromByteArray(serializer, byteArray);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Could not copy object by serializing/deserializing it.", ioe);
            }
        }
    }

    public static <T> T copy(T from, T reuse, Kryo kryo, TypeSerializer<T> serializer) {
        try {
            return kryo.copy(from);
        }
        catch (KryoException ke) {
            try {
                byte[] byteArray = InstantiationUtil.serializeToByteArray(serializer, from);
                return InstantiationUtil.deserializeFromByteArray(serializer, reuse, byteArray);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Could not copy object by serializing/deserializing it.", ioe);
            }
        }
    }

    public static void applyRegistrations(Kryo kryo, Collection<KryoRegistration> resolvedRegistrations, int firstRegistrationId) {
        int currentRegistrationId = firstRegistrationId;
        for (KryoRegistration registration : resolvedRegistrations) {
            Serializer<?> serializer = registration.getSerializer(kryo);
            if (serializer != null) {
                kryo.register(registration.getRegisteredClass(), serializer, currentRegistrationId);
            } else {
                kryo.register(registration.getRegisteredClass(), currentRegistrationId);
            }
            if (kryo.getRegistration(currentRegistrationId) == null) continue;
            ++currentRegistrationId;
        }
    }
}

