/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import io.hops.hudi.com.esotericsoftware.kryo.KryoException;
import io.hops.hudi.com.esotericsoftware.kryo.io.Input;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.annotation.Internal;

@Internal
public class NoFetchingInput
extends Input {
    public NoFetchingInput(InputStream inputStream) {
        super(inputStream, 8);
    }

    @Override
    public boolean eof() {
        throw new UnsupportedOperationException("NoFetchingInput does not support EOF.");
    }

    @Override
    public int read() throws KryoException {
        this.require(1);
        return this.buffer[this.position++] & 0xFF;
    }

    @Override
    public boolean canReadInt() throws KryoException {
        throw new UnsupportedOperationException("NoFetchingInput cannot prefetch data.");
    }

    @Override
    public boolean canReadLong() throws KryoException {
        throw new UnsupportedOperationException("NoFetchingInput cannot prefetch data.");
    }

    @Override
    protected int require(int required) throws KryoException {
        int count;
        if (required > this.capacity) {
            throw new KryoException("Buffer too small: capacity: " + this.capacity + ", required: " + required);
        }
        this.position = 0;
        int bytesRead = 0;
        do {
            if ((count = this.fill(this.buffer, bytesRead, required - bytesRead)) != -1) continue;
            throw new KryoException(new EOFException("No more bytes left."));
        } while ((bytesRead += count) != required);
        this.limit = required;
        return required;
    }

    @Override
    public int read(byte[] bytes, int offset, int count) throws KryoException {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        try {
            return this.inputStream.read(bytes, offset, count);
        }
        catch (IOException ex) {
            throw new KryoException(ex);
        }
    }

    @Override
    public void skip(int count) throws KryoException {
        try {
            this.inputStream.skip(count);
        }
        catch (IOException ex) {
            throw new KryoException(ex);
        }
    }

    @Override
    public void readBytes(byte[] bytes, int offset, int count) throws KryoException {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        try {
            int c;
            int bytesRead = 0;
            do {
                if ((c = this.inputStream.read(bytes, offset + bytesRead, count - bytesRead)) != -1) continue;
                throw new KryoException(new EOFException("No more bytes left."));
            } while ((bytesRead += c) != count);
        }
        catch (IOException ex) {
            throw new KryoException(ex);
        }
    }
}

