/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.time.Duration;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.docs.ConfigGroup;
import org.apache.flink.annotation.docs.ConfigGroups;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.TextElement;
import org.apache.flink.shaded.guava30.com.google.common.collect.ImmutableSet;

@ConfigGroups(groups={@ConfigGroup(name="ExponentialDelayCleanupStrategy", keyPrefix="cleanup-strategy.exponential-delay"), @ConfigGroup(name="FixedDelayCleanupStrategy", keyPrefix="cleanup-strategy.fixed-delay")})
@PublicEvolving
public class CleanupOptions {
    private static final String CLEANUP_STRATEGY_PARAM = "cleanup-strategy";
    public static final String FIXED_DELAY_LABEL = "fixed-delay";
    public static final String EXPONENTIAL_DELAY_LABEL = "exponential-delay";
    public static final Set<String> NONE_PARAM_VALUES = ImmutableSet.of((Object)"none", (Object)"disable", (Object)"off");
    public static final ConfigOption<String> CLEANUP_STRATEGY = ConfigOptions.key("cleanup-strategy.type").stringType().defaultValue("exponential-delay").withDeprecatedKeys("cleanup-strategy").withDescription(Description.builder().text("Defines the cleanup strategy to use in case of cleanup failures.").linebreak().text("Accepted values are:").list(TextElement.text(NONE_PARAM_VALUES.stream().map(ignored -> "%s").collect(Collectors.joining(", ")) + ": Cleanup is only performed once. No retry will be initiated in case of failure. The job artifacts (and the job's JobResultStore entry) have to be cleaned up manually in case of a failure.", NONE_PARAM_VALUES.stream().map(TextElement::code).collect(Collectors.toList()).toArray(new TextElement[NONE_PARAM_VALUES.size()])), TextElement.text("%s, %s: Cleanup attempts will be separated by a fixed interval up to the point where the cleanup is considered successful or a set amount of retries is reached. Reaching the configured limit means that the job artifacts (and the job's JobResultStore entry) might need to be cleaned up manually.", TextElement.code("fixed-delay"), TextElement.code(CleanupOptions.extractAlphaNumericCharacters("fixed-delay"))), TextElement.text("%s, %s: Exponential delay restart strategy triggers the cleanup with an exponentially increasing delay up to the point where the cleanup succeeded or a set amount of retries is reached. Reaching the configured limit means that the job artifacts (and the job's JobResultStore entry) might need to be cleaned up manually.", TextElement.code("exponential-delay"), TextElement.code(CleanupOptions.extractAlphaNumericCharacters("exponential-delay")))).text("The default configuration relies on an exponentially delayed retry strategy with the given default values.").build());
    @Documentation.OverrideDefault(value="infinite")
    public static final ConfigOption<Integer> CLEANUP_STRATEGY_FIXED_DELAY_ATTEMPTS = ConfigOptions.key(CleanupOptions.createFixedDelayParameterPrefix("attempts")).intType().defaultValue(Integer.MAX_VALUE).withDescription(Description.builder().text("The number of times that Flink retries the cleanup before giving up if %s has been set to %s. Reaching the configured limit means that the job artifacts (and the job's JobResultStore entry) might need to be cleaned up manually.", TextElement.code(CLEANUP_STRATEGY.key()), TextElement.code("fixed-delay")).build());
    public static final ConfigOption<Duration> CLEANUP_STRATEGY_FIXED_DELAY_DELAY = ConfigOptions.key(CleanupOptions.createFixedDelayParameterPrefix("delay")).durationType().defaultValue(Duration.ofMinutes(1L)).withDescription(Description.builder().text("Amount of time that Flink waits before re-triggering the cleanup after a failed attempt if the %s is set to %s. It can be specified using the following notation: \"1 min\", \"20 s\"", TextElement.code(CLEANUP_STRATEGY.key()), TextElement.code("fixed-delay")).build());
    public static final ConfigOption<Duration> CLEANUP_STRATEGY_EXPONENTIAL_DELAY_INITIAL_BACKOFF = ConfigOptions.key(CleanupOptions.createExponentialBackoffParameterPrefix("initial-backoff")).durationType().defaultValue(Duration.ofSeconds(1L)).withDescription(Description.builder().text("Starting duration between cleanup retries if %s has been set to %s. It can be specified using the following notation: \"1 min\", \"20 s\"", TextElement.code(CLEANUP_STRATEGY.key()), TextElement.code("exponential-delay")).build());
    public static final ConfigOption<Duration> CLEANUP_STRATEGY_EXPONENTIAL_DELAY_MAX_BACKOFF = ConfigOptions.key(CleanupOptions.createExponentialBackoffParameterPrefix("max-backoff")).durationType().defaultValue(Duration.ofHours(1L)).withDescription(Description.builder().text("The highest possible duration between cleanup retries if %s has been set to %s. It can be specified using the following notation: \"1 min\", \"20 s\"", TextElement.code(CLEANUP_STRATEGY.key()), TextElement.code("exponential-delay")).build());
    @Documentation.OverrideDefault(value="infinite")
    public static final ConfigOption<Integer> CLEANUP_STRATEGY_EXPONENTIAL_DELAY_MAX_ATTEMPTS = ConfigOptions.key(CleanupOptions.createExponentialBackoffParameterPrefix("attempts")).intType().defaultValue(Integer.MAX_VALUE).withDescription(Description.builder().text("The number of times a failed cleanup is retried if %s has been set to %s. Reaching the configured limit means that the job artifacts (and the job's JobResultStore entry) might need to be cleaned up manually.", TextElement.code(CLEANUP_STRATEGY.key()), TextElement.code("exponential-delay")).build());

    private static String createParameterPrefix(String paramGroupKey) {
        return "cleanup-strategy." + paramGroupKey + ".";
    }

    private static String createFixedDelayParameterPrefix(String parameter) {
        return CleanupOptions.createParameterPrefix(FIXED_DELAY_LABEL) + parameter;
    }

    private static String createExponentialBackoffParameterPrefix(String parameter) {
        return CleanupOptions.createParameterPrefix(EXPONENTIAL_DELAY_LABEL) + parameter;
    }

    public static String extractAlphaNumericCharacters(String paramName) {
        return paramName.replaceAll("[^a-zA-Z0-9]", "");
    }
}

