/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.memory;

import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.MemoryUtils;
import sun.misc.Unsafe;

public class DataInputDeserializer
implements DataInputView,
Serializable {
    private static final byte[] EMPTY = new byte[0];
    private static final long serialVersionUID = 1L;
    private byte[] buffer;
    private int end;
    private int position;
    private static final Unsafe UNSAFE = MemoryUtils.UNSAFE;
    private static final long BASE_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
    private static final boolean LITTLE_ENDIAN = MemoryUtils.NATIVE_BYTE_ORDER == ByteOrder.LITTLE_ENDIAN;

    public DataInputDeserializer() {
        this.setBuffer(EMPTY);
    }

    public DataInputDeserializer(@Nonnull byte[] buffer) {
        this.setBufferInternal(buffer, 0, buffer.length);
    }

    public DataInputDeserializer(@Nonnull byte[] buffer, int start2, int len) {
        this.setBuffer(buffer, start2, len);
    }

    public DataInputDeserializer(@Nonnull ByteBuffer buffer) {
        this.setBuffer(buffer);
    }

    public void setBuffer(@Nonnull ByteBuffer buffer) {
        if (buffer.hasArray()) {
            this.buffer = buffer.array();
            this.position = buffer.arrayOffset() + buffer.position();
            this.end = this.position + buffer.remaining();
        } else if (buffer.isDirect() || buffer.isReadOnly()) {
            this.buffer = new byte[buffer.remaining()];
            this.position = 0;
            this.end = this.buffer.length;
            buffer.get(this.buffer);
        } else {
            throw new IllegalArgumentException("The given buffer is neither an array-backed heap ByteBuffer, nor a direct ByteBuffer.");
        }
    }

    public void setBuffer(@Nonnull byte[] buffer, int start2, int len) {
        if (start2 < 0 || len < 0 || start2 + len > buffer.length) {
            throw new IllegalArgumentException("Invalid bounds.");
        }
        this.setBufferInternal(buffer, start2, len);
    }

    public void setBuffer(@Nonnull byte[] buffer) {
        this.setBufferInternal(buffer, 0, buffer.length);
    }

    private void setBufferInternal(@Nonnull byte[] buffer, int start2, int len) {
        this.buffer = buffer;
        this.position = start2;
        this.end = start2 + len;
    }

    public void releaseArrays() {
        this.buffer = null;
    }

    public int available() {
        if (this.position < this.end) {
            return this.end - this.position;
        }
        return 0;
    }

    @Override
    public boolean readBoolean() throws IOException {
        if (this.position < this.end) {
            return this.buffer[this.position++] != 0;
        }
        throw new EOFException();
    }

    @Override
    public byte readByte() throws IOException {
        if (this.position < this.end) {
            return this.buffer[this.position++];
        }
        throw new EOFException();
    }

    @Override
    public char readChar() throws IOException {
        if (this.position < this.end - 1) {
            return (char)((this.buffer[this.position++] & 0xFF) << 8 | this.buffer[this.position++] & 0xFF);
        }
        throw new EOFException();
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public void readFully(@Nonnull byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void readFully(@Nonnull byte[] b, int off, int len) throws IOException {
        if (len < 0) throw new IllegalArgumentException("Length may not be negative.");
        if (off > b.length - len) throw new ArrayIndexOutOfBoundsException();
        if (this.position > this.end - len) throw new EOFException();
        System.arraycopy(this.buffer, this.position, b, off, len);
        this.position += len;
    }

    @Override
    public int readInt() throws IOException {
        if (this.position >= 0 && this.position < this.end - 3) {
            int value = UNSAFE.getInt(this.buffer, BASE_OFFSET + (long)this.position);
            if (LITTLE_ENDIAN) {
                value = Integer.reverseBytes(value);
            }
            this.position += 4;
            return value;
        }
        throw new EOFException();
    }

    @Override
    @Nullable
    public String readLine() throws IOException {
        if (this.position < this.end) {
            StringBuilder bld = new StringBuilder();
            char curr = (char)this.readUnsignedByte();
            while (this.position < this.end && curr != '\n') {
                bld.append(curr);
                curr = (char)this.readUnsignedByte();
            }
            int len = bld.length();
            if (len > 0 && bld.charAt(len - 1) == '\r') {
                bld.setLength(len - 1);
            }
            String s = bld.toString();
            bld.setLength(0);
            return s;
        }
        return null;
    }

    @Override
    public long readLong() throws IOException {
        if (this.position >= 0 && this.position < this.end - 7) {
            long value = UNSAFE.getLong(this.buffer, BASE_OFFSET + (long)this.position);
            if (LITTLE_ENDIAN) {
                value = Long.reverseBytes(value);
            }
            this.position += 8;
            return value;
        }
        throw new EOFException();
    }

    @Override
    public short readShort() throws IOException {
        if (this.position >= 0 && this.position < this.end - 1) {
            return (short)((this.buffer[this.position++] & 0xFF) << 8 | this.buffer[this.position++] & 0xFF);
        }
        throw new EOFException();
    }

    @Override
    @Nonnull
    public String readUTF() throws IOException {
        int c;
        int count;
        int utflen = this.readUnsignedShort();
        byte[] bytearr = new byte[utflen];
        char[] chararr = new char[utflen];
        int chararrCount = 0;
        this.readFully(bytearr, 0, utflen);
        for (count = 0; count < utflen && (c = bytearr[count] & 0xFF) <= 127; ++count) {
            chararr[chararrCount++] = (char)c;
        }
        block6: while (count < utflen) {
            c = bytearr[count] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    chararr[chararrCount++] = (char)c;
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + count);
                    }
                    chararr[chararrCount++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    continue block6;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (count - 1));
                    }
                    chararr[chararrCount++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + count);
        }
        return new String(chararr, 0, chararrCount);
    }

    @Override
    public int readUnsignedByte() throws IOException {
        if (this.position < this.end) {
            return this.buffer[this.position++] & 0xFF;
        }
        throw new EOFException();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        if (this.position < this.end - 1) {
            return (this.buffer[this.position++] & 0xFF) << 8 | this.buffer[this.position++] & 0xFF;
        }
        throw new EOFException();
    }

    @Override
    public int skipBytes(int n) {
        if (this.position <= this.end - n) {
            this.position += n;
            return n;
        }
        n = this.end - this.position;
        this.position = this.end;
        return n;
    }

    @Override
    public void skipBytesToRead(int numBytes) throws IOException {
        int skippedBytes = this.skipBytes(numBytes);
        if (skippedBytes < numBytes) {
            throw new EOFException("Could not skip " + numBytes + " bytes.");
        }
    }

    @Override
    public int read(@Nonnull byte[] b, int off, int len) throws IOException {
        if (off < 0) {
            throw new IndexOutOfBoundsException("Offset cannot be negative.");
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException("Length cannot be negative.");
        }
        if (b.length - off < len) {
            throw new IndexOutOfBoundsException("Byte array does not provide enough space to store requested data.");
        }
        if (this.position >= this.end) {
            return len == 0 ? 0 : -1;
        }
        int toRead = Math.min(this.end - this.position, len);
        System.arraycopy(this.buffer, this.position, b, off, toRead);
        this.position += toRead;
        return toRead;
    }

    @Override
    public int read(@Nonnull byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int getPosition() {
        return this.position;
    }
}

