/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types.parser;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.types.parser.FieldParser;

@PublicEvolving
public class BooleanParser
extends FieldParser<Boolean> {
    private boolean result;
    private static final byte[][] TRUE = new byte[][]{"true".getBytes(ConfigConstants.DEFAULT_CHARSET), "1".getBytes(ConfigConstants.DEFAULT_CHARSET)};
    private static final byte[][] FALSE = new byte[][]{"false".getBytes(ConfigConstants.DEFAULT_CHARSET), "0".getBytes(ConfigConstants.DEFAULT_CHARSET)};

    @Override
    public int parseField(byte[] bytes, int startPos, int limit, byte[] delimiter, Boolean reuse) {
        int i = this.nextStringEndPos(bytes, startPos, limit, delimiter);
        if (i < 0) {
            return -1;
        }
        for (byte[] aTRUE : TRUE) {
            if (!BooleanParser.byteArrayEquals(bytes, startPos, i - startPos, aTRUE)) continue;
            this.result = true;
            return i == limit ? limit : i + delimiter.length;
        }
        for (byte[] aFALSE : FALSE) {
            if (!BooleanParser.byteArrayEquals(bytes, startPos, i - startPos, aFALSE)) continue;
            this.result = false;
            return i == limit ? limit : i + delimiter.length;
        }
        this.setErrorState(FieldParser.ParseErrorState.BOOLEAN_INVALID);
        return -1;
    }

    @Override
    public Boolean getLastResult() {
        return this.result;
    }

    @Override
    public Boolean createValue() {
        return false;
    }

    private static boolean byteArrayEquals(byte[] source, int start2, int length, byte[] other) {
        if (length != other.length) {
            return false;
        }
        for (int i = 0; i < other.length; ++i) {
            if (Character.toLowerCase(source[i + start2]) == other[i]) continue;
            return false;
        }
        return true;
    }
}

