/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import io.hops.hudi.com.esotericsoftware.kryo.Kryo;
import io.hops.hudi.com.esotericsoftware.kryo.Serializer;
import io.hops.hudi.com.esotericsoftware.kryo.io.Input;
import io.hops.hudi.com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;

public class GenericAvroSerializer<D extends GenericContainer>
extends Serializer<D> {
    private final HashMap<Schema, DatumWriter<D>> writerCache = new HashMap();
    private final HashMap<Schema, DatumReader<D>> readerCache = new HashMap();
    private final HashMap<Schema, byte[]> encodeCache = new HashMap();
    private final HashMap<ByteBuffer, Schema> schemaCache = new HashMap();

    private byte[] getSchemaBytes(Schema schema) {
        if (this.encodeCache.containsKey(schema)) {
            return this.encodeCache.get(schema);
        }
        byte[] schemaBytes = schema.toString().getBytes(StandardCharsets.UTF_8);
        this.encodeCache.put(schema, schemaBytes);
        return schemaBytes;
    }

    private Schema getSchema(byte[] schemaBytes) {
        ByteBuffer schemaByteBuffer = ByteBuffer.wrap(schemaBytes);
        if (this.schemaCache.containsKey(schemaByteBuffer)) {
            return this.schemaCache.get(schemaByteBuffer);
        }
        String schema = new String(schemaBytes, StandardCharsets.UTF_8);
        Schema parsedSchema = new Schema.Parser().parse(schema);
        this.schemaCache.put(schemaByteBuffer, parsedSchema);
        return parsedSchema;
    }

    private DatumWriter<D> getDatumWriter(Schema schema) {
        DatumWriter<D> writer;
        if (this.writerCache.containsKey(schema)) {
            writer = this.writerCache.get(schema);
        } else {
            writer = new DatumWriter<D>(schema);
            this.writerCache.put(schema, writer);
        }
        return writer;
    }

    private DatumReader<D> getDatumReader(Schema schema) {
        DatumReader<D> reader;
        if (this.readerCache.containsKey(schema)) {
            reader = this.readerCache.get(schema);
        } else {
            reader = new DatumReader<D>(schema);
            this.readerCache.put(schema, reader);
        }
        return reader;
    }

    private void serializeDatum(D datum, Output output) throws IOException {
        BinaryEncoder encoder = EncoderFactory.get().directBinaryEncoder((OutputStream)output, null);
        Schema schema = datum.getSchema();
        byte[] schemaBytes = this.getSchemaBytes(schema);
        output.writeInt(schemaBytes.length);
        output.writeBytes(schemaBytes);
        this.getDatumWriter(schema).write(datum, (Encoder)encoder);
        encoder.flush();
    }

    private D deserializeDatum(Input input) throws IOException {
        int schemaBytesLen = input.readInt();
        byte[] schemaBytes = input.readBytes(schemaBytesLen);
        Schema schema = this.getSchema(schemaBytes);
        BinaryDecoder decoder = DecoderFactory.get().directBinaryDecoder((InputStream)input, null);
        return (D)((GenericContainer)this.getDatumReader(schema).read(null, (Decoder)decoder));
    }

    @Override
    public void write(Kryo kryo, Output output, D datum) {
        try {
            this.serializeDatum(datum, output);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public D read(Kryo kryo, Input input, Class<D> datumClass) {
        try {
            return this.deserializeDatum(input);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

