/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.aws.sync;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.hudi.aws.sync.HoodieGlueSyncException;
import org.apache.hudi.aws.utils.S3Utils;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.MapUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.GlueCatalogSyncClientConfig;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HiveSyncConfigHolder;
import org.apache.hudi.hive.util.HiveSchemaUtil;
import org.apache.hudi.sync.common.HoodieSyncClient;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.sync.common.model.FieldSchema;
import org.apache.hudi.sync.common.model.Partition;
import org.apache.hudi.sync.common.util.TableUtils;
import org.apache.parquet.schema.MessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.glue.GlueAsyncClient;
import software.amazon.awssdk.services.glue.model.AlreadyExistsException;
import software.amazon.awssdk.services.glue.model.BatchCreatePartitionRequest;
import software.amazon.awssdk.services.glue.model.BatchCreatePartitionResponse;
import software.amazon.awssdk.services.glue.model.BatchDeletePartitionRequest;
import software.amazon.awssdk.services.glue.model.BatchDeletePartitionResponse;
import software.amazon.awssdk.services.glue.model.BatchUpdatePartitionRequest;
import software.amazon.awssdk.services.glue.model.BatchUpdatePartitionRequestEntry;
import software.amazon.awssdk.services.glue.model.BatchUpdatePartitionResponse;
import software.amazon.awssdk.services.glue.model.Column;
import software.amazon.awssdk.services.glue.model.CreateDatabaseRequest;
import software.amazon.awssdk.services.glue.model.CreateDatabaseResponse;
import software.amazon.awssdk.services.glue.model.CreateTableRequest;
import software.amazon.awssdk.services.glue.model.CreateTableResponse;
import software.amazon.awssdk.services.glue.model.DatabaseInput;
import software.amazon.awssdk.services.glue.model.EntityNotFoundException;
import software.amazon.awssdk.services.glue.model.GetDatabaseRequest;
import software.amazon.awssdk.services.glue.model.GetDatabaseResponse;
import software.amazon.awssdk.services.glue.model.GetPartitionsRequest;
import software.amazon.awssdk.services.glue.model.GetPartitionsResponse;
import software.amazon.awssdk.services.glue.model.GetTableRequest;
import software.amazon.awssdk.services.glue.model.GetTableResponse;
import software.amazon.awssdk.services.glue.model.PartitionInput;
import software.amazon.awssdk.services.glue.model.PartitionValueList;
import software.amazon.awssdk.services.glue.model.SerDeInfo;
import software.amazon.awssdk.services.glue.model.StorageDescriptor;
import software.amazon.awssdk.services.glue.model.Table;
import software.amazon.awssdk.services.glue.model.TableInput;
import software.amazon.awssdk.services.glue.model.UpdateTableRequest;

public class AWSGlueCatalogSyncClient
extends HoodieSyncClient {
    private static final Logger LOG = LoggerFactory.getLogger(AWSGlueCatalogSyncClient.class);
    private static final int MAX_PARTITIONS_PER_REQUEST = 100;
    private final GlueAsyncClient awsGlue = (GlueAsyncClient)GlueAsyncClient.builder().build();
    private static final long BATCH_REQUEST_SLEEP_MILLIS = 1000L;
    private static final String ENABLE_MDT_LISTING = "hudi.metadata-listing-enabled";
    private final String databaseName;
    private final Boolean skipTableArchive;
    private final String enableMetadataTable;

    public AWSGlueCatalogSyncClient(HiveSyncConfig config) {
        super(config);
        this.databaseName = config.getStringOrDefault(HoodieSyncConfig.META_SYNC_DATABASE_NAME);
        this.skipTableArchive = config.getBooleanOrDefault(GlueCatalogSyncClientConfig.GLUE_SKIP_TABLE_ARCHIVE);
        this.enableMetadataTable = Boolean.toString(config.getBoolean(GlueCatalogSyncClientConfig.GLUE_METADATA_FILE_LISTING)).toUpperCase();
    }

    @Override
    public List<Partition> getAllPartitions(String tableName) {
        try {
            GetPartitionsResponse result;
            ArrayList<Partition> partitions = new ArrayList<Partition>();
            String nextToken = null;
            do {
                result = (GetPartitionsResponse)this.awsGlue.getPartitions((GetPartitionsRequest)GetPartitionsRequest.builder().databaseName(this.databaseName).tableName(tableName).nextToken(nextToken).build()).get();
                partitions.addAll(result.partitions().stream().map(p -> new Partition(p.values(), p.storageDescriptor().location())).collect(Collectors.toList()));
            } while ((nextToken = result.nextToken()) != null);
            return partitions;
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Failed to get all partitions for table " + TableUtils.tableId(this.databaseName, tableName), e);
        }
    }

    @Override
    public void addPartitionsToTable(String tableName, List<String> partitionsToAdd) {
        if (partitionsToAdd.isEmpty()) {
            LOG.info("No partitions to add for " + TableUtils.tableId(this.databaseName, tableName));
            return;
        }
        LOG.info("Adding " + partitionsToAdd.size() + " partition(s) in table " + TableUtils.tableId(this.databaseName, tableName));
        try {
            Table table = AWSGlueCatalogSyncClient.getTable(this.awsGlue, this.databaseName, tableName);
            StorageDescriptor sd = table.storageDescriptor();
            List partitionInputs = partitionsToAdd.stream().map(partition -> {
                String fullPartitionPath = FSUtils.getPartitionPath(this.getBasePath(), partition).toString();
                List<String> partitionValues = this.partitionValueExtractor.extractPartitionValuesInPath((String)partition);
                StorageDescriptor partitionSD = (StorageDescriptor)sd.copy(copySd -> copySd.location(fullPartitionPath));
                return (PartitionInput)PartitionInput.builder().values(partitionValues).storageDescriptor(partitionSD).build();
            }).collect(Collectors.toList());
            ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
            for (List batch : CollectionUtils.batches(partitionInputs, 100)) {
                BatchCreatePartitionRequest request = (BatchCreatePartitionRequest)BatchCreatePartitionRequest.builder().databaseName(this.databaseName).tableName(tableName).partitionInputList(batch).build();
                futures.add(this.awsGlue.batchCreatePartition(request));
            }
            for (CompletableFuture future : futures) {
                BatchCreatePartitionResponse response = (BatchCreatePartitionResponse)future.get();
                if (!CollectionUtils.nonEmpty(response.errors())) continue;
                if (response.errors().stream().allMatch(error -> "AlreadyExistsException".equals(error.errorDetail().errorCode()))) {
                    LOG.warn("Partitions already exist in glue: " + response.errors());
                    continue;
                }
                throw new HoodieGlueSyncException("Fail to add partitions to " + TableUtils.tableId(this.databaseName, tableName) + " with error(s): " + response.errors());
            }
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Fail to add partitions to " + TableUtils.tableId(this.databaseName, tableName), e);
        }
    }

    @Override
    public void updatePartitionsToTable(String tableName, List<String> changedPartitions) {
        if (changedPartitions.isEmpty()) {
            LOG.info("No partitions to change for " + tableName);
            return;
        }
        LOG.info("Updating " + changedPartitions.size() + "partition(s) in table " + TableUtils.tableId(this.databaseName, tableName));
        try {
            Table table = AWSGlueCatalogSyncClient.getTable(this.awsGlue, this.databaseName, tableName);
            StorageDescriptor sd = table.storageDescriptor();
            List updatePartitionEntries = changedPartitions.stream().map(partition -> {
                String fullPartitionPath = FSUtils.getPartitionPath(this.getBasePath(), partition).toString();
                List<String> partitionValues = this.partitionValueExtractor.extractPartitionValuesInPath((String)partition);
                StorageDescriptor partitionSD = (StorageDescriptor)sd.copy(copySd -> copySd.location(fullPartitionPath));
                PartitionInput partitionInput = (PartitionInput)PartitionInput.builder().values(partitionValues).storageDescriptor(partitionSD).build();
                return (BatchUpdatePartitionRequestEntry)BatchUpdatePartitionRequestEntry.builder().partitionInput(partitionInput).partitionValueList(partitionValues).build();
            }).collect(Collectors.toList());
            ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
            for (List batch : CollectionUtils.batches(updatePartitionEntries, 100)) {
                BatchUpdatePartitionRequest request = (BatchUpdatePartitionRequest)BatchUpdatePartitionRequest.builder().databaseName(this.databaseName).tableName(tableName).entries(batch).build();
                futures.add(this.awsGlue.batchUpdatePartition(request));
            }
            for (CompletableFuture future : futures) {
                BatchUpdatePartitionResponse response = (BatchUpdatePartitionResponse)future.get();
                if (!CollectionUtils.nonEmpty(response.errors())) continue;
                throw new HoodieGlueSyncException("Fail to update partitions to " + TableUtils.tableId(this.databaseName, tableName) + " with error(s): " + response.errors());
            }
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Fail to update partitions to " + TableUtils.tableId(this.databaseName, tableName), e);
        }
    }

    @Override
    public void dropPartitions(String tableName, List<String> partitionsToDrop) {
        if (CollectionUtils.isNullOrEmpty(partitionsToDrop)) {
            LOG.info("No partitions to drop for " + tableName);
            return;
        }
        LOG.info("Drop " + partitionsToDrop.size() + "partition(s) in table " + TableUtils.tableId(this.databaseName, tableName));
        try {
            ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
            for (List<String> batch : CollectionUtils.batches(partitionsToDrop, 100)) {
                List partitionValueLists = batch.stream().map(partition -> {
                    PartitionValueList partitionValueList = (PartitionValueList)PartitionValueList.builder().values(this.partitionValueExtractor.extractPartitionValuesInPath((String)partition)).build();
                    return partitionValueList;
                }).collect(Collectors.toList());
                BatchDeletePartitionRequest batchDeletePartitionRequest = (BatchDeletePartitionRequest)BatchDeletePartitionRequest.builder().databaseName(this.databaseName).tableName(tableName).partitionsToDelete(partitionValueLists).build();
                futures.add(this.awsGlue.batchDeletePartition(batchDeletePartitionRequest));
            }
            for (CompletableFuture future : futures) {
                BatchDeletePartitionResponse response = (BatchDeletePartitionResponse)future.get();
                if (!CollectionUtils.nonEmpty(response.errors())) continue;
                throw new HoodieGlueSyncException("Fail to drop partitions to " + TableUtils.tableId(this.databaseName, tableName) + " with error(s): " + response.errors());
            }
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Fail to drop partitions to " + TableUtils.tableId(this.databaseName, tableName), e);
        }
    }

    @Override
    public boolean updateTableProperties(String tableName, Map<String, String> tableProperties) {
        try {
            tableProperties.put(ENABLE_MDT_LISTING, this.enableMetadataTable);
            return AWSGlueCatalogSyncClient.updateTableParameters(this.awsGlue, this.databaseName, tableName, tableProperties, this.skipTableArchive);
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Fail to update properties for table " + TableUtils.tableId(this.databaseName, tableName), e);
        }
    }

    private void setComments(List<Column> columns, Map<String, Option<String>> commentsMap) {
        columns.forEach(column -> {
            String comment = commentsMap.getOrDefault(column.name(), Option.empty()).orElse(null);
            Column.builder().comment(comment).build();
        });
    }

    private String getTableDoc() {
        try {
            return new TableSchemaResolver(this.metaClient).getTableAvroSchema(true).getDoc();
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Failed to get schema's doc from storage : ", e);
        }
    }

    @Override
    public List<FieldSchema> getStorageFieldSchemas() {
        try {
            return new TableSchemaResolver(this.metaClient).getTableAvroSchema(true).getFields().stream().map(f -> new FieldSchema(f.name(), f.schema().getType().getName(), f.doc())).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Failed to get field schemas from storage : ", e);
        }
    }

    @Override
    public boolean updateTableComments(String tableName, List<FieldSchema> fromMetastore, List<FieldSchema> fromStorage) {
        Table table = AWSGlueCatalogSyncClient.getTable(this.awsGlue, this.databaseName, tableName);
        Map<String, Option<String>> commentsMap = fromStorage.stream().collect(Collectors.toMap(FieldSchema::getName, FieldSchema::getComment));
        StorageDescriptor storageDescriptor = table.storageDescriptor();
        List columns = storageDescriptor.columns();
        this.setComments(columns, commentsMap);
        List partitionKeys = table.partitionKeys();
        this.setComments(partitionKeys, commentsMap);
        String tableDescription = this.getTableDoc();
        if (AWSGlueCatalogSyncClient.getTable(this.awsGlue, this.databaseName, tableName).storageDescriptor().equals((Object)storageDescriptor) && AWSGlueCatalogSyncClient.getTable(this.awsGlue, this.databaseName, tableName).partitionKeys().equals(partitionKeys)) {
            return false;
        }
        Instant now = Instant.now();
        TableInput updatedTableInput = (TableInput)TableInput.builder().name(tableName).description(tableDescription).tableType(table.tableType()).parameters(table.parameters()).partitionKeys((Collection)partitionKeys).storageDescriptor(storageDescriptor).lastAccessTime(now).lastAnalyzedTime(now).build();
        UpdateTableRequest request = (UpdateTableRequest)UpdateTableRequest.builder().databaseName(this.databaseName).tableInput(updatedTableInput).build();
        this.awsGlue.updateTable(request);
        return true;
    }

    @Override
    public void updateTableSchema(String tableName, MessageType newSchema) {
        boolean cascade = this.config.getSplitStrings(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS).size() > 0;
        try {
            Table table = AWSGlueCatalogSyncClient.getTable(this.awsGlue, this.databaseName, tableName);
            LinkedHashMap<String, String> newSchemaMap = HiveSchemaUtil.parquetSchemaToMapSchema(newSchema, this.config.getBoolean(HiveSyncConfigHolder.HIVE_SUPPORT_TIMESTAMP_TYPE), false);
            List<Column> newColumns = this.getColumnsFromSchema(newSchemaMap);
            StorageDescriptor sd = table.storageDescriptor();
            StorageDescriptor partitionSD = (StorageDescriptor)sd.copy(copySd -> copySd.columns((Collection)newColumns));
            Instant now = Instant.now();
            TableInput updatedTableInput = (TableInput)TableInput.builder().name(tableName).tableType(table.tableType()).parameters(table.parameters()).partitionKeys((Collection)table.partitionKeys()).storageDescriptor(partitionSD).lastAccessTime(now).lastAnalyzedTime(now).build();
            UpdateTableRequest request = (UpdateTableRequest)UpdateTableRequest.builder().databaseName(this.databaseName).skipArchive(this.skipTableArchive).tableInput(updatedTableInput).build();
            this.awsGlue.updateTable(request);
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Fail to update definition for table " + TableUtils.tableId(this.databaseName, tableName), e);
        }
    }

    @Override
    public void createTable(String tableName, MessageType storageSchema, String inputFormatClass, String outputFormatClass, String serdeClass, Map<String, String> serdeProperties, Map<String, String> tableProperties) {
        if (this.tableExists(tableName)) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (!this.config.getBoolean(HiveSyncConfigHolder.HIVE_CREATE_MANAGED_TABLE).booleanValue()) {
            params.put("EXTERNAL", "TRUE");
        }
        params.put(ENABLE_MDT_LISTING, this.enableMetadataTable);
        params.putAll(tableProperties);
        try {
            LinkedHashMap<String, String> mapSchema = HiveSchemaUtil.parquetSchemaToMapSchema(storageSchema, this.config.getBoolean(HiveSyncConfigHolder.HIVE_SUPPORT_TIMESTAMP_TYPE), false);
            List<Column> schemaWithoutPartitionKeys = this.getColumnsFromSchema(mapSchema);
            List schemaPartitionKeys = this.config.getSplitStrings(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS).stream().map(partitionKey -> {
                String keyType = HiveSchemaUtil.getPartitionKeyType(mapSchema, partitionKey);
                return (Column)Column.builder().name(partitionKey).type(keyType.toLowerCase()).comment("").build();
            }).collect(Collectors.toList());
            serdeProperties.put("serialization.format", "1");
            StorageDescriptor storageDescriptor = (StorageDescriptor)StorageDescriptor.builder().serdeInfo((SerDeInfo)SerDeInfo.builder().serializationLibrary(serdeClass).parameters(serdeProperties).build()).location(S3Utils.s3aToS3(this.getBasePath())).inputFormat(inputFormatClass).outputFormat(outputFormatClass).columns(schemaWithoutPartitionKeys).build();
            Instant now = Instant.now();
            TableInput tableInput = (TableInput)TableInput.builder().name(tableName).tableType(TableType.EXTERNAL_TABLE.toString()).parameters(params).partitionKeys(schemaPartitionKeys).storageDescriptor(storageDescriptor).lastAccessTime(now).lastAnalyzedTime(now).build();
            CreateTableRequest request = (CreateTableRequest)CreateTableRequest.builder().databaseName(this.databaseName).tableInput(tableInput).build();
            CreateTableResponse response = (CreateTableResponse)this.awsGlue.createTable(request).get();
            LOG.info("Created table " + TableUtils.tableId(this.databaseName, tableName) + " : " + response);
        }
        catch (AlreadyExistsException e) {
            LOG.warn("Table " + TableUtils.tableId(this.databaseName, tableName) + " already exists.", (Throwable)e);
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Fail to create " + TableUtils.tableId(this.databaseName, tableName), e);
        }
    }

    @Override
    public Map<String, String> getMetastoreSchema(String tableName) {
        try {
            Table table = AWSGlueCatalogSyncClient.getTable(this.awsGlue, this.databaseName, tableName);
            Map<String, String> partitionKeysMap = table.partitionKeys().stream().collect(Collectors.toMap(Column::name, f -> f.type().toUpperCase()));
            Map<String, String> columnsMap = table.storageDescriptor().columns().stream().collect(Collectors.toMap(Column::name, f -> f.type().toUpperCase()));
            HashMap<String, String> schema = new HashMap<String, String>();
            schema.putAll(columnsMap);
            schema.putAll(partitionKeysMap);
            return schema;
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Fail to get schema for table " + TableUtils.tableId(this.databaseName, tableName), e);
        }
    }

    @Override
    public boolean tableExists(String tableName) {
        GetTableRequest request = (GetTableRequest)GetTableRequest.builder().databaseName(this.databaseName).name(tableName).build();
        try {
            return Objects.nonNull(((GetTableResponse)this.awsGlue.getTable(request).get()).table());
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof EntityNotFoundException) {
                LOG.info("Table not found: " + TableUtils.tableId(this.databaseName, tableName), (Throwable)e);
                return false;
            }
            throw new HoodieGlueSyncException("Fail to get table: " + TableUtils.tableId(this.databaseName, tableName), e);
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Fail to get table: " + TableUtils.tableId(this.databaseName, tableName), e);
        }
    }

    @Override
    public boolean databaseExists(String databaseName) {
        GetDatabaseRequest request = (GetDatabaseRequest)GetDatabaseRequest.builder().name(databaseName).build();
        try {
            return Objects.nonNull(((GetDatabaseResponse)this.awsGlue.getDatabase(request).get()).database());
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof EntityNotFoundException) {
                LOG.info("Database not found: " + databaseName, (Throwable)e);
                return false;
            }
            throw new HoodieGlueSyncException("Fail to check if database exists " + databaseName, e);
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Fail to check if database exists " + databaseName, e);
        }
    }

    @Override
    public void createDatabase(String databaseName) {
        if (this.databaseExists(databaseName)) {
            return;
        }
        CreateDatabaseRequest request = (CreateDatabaseRequest)CreateDatabaseRequest.builder().databaseInput((DatabaseInput)DatabaseInput.builder().name(databaseName).description("Automatically created by " + this.getClass().getName()).parameters(null).locationUri(null).build()).build();
        try {
            CreateDatabaseResponse result = (CreateDatabaseResponse)this.awsGlue.createDatabase(request).get();
            LOG.info("Successfully created database in AWS Glue: " + result.toString());
        }
        catch (AlreadyExistsException e) {
            LOG.warn("AWS Glue Database " + databaseName + " already exists", (Throwable)e);
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Fail to create database " + databaseName, e);
        }
    }

    @Override
    public Option<String> getLastCommitTimeSynced(String tableName) {
        try {
            Table table = AWSGlueCatalogSyncClient.getTable(this.awsGlue, this.databaseName, tableName);
            return Option.ofNullable(table.parameters().get("last_commit_time_sync"));
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Fail to get last sync commit time for " + TableUtils.tableId(this.databaseName, tableName), e);
        }
    }

    @Override
    public void close() {
        this.awsGlue.close();
    }

    @Override
    public void updateLastCommitTimeSynced(String tableName) {
        if (!this.getActiveTimeline().lastInstant().isPresent()) {
            LOG.warn("No commit in active timeline.");
            return;
        }
        String lastCommitTimestamp = this.getActiveTimeline().lastInstant().get().getTimestamp();
        try {
            AWSGlueCatalogSyncClient.updateTableParameters(this.awsGlue, this.databaseName, tableName, Collections.singletonMap("last_commit_time_sync", lastCommitTimestamp), this.skipTableArchive);
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Fail to update last sync commit time for " + TableUtils.tableId(this.databaseName, tableName), e);
        }
    }

    @Override
    public Option<String> getLastReplicatedTime(String tableName) {
        throw new UnsupportedOperationException("Not supported: `getLastReplicatedTime`");
    }

    @Override
    public void updateLastReplicatedTimeStamp(String tableName, String timeStamp) {
        throw new UnsupportedOperationException("Not supported: `updateLastReplicatedTimeStamp`");
    }

    @Override
    public void deleteLastReplicatedTimeStamp(String tableName) {
        throw new UnsupportedOperationException("Not supported: `deleteLastReplicatedTimeStamp`");
    }

    private List<Column> getColumnsFromSchema(Map<String, String> mapSchema) {
        ArrayList<Column> cols = new ArrayList<Column>();
        for (String key : mapSchema.keySet()) {
            if (this.config.getSplitStrings(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS).contains(key)) continue;
            String keyType = HiveSchemaUtil.getPartitionKeyType(mapSchema, key);
            Column column = (Column)Column.builder().name(key).type(keyType.toLowerCase()).comment("").build();
            cols.add(column);
        }
        return cols;
    }

    private static Table getTable(GlueAsyncClient awsGlue, String databaseName, String tableName) throws HoodieGlueSyncException {
        GetTableRequest request = (GetTableRequest)GetTableRequest.builder().databaseName(databaseName).name(tableName).build();
        try {
            return ((GetTableResponse)awsGlue.getTable(request).get()).table();
        }
        catch (EntityNotFoundException e) {
            throw new HoodieGlueSyncException("Table not found: " + TableUtils.tableId(databaseName, tableName), e);
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Fail to get table " + TableUtils.tableId(databaseName, tableName), e);
        }
    }

    private static boolean updateTableParameters(GlueAsyncClient awsGlue, String databaseName, String tableName, Map<String, String> updatingParams, boolean skipTableArchive) {
        if (MapUtils.isNullOrEmpty(updatingParams)) {
            return false;
        }
        try {
            Table table = AWSGlueCatalogSyncClient.getTable(awsGlue, databaseName, tableName);
            Map remoteParams = table.parameters();
            if (MapUtils.containsAll(remoteParams, updatingParams)) {
                return false;
            }
            HashMap<String, String> newParams = new HashMap<String, String>();
            newParams.putAll(table.parameters());
            newParams.putAll(updatingParams);
            Instant now = Instant.now();
            TableInput updatedTableInput = (TableInput)TableInput.builder().name(tableName).tableType(table.tableType()).parameters(newParams).partitionKeys((Collection)table.partitionKeys()).storageDescriptor(table.storageDescriptor()).lastAccessTime(now).lastAnalyzedTime(now).build();
            UpdateTableRequest request = (UpdateTableRequest)UpdateTableRequest.builder().databaseName(databaseName).tableInput(updatedTableInput).skipArchive(Boolean.valueOf(skipTableArchive)).build();
            awsGlue.updateTable(request);
            return true;
        }
        catch (Exception e) {
            throw new HoodieGlueSyncException("Fail to update params for table " + TableUtils.tableId(databaseName, tableName) + ": " + updatingParams, e);
        }
    }

    private static enum TableType {
        MANAGED_TABLE,
        EXTERNAL_TABLE,
        VIRTUAL_VIEW,
        INDEX_TABLE,
        MATERIALIZED_VIEW;

    }
}

