/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.aws.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.ResourceInUseException;
import software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.TableDescription;
import software.amazon.awssdk.services.dynamodb.model.TableStatus;

public class DynamoTableUtils {
    private static final int DEFAULT_WAIT_TIMEOUT = 1200000;
    private static final int DEFAULT_WAIT_INTERVAL = 10000;
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamoTableUtils.class);

    public static void waitUntilExists(DynamoDbClient dynamo, String tableName) throws InterruptedException {
        DynamoTableUtils.waitUntilExists(dynamo, tableName, 1200000, 10000);
    }

    public static void waitUntilExists(DynamoDbClient dynamo, String tableName, int timeout, int interval) throws InterruptedException {
        TableDescription table = DynamoTableUtils.waitForTableDescription(dynamo, tableName, null, timeout, interval);
        if (table == null) {
            throw SdkClientException.builder().message("Table " + tableName + " never returned a result").build();
        }
    }

    public static void waitUntilActive(DynamoDbClient dynamo, String tableName) throws InterruptedException, TableNeverTransitionedToStateException {
        DynamoTableUtils.waitUntilActive(dynamo, tableName, 1200000, 10000);
    }

    public static void waitUntilActive(DynamoDbClient dynamo, String tableName, int timeout, int interval) throws InterruptedException, TableNeverTransitionedToStateException {
        TableDescription table = DynamoTableUtils.waitForTableDescription(dynamo, tableName, TableStatus.ACTIVE, timeout, interval);
        if (table == null || !table.tableStatus().equals((Object)TableStatus.ACTIVE)) {
            throw new TableNeverTransitionedToStateException(tableName, TableStatus.ACTIVE);
        }
    }

    private static TableDescription waitForTableDescription(DynamoDbClient dynamo, String tableName, TableStatus desiredStatus, int timeout, int interval) throws InterruptedException, IllegalArgumentException {
        if (timeout < 0) {
            throw new IllegalArgumentException("Timeout must be >= 0");
        }
        if (interval <= 0 || interval >= timeout) {
            throw new IllegalArgumentException("Interval must be > 0 and < timeout");
        }
        long startTime = System.currentTimeMillis();
        long endTime = startTime + (long)timeout;
        TableDescription table = null;
        while (System.currentTimeMillis() < endTime) {
            try {
                table = dynamo.describeTable((DescribeTableRequest)DescribeTableRequest.builder().tableName(tableName).build()).table();
                if (desiredStatus == null || table.tableStatus().equals((Object)desiredStatus)) {
                    return table;
                }
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                // empty catch block
            }
            Thread.sleep(interval);
        }
        return table;
    }

    public static boolean createTableIfNotExists(DynamoDbClient dynamo, CreateTableRequest createTableRequest) {
        try {
            dynamo.createTable(createTableRequest);
            return true;
        }
        catch (ResourceInUseException e) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Table " + createTableRequest.tableName() + " already exists", (Throwable)e);
            }
            return false;
        }
    }

    public static boolean deleteTableIfExists(DynamoDbClient dynamo, DeleteTableRequest deleteTableRequest) {
        try {
            dynamo.deleteTable(deleteTableRequest);
            return true;
        }
        catch (ResourceNotFoundException e) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Table " + deleteTableRequest.tableName() + " does not exist", (Throwable)e);
            }
            return false;
        }
    }

    public static class TableNeverTransitionedToStateException
    extends SdkClientException {
        private static final long serialVersionUID = 8920567021104846647L;

        public TableNeverTransitionedToStateException(String tableName, TableStatus desiredStatus) {
            super(SdkClientException.builder().message("Table " + tableName + " never transitioned to desired state of " + desiredStatus.toString()));
        }
    }
}

