/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import com.codahale.metrics.Timer;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.async.AsyncArchiveService;
import org.apache.hudi.async.AsyncCleanerService;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieRollbackPlan;
import org.apache.hudi.client.BaseHoodieClient;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.client.HoodieTableServiceManagerClient;
import org.apache.hudi.client.HoodieTimelineArchiver;
import org.apache.hudi.client.RunsTableService;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.embedded.EmbeddedTimelineService;
import org.apache.hudi.client.heartbeat.HeartbeatUtils;
import org.apache.hudi.common.HoodiePendingRollbackInfo;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.ActionType;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.TableServiceType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.CleanerUtils;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieClusteringException;
import org.apache.hudi.exception.HoodieCompactionException;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieLogCompactException;
import org.apache.hudi.exception.HoodieRollbackException;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.compact.CompactHelpers;
import org.apache.hudi.table.action.rollback.RollbackUtils;
import org.apache.hudi.table.marker.WriteMarkersFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHoodieTableServiceClient<I, T, O>
extends BaseHoodieClient
implements RunsTableService {
    private static final Logger LOG = LoggerFactory.getLogger(BaseHoodieWriteClient.class);
    protected transient Timer.Context compactionTimer;
    protected transient Timer.Context clusteringTimer;
    protected transient Timer.Context logCompactionTimer;
    protected transient AsyncCleanerService asyncCleanerService;
    protected transient AsyncArchiveService asyncArchiveService;
    protected Set<String> pendingInflightAndRequestedInstants;

    protected BaseHoodieTableServiceClient(HoodieEngineContext context, HoodieWriteConfig clientConfig, Option<EmbeddedTimelineService> timelineService) {
        super(context, clientConfig, timelineService);
    }

    protected void startAsyncCleanerService(BaseHoodieWriteClient writeClient) {
        if (this.asyncCleanerService == null) {
            this.asyncCleanerService = AsyncCleanerService.startAsyncCleaningIfEnabled(writeClient);
        } else {
            this.asyncCleanerService.start(null);
        }
    }

    protected void startAsyncArchiveService(BaseHoodieWriteClient writeClient) {
        if (this.asyncArchiveService == null) {
            this.asyncArchiveService = AsyncArchiveService.startAsyncArchiveIfEnabled(writeClient);
        } else {
            this.asyncArchiveService.start(null);
        }
    }

    protected void asyncClean() {
        AsyncCleanerService.waitForCompletion(this.asyncCleanerService);
    }

    protected void asyncArchive() {
        AsyncArchiveService.waitForCompletion(this.asyncArchiveService);
    }

    protected void setTableServiceTimer(WriteOperationType operationType) {
        switch (operationType) {
            case CLUSTER: {
                this.clusteringTimer = this.metrics.getClusteringCtx();
                break;
            }
            case COMPACT: {
                this.compactionTimer = this.metrics.getCompactionCtx();
                break;
            }
            case LOG_COMPACT: {
                this.logCompactionTimer = this.metrics.getLogCompactionCtx();
                break;
            }
        }
    }

    protected void setPendingInflightAndRequestedInstants(Set<String> pendingInflightAndRequestedInstants) {
        this.pendingInflightAndRequestedInstants = pendingInflightAndRequestedInstants;
    }

    protected void preCommit(HoodieCommitMetadata metadata) {
        HoodieTable<?, I, ?, T> table = this.createTable(this.config, this.hadoopConf);
        this.resolveWriteConflict(table, metadata, this.pendingInflightAndRequestedInstants);
    }

    protected Option<String> inlineCompaction(Option<Map<String, String>> extraMetadata) {
        Option<String> compactionInstantTimeOpt = this.inlineScheduleCompaction(extraMetadata);
        compactionInstantTimeOpt.ifPresent(compactInstantTime -> this.compact((String)compactInstantTime, true));
        return compactionInstantTimeOpt;
    }

    private void inlineCompaction(HoodieTable table, Option<Map<String, String>> extraMetadata) {
        if (this.shouldDelegateToTableServiceManager(this.config, ActionType.compaction)) {
            this.scheduleCompaction(extraMetadata);
        } else {
            this.runAnyPendingCompactions(table);
            this.inlineCompaction(extraMetadata);
        }
    }

    protected HoodieWriteMetadata<O> logCompact(String logCompactionInstantTime, boolean shouldComplete) {
        HoodieInstant inflightInstant;
        HoodieTable<?, I, ?, T> table = this.createTable(this.config, this.context.getHadoopConf().get());
        Set<String> actions = CollectionUtils.createSet("commit", "compaction");
        Option<HoodieInstant> compactionInstantWithGreaterTimestamp = Option.fromJavaOptional(table.getActiveTimeline().getInstantsAsStream().filter(hoodieInstant -> actions.contains(hoodieInstant.getAction())).filter(hoodieInstant -> HoodieTimeline.compareTimestamps(hoodieInstant.getTimestamp(), HoodieTimeline.GREATER_THAN, logCompactionInstantTime)).findFirst());
        if (compactionInstantWithGreaterTimestamp.isPresent()) {
            throw new HoodieLogCompactException(String.format("Cannot log compact since a compaction instant with greater timestamp exists. Instant details %s", compactionInstantWithGreaterTimestamp.get()));
        }
        HoodieTimeline pendingLogCompactionTimeline = table.getActiveTimeline().filterPendingLogCompactionTimeline();
        if (pendingLogCompactionTimeline.containsInstant(inflightInstant = HoodieTimeline.getLogCompactionInflightInstant(logCompactionInstantTime))) {
            LOG.info("Found Log compaction inflight file. Rolling back the commit and exiting.");
            table.rollbackInflightLogCompaction(inflightInstant, commitToRollback -> this.getPendingRollbackInfo(table.getMetaClient(), (String)commitToRollback, false));
            table.getMetaClient().reloadActiveTimeline();
            throw new HoodieException("Execution is aborted since it found an Inflight logcompaction,log compaction plans are mutable plans, so reschedule another logcompaction.");
        }
        this.logCompactionTimer = this.metrics.getLogCompactionCtx();
        WriteMarkersFactory.get(this.config.getMarkersType(), table, logCompactionInstantTime);
        HoodieWriteMetadata<T> writeMetadata = table.logCompact(this.context, logCompactionInstantTime);
        HoodieWriteMetadata<O> logCompactionMetadata = this.convertToOutputMetadata(writeMetadata);
        if (shouldComplete && logCompactionMetadata.getCommitMetadata().isPresent()) {
            this.completeLogCompaction(logCompactionMetadata.getCommitMetadata().get(), table, logCompactionInstantTime);
        }
        return logCompactionMetadata;
    }

    protected Option<String> inlineLogCompact(Option<Map<String, String>> extraMetadata) {
        Option<String> logCompactionInstantTimeOpt = this.scheduleLogCompaction(extraMetadata);
        logCompactionInstantTimeOpt.ifPresent(logCompactInstantTime -> this.logCompact((String)logCompactInstantTime, true));
        return logCompactionInstantTimeOpt;
    }

    protected void runAnyPendingCompactions(HoodieTable table) {
        table.getActiveTimeline().getWriteTimeline().filterPendingCompactionTimeline().getInstants().forEach(instant -> {
            LOG.info("Running previously failed inflight compaction at instant " + instant);
            this.compact(instant.getTimestamp(), true);
        });
    }

    protected void runAnyPendingLogCompactions(HoodieTable table) {
        table.getActiveTimeline().getWriteTimeline().filterPendingLogCompactionTimeline().getInstantsAsStream().forEach(instant -> {
            LOG.info("Running previously failed inflight log compaction at instant " + instant);
            this.logCompact(instant.getTimestamp(), true);
        });
    }

    protected Option<String> inlineScheduleCompaction(Option<Map<String, String>> extraMetadata) {
        return this.scheduleCompaction(extraMetadata);
    }

    public Option<String> scheduleCompaction(Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        String instantTime = HoodieActiveTimeline.createNewInstantTime();
        return this.scheduleCompactionAtInstant(instantTime, extraMetadata) ? Option.of(instantTime) : Option.empty();
    }

    protected HoodieWriteMetadata<O> compact(String compactionInstantTime, boolean shouldComplete) {
        HoodieInstant inflightInstant;
        HoodieTable<?, I, ?, T> table = this.createTable(this.config, this.context.getHadoopConf().get());
        HoodieTimeline pendingCompactionTimeline = table.getActiveTimeline().filterPendingCompactionTimeline();
        if (pendingCompactionTimeline.containsInstant(inflightInstant = HoodieTimeline.getCompactionInflightInstant(compactionInstantTime))) {
            table.rollbackInflightCompaction(inflightInstant, commitToRollback -> this.getPendingRollbackInfo(table.getMetaClient(), (String)commitToRollback, false));
            table.getMetaClient().reloadActiveTimeline();
        }
        this.compactionTimer = this.metrics.getCompactionCtx();
        HoodieWriteMetadata<T> writeMetadata = table.compact(this.context, compactionInstantTime);
        HoodieWriteMetadata<O> compactionMetadata = this.convertToOutputMetadata(writeMetadata);
        if (shouldComplete && compactionMetadata.getCommitMetadata().isPresent()) {
            this.completeCompaction(compactionMetadata.getCommitMetadata().get(), table, compactionInstantTime);
        }
        return compactionMetadata;
    }

    public void commitCompaction(String compactionInstantTime, HoodieCommitMetadata metadata, Option<Map<String, String>> extraMetadata) {
        extraMetadata.ifPresent(m -> m.forEach(metadata::addMetadata));
        this.completeCompaction(metadata, this.createTable(this.config, this.context.getHadoopConf().get()), compactionInstantTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeCompaction(HoodieCommitMetadata metadata, HoodieTable table, String compactionCommitTime) {
        this.context.setJobStatus(this.getClass().getSimpleName(), "Collect compaction write status and commit compaction: " + this.config.getTableName());
        List<HoodieWriteStat> writeStats = metadata.getWriteStats();
        this.handleWriteErrors(writeStats, TableServiceType.COMPACT);
        HoodieInstant compactionInstant = HoodieTimeline.getCompactionInflightInstant(compactionCommitTime);
        try {
            this.txnManager.beginTransaction(Option.of(compactionInstant), Option.empty());
            this.finalizeWrite(table, compactionCommitTime, writeStats);
            this.writeTableMetadata(table, compactionCommitTime, metadata, this.context.emptyHoodieData());
            LOG.info("Committing Compaction " + compactionCommitTime + ". Finished with result " + metadata);
            CompactHelpers.getInstance().completeInflightCompaction(table, compactionCommitTime, metadata);
        }
        finally {
            this.txnManager.endTransaction(Option.of(compactionInstant));
        }
        WriteMarkersFactory.get(this.config.getMarkersType(), table, compactionCommitTime).quietDeleteMarkerDir(this.context, this.config.getMarkersDeleteParallelism());
        if (this.compactionTimer != null) {
            long durationInMs = this.metrics.getDurationInMs(this.compactionTimer.stop());
            HoodieActiveTimeline.parseDateFromInstantTimeSafely(compactionCommitTime).ifPresent(parsedInstant -> this.metrics.updateCommitMetrics(parsedInstant.getTime(), durationInMs, metadata, "compaction"));
        }
        LOG.info("Compacted successfully on commit " + compactionCommitTime);
    }

    public Option<String> scheduleLogCompaction(Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        String instantTime = HoodieActiveTimeline.createNewInstantTime();
        return this.scheduleLogCompactionAtInstant(instantTime, extraMetadata) ? Option.of(instantTime) : Option.empty();
    }

    public boolean scheduleLogCompactionAtInstant(String instantTime, Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        return this.scheduleTableService(instantTime, extraMetadata, TableServiceType.LOG_COMPACT).isPresent();
    }

    public HoodieWriteMetadata<O> logCompact(String logCompactionInstantTime) {
        return this.logCompact(logCompactionInstantTime, this.config.shouldAutoCommit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeLogCompaction(HoodieCommitMetadata metadata, HoodieTable table, String logCompactionCommitTime) {
        this.context.setJobStatus(this.getClass().getSimpleName(), "Collect log compaction write status and commit compaction");
        List<HoodieWriteStat> writeStats = metadata.getWriteStats();
        this.handleWriteErrors(writeStats, TableServiceType.LOG_COMPACT);
        HoodieInstant logCompactionInstant = new HoodieInstant(HoodieInstant.State.INFLIGHT, "logcompaction", logCompactionCommitTime);
        try {
            this.txnManager.beginTransaction(Option.of(logCompactionInstant), Option.empty());
            this.preCommit(metadata);
            this.finalizeWrite(table, logCompactionCommitTime, writeStats);
            this.writeTableMetadata(table, logCompactionCommitTime, metadata, this.context.emptyHoodieData());
            LOG.info("Committing Log Compaction " + logCompactionCommitTime + ". Finished with result " + metadata);
            CompactHelpers.getInstance().completeInflightLogCompaction(table, logCompactionCommitTime, metadata);
        }
        finally {
            this.txnManager.endTransaction(Option.of(logCompactionInstant));
        }
        WriteMarkersFactory.get(this.config.getMarkersType(), table, logCompactionCommitTime).quietDeleteMarkerDir(this.context, this.config.getMarkersDeleteParallelism());
        if (this.logCompactionTimer != null) {
            long durationInMs = this.metrics.getDurationInMs(this.logCompactionTimer.stop());
            HoodieActiveTimeline.parseDateFromInstantTimeSafely(logCompactionCommitTime).ifPresent(parsedInstant -> this.metrics.updateCommitMetrics(parsedInstant.getTime(), durationInMs, metadata, "logcompaction"));
        }
        LOG.info("Log Compacted successfully on commit " + logCompactionCommitTime);
    }

    public boolean scheduleCompactionAtInstant(String instantTime, Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        return this.scheduleTableService(instantTime, extraMetadata, TableServiceType.COMPACT).isPresent();
    }

    public Option<String> scheduleClustering(Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        String instantTime = HoodieActiveTimeline.createNewInstantTime();
        return this.scheduleClusteringAtInstant(instantTime, extraMetadata) ? Option.of(instantTime) : Option.empty();
    }

    public boolean scheduleClusteringAtInstant(String instantTime, Option<Map<String, String>> extraMetadata) throws HoodieIOException {
        return this.scheduleTableService(instantTime, extraMetadata, TableServiceType.CLUSTER).isPresent();
    }

    public HoodieWriteMetadata<O> cluster(String clusteringInstant, boolean shouldComplete) {
        HoodieInstant inflightInstant;
        HoodieTable<?, I, ?, T> table = this.createTable(this.config, this.context.getHadoopConf().get());
        HoodieTimeline pendingClusteringTimeline = table.getActiveTimeline().filterPendingReplaceTimeline();
        if (pendingClusteringTimeline.containsInstant(inflightInstant = HoodieTimeline.getReplaceCommitInflightInstant(clusteringInstant))) {
            table.rollbackInflightClustering(inflightInstant, commitToRollback -> this.getPendingRollbackInfo(table.getMetaClient(), (String)commitToRollback, false));
            table.getMetaClient().reloadActiveTimeline();
        }
        this.clusteringTimer = this.metrics.getClusteringCtx();
        LOG.info("Starting clustering at " + clusteringInstant);
        HoodieWriteMetadata<T> writeMetadata = table.cluster(this.context, clusteringInstant);
        HoodieWriteMetadata<O> clusteringMetadata = this.convertToOutputMetadata(writeMetadata);
        this.validateClusteringCommit(clusteringMetadata, clusteringInstant, table);
        if (this.config.isMetricsOn()) {
            clusteringMetadata.getWriteStats().ifPresent(hoodieWriteStats -> hoodieWriteStats.stream().filter(hoodieWriteStat -> hoodieWriteStat.getRuntimeStats() != null).map(hoodieWriteStat -> hoodieWriteStat.getRuntimeStats().getTotalCreateTime()).forEach(this.metrics::updateClusteringFileCreationMetrics));
        }
        if (shouldComplete && clusteringMetadata.getCommitMetadata().isPresent()) {
            this.completeClustering((HoodieReplaceCommitMetadata)clusteringMetadata.getCommitMetadata().get(), table, clusteringInstant, Option.ofNullable(this.convertToWriteStatus(writeMetadata)));
        }
        return clusteringMetadata;
    }

    protected abstract void validateClusteringCommit(HoodieWriteMetadata<O> var1, String var2, HoodieTable var3);

    protected abstract HoodieWriteMetadata<O> convertToOutputMetadata(HoodieWriteMetadata<T> var1);

    protected abstract HoodieData<WriteStatus> convertToWriteStatus(HoodieWriteMetadata<T> var1);

    private void completeClustering(HoodieReplaceCommitMetadata metadata, HoodieTable table, String clusteringCommitTime, Option<HoodieData<WriteStatus>> writeStatuses) {
        List<HoodieWriteStat> writeStats = metadata.getWriteStats();
        this.handleWriteErrors(writeStats, TableServiceType.CLUSTER);
        HoodieInstant clusteringInstant = HoodieTimeline.getReplaceCommitInflightInstant(clusteringCommitTime);
        try {
            this.txnManager.beginTransaction(Option.of(clusteringInstant), Option.empty());
            this.finalizeWrite(table, clusteringCommitTime, writeStats);
            if (this.isPreCommitRequired()) {
                this.preCommit(metadata);
            }
            this.writeTableMetadata(table, clusteringInstant.getTimestamp(), metadata, writeStatuses.orElse(this.context.emptyHoodieData()));
            LOG.info("Committing Clustering " + clusteringCommitTime + ". Finished with result " + metadata);
            table.getActiveTimeline().transitionReplaceInflightToComplete(clusteringInstant, Option.of(metadata.toJsonString().getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            throw new HoodieClusteringException("unable to transition clustering inflight to complete: " + clusteringCommitTime, e);
        }
        finally {
            this.txnManager.endTransaction(Option.of(clusteringInstant));
        }
        WriteMarkersFactory.get(this.config.getMarkersType(), table, clusteringCommitTime).quietDeleteMarkerDir(this.context, this.config.getMarkersDeleteParallelism());
        if (this.clusteringTimer != null) {
            long durationInMs = this.metrics.getDurationInMs(this.clusteringTimer.stop());
            HoodieActiveTimeline.parseDateFromInstantTimeSafely(clusteringCommitTime).ifPresent(parsedInstant -> this.metrics.updateCommitMetrics(parsedInstant.getTime(), durationInMs, metadata, "replacecommit"));
        }
        LOG.info("Clustering successfully on commit " + clusteringCommitTime);
    }

    protected void runTableServicesInline(HoodieTable table, HoodieCommitMetadata metadata, Option<Map<String, String>> extraMetadata) {
        if (!this.tableServicesEnabled(this.config)) {
            return;
        }
        if (!this.config.areAnyTableServicesExecutedInline().booleanValue() && !this.config.areAnyTableServicesScheduledInline().booleanValue()) {
            return;
        }
        if (this.config.isMetadataTableEnabled()) {
            table.getHoodieView().sync();
        }
        if (this.config.inlineCompactionEnabled()) {
            metadata.addMetadata(HoodieCompactionConfig.INLINE_COMPACT.key(), "true");
            this.inlineCompaction(table, extraMetadata);
        } else {
            metadata.addMetadata(HoodieCompactionConfig.INLINE_COMPACT.key(), "false");
        }
        if (!this.config.inlineCompactionEnabled() && this.config.scheduleInlineCompaction() && table.getActiveTimeline().getWriteTimeline().filterPendingCompactionTimeline().empty()) {
            metadata.addMetadata(HoodieCompactionConfig.SCHEDULE_INLINE_COMPACT.key(), "true");
            this.inlineScheduleCompaction(extraMetadata);
        }
        if (this.config.inlineLogCompactionEnabled()) {
            this.runAnyPendingLogCompactions(table);
            metadata.addMetadata(HoodieCompactionConfig.INLINE_LOG_COMPACT.key(), "true");
            this.inlineLogCompact(extraMetadata);
        } else {
            metadata.addMetadata(HoodieCompactionConfig.INLINE_LOG_COMPACT.key(), "false");
        }
        if (this.config.inlineClusteringEnabled()) {
            metadata.addMetadata(HoodieClusteringConfig.INLINE_CLUSTERING.key(), "true");
            this.inlineClustering(table, extraMetadata);
        } else {
            metadata.addMetadata(HoodieClusteringConfig.INLINE_CLUSTERING.key(), "false");
        }
        if (!this.config.inlineClusteringEnabled() && this.config.scheduleInlineClustering() && table.getActiveTimeline().filterPendingReplaceTimeline().empty()) {
            metadata.addMetadata(HoodieClusteringConfig.SCHEDULE_INLINE_CLUSTERING.key(), "true");
            this.inlineScheduleClustering(extraMetadata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Option<String> scheduleTableService(String instantTime, Option<Map<String, String>> extraMetadata, TableServiceType tableServiceType) {
        Option<HoodieInstant> inflightInstant = Option.of(new HoodieInstant(HoodieInstant.State.REQUESTED, tableServiceType.getAction(), instantTime));
        try {
            this.txnManager.beginTransaction(inflightInstant, Option.empty());
            LOG.info("Scheduling table service " + (Object)((Object)tableServiceType));
            Option<String> option = this.scheduleTableServiceInternal(instantTime, extraMetadata, tableServiceType);
            return option;
        }
        finally {
            this.txnManager.endTransaction(inflightInstant);
        }
    }

    protected Option<String> scheduleTableServiceInternal(String instantTime, Option<Map<String, String>> extraMetadata, TableServiceType tableServiceType) {
        if (!this.tableServicesEnabled(this.config)) {
            return Option.empty();
        }
        Option<String> option = Option.empty();
        HoodieTable<?, I, ?, T> table = this.createTable(this.config, this.hadoopConf);
        switch (tableServiceType) {
            case ARCHIVE: {
                LOG.info("Scheduling archiving is not supported. Skipping.");
                break;
            }
            case CLUSTER: {
                LOG.info("Scheduling clustering at instant time :" + instantTime);
                Option<HoodieClusteringPlan> clusteringPlan = table.scheduleClustering(this.context, instantTime, extraMetadata);
                option = clusteringPlan.isPresent() ? Option.of(instantTime) : Option.empty();
                break;
            }
            case COMPACT: {
                LOG.info("Scheduling compaction at instant time :" + instantTime);
                Option<HoodieCompactionPlan> compactionPlan = table.scheduleCompaction(this.context, instantTime, extraMetadata);
                option = compactionPlan.isPresent() ? Option.of(instantTime) : Option.empty();
                break;
            }
            case LOG_COMPACT: {
                LOG.info("Scheduling log compaction at instant time :" + instantTime);
                Option<HoodieCompactionPlan> logCompactionPlan = table.scheduleLogCompaction(this.context, instantTime, extraMetadata);
                option = logCompactionPlan.isPresent() ? Option.of(instantTime) : Option.empty();
                break;
            }
            case CLEAN: {
                LOG.info("Scheduling cleaning at instant time :" + instantTime);
                Option<HoodieCleanerPlan> cleanerPlan = table.scheduleCleaning(this.context, instantTime, extraMetadata);
                option = cleanerPlan.isPresent() ? Option.of(instantTime) : Option.empty();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid TableService " + (Object)((Object)tableServiceType));
            }
        }
        Option<String> instantRange = this.delegateToTableServiceManager(tableServiceType, table);
        if (instantRange.isPresent()) {
            LOG.info("Delegate instant [" + instantRange.get() + "] to table service manager");
        }
        return option;
    }

    protected abstract HoodieTable<?, I, ?, T> createTable(HoodieWriteConfig var1, Configuration var2);

    protected Option<String> inlineClustering(Option<Map<String, String>> extraMetadata) {
        Option<String> clusteringInstantOpt = this.inlineScheduleClustering(extraMetadata);
        clusteringInstantOpt.ifPresent(clusteringInstant -> this.cluster((String)clusteringInstant, true));
        return clusteringInstantOpt;
    }

    private void inlineClustering(HoodieTable table, Option<Map<String, String>> extraMetadata) {
        if (this.shouldDelegateToTableServiceManager(this.config, ActionType.replacecommit)) {
            this.scheduleClustering(extraMetadata);
        } else {
            this.runAnyPendingClustering(table);
            this.inlineClustering(extraMetadata);
        }
    }

    protected Option<String> inlineScheduleClustering(Option<Map<String, String>> extraMetadata) {
        return this.scheduleClustering(extraMetadata);
    }

    protected void runAnyPendingClustering(HoodieTable table) {
        table.getActiveTimeline().filterPendingReplaceTimeline().getInstants().forEach(instant -> {
            Option<Pair<HoodieInstant, HoodieClusteringPlan>> instantPlan = ClusteringUtils.getClusteringPlan(table.getMetaClient(), instant);
            if (instantPlan.isPresent()) {
                LOG.info("Running pending clustering at instant " + instantPlan.get().getLeft());
                this.cluster(instant.getTimestamp(), true);
            }
        });
    }

    protected void writeTableMetadata(HoodieTable table, String instantTime, HoodieCommitMetadata metadata, HoodieData<WriteStatus> writeStatuses) {
        this.context.setJobStatus(this.getClass().getSimpleName(), "Committing to metadata table: " + this.config.getTableName());
        Option<HoodieTableMetadataWriter> metadataWriterOpt = table.getMetadataWriter(instantTime);
        if (metadataWriterOpt.isPresent()) {
            try (HoodieTableMetadataWriter metadataWriter = metadataWriterOpt.get();){
                metadataWriter.update(metadata, writeStatuses, instantTime);
            }
            catch (Exception e) {
                if (e instanceof HoodieException) {
                    throw (HoodieException)e;
                }
                throw new HoodieException("Failed to update metadata", e);
            }
        }
    }

    @Nullable
    @Deprecated
    public HoodieCleanMetadata clean(String cleanInstantTime, boolean scheduleInline, boolean skipLocking) throws HoodieIOException {
        return this.clean(cleanInstantTime, scheduleInline);
    }

    @Nullable
    public HoodieCleanMetadata clean(String cleanInstantTime, boolean scheduleInline) throws HoodieIOException {
        if (!this.tableServicesEnabled(this.config)) {
            return null;
        }
        Timer.Context timerContext = this.metrics.getCleanCtx();
        CleanerUtils.rollbackFailedWrites(this.config.getFailedWritesCleanPolicy(), "clean", () -> this.rollbackFailedWrites());
        HoodieTable<?, I, ?, T> table = this.createTable(this.config, this.hadoopConf);
        if (this.config.allowMultipleCleans() || !table.getActiveTimeline().getCleanerTimeline().filterInflightsAndRequested().firstInstant().isPresent()) {
            LOG.info("Cleaner started");
            if (scheduleInline) {
                this.scheduleTableServiceInternal(cleanInstantTime, Option.empty(), TableServiceType.CLEAN);
                table.getMetaClient().reloadActiveTimeline();
            }
            if (this.shouldDelegateToTableServiceManager(this.config, ActionType.clean)) {
                LOG.warn("Cleaning is not yet supported with Table Service Manager.");
                return null;
            }
        }
        HoodieCleanMetadata metadata = table.clean(this.context, cleanInstantTime);
        if (timerContext != null && metadata != null) {
            long durationMs = this.metrics.getDurationInMs(timerContext.stop());
            this.metrics.updateCleanMetrics(durationMs, metadata.getTotalFilesDeleted());
            LOG.info("Cleaned " + metadata.getTotalFilesDeleted() + " files Earliest Retained Instant :" + metadata.getEarliestCommitToRetain() + " cleanerElapsedMs" + durationMs);
        }
        return metadata;
    }

    protected void archive(HoodieTable table) {
        if (!this.tableServicesEnabled(this.config)) {
            return;
        }
        try {
            HoodieTimelineArchiver archiver = new HoodieTimelineArchiver(this.config, table);
            archiver.archiveIfRequired(this.context, true);
        }
        catch (IOException ioe) {
            throw new HoodieIOException("Failed to archive", ioe);
        }
    }

    private HoodieTimeline getInflightTimelineExcludeCompactionAndClustering(HoodieTableMetaClient metaClient) {
        HoodieTimeline inflightTimelineWithReplaceCommit = metaClient.getCommitsTimeline().filterPendingExcludingCompaction();
        HoodieTimeline inflightTimelineExcludeClusteringCommit = inflightTimelineWithReplaceCommit.filter(instant -> {
            if (instant.getAction().equals("replacecommit")) {
                Option<Pair<HoodieInstant, HoodieClusteringPlan>> instantPlan = ClusteringUtils.getClusteringPlan(metaClient, instant);
                return !instantPlan.isPresent();
            }
            return true;
        });
        return inflightTimelineExcludeClusteringCommit;
    }

    protected Option<HoodiePendingRollbackInfo> getPendingRollbackInfo(HoodieTableMetaClient metaClient, String commitToRollback) {
        return this.getPendingRollbackInfo(metaClient, commitToRollback, true);
    }

    public Option<HoodiePendingRollbackInfo> getPendingRollbackInfo(HoodieTableMetaClient metaClient, String commitToRollback, boolean ignoreCompactionAndClusteringInstants) {
        return this.getPendingRollbackInfos(metaClient, ignoreCompactionAndClusteringInstants).getOrDefault(commitToRollback, Option.empty());
    }

    protected Map<String, Option<HoodiePendingRollbackInfo>> getPendingRollbackInfos(HoodieTableMetaClient metaClient) {
        return this.getPendingRollbackInfos(metaClient, true);
    }

    protected Map<String, Option<HoodiePendingRollbackInfo>> getPendingRollbackInfos(HoodieTableMetaClient metaClient, boolean ignoreCompactionAndClusteringInstants) {
        List<HoodieInstant> instants = metaClient.getActiveTimeline().filterPendingRollbackTimeline().getInstants();
        HashMap<String, Option<HoodiePendingRollbackInfo>> infoMap = new HashMap<String, Option<HoodiePendingRollbackInfo>>();
        for (HoodieInstant rollbackInstant : instants) {
            HoodieRollbackPlan rollbackPlan;
            try {
                rollbackPlan = RollbackUtils.getRollbackPlan(metaClient, rollbackInstant);
            }
            catch (Exception e) {
                if (rollbackInstant.isRequested()) {
                    LOG.warn("Fetching rollback plan failed for " + rollbackInstant + ", deleting the plan since it's in REQUESTED state", (Throwable)e);
                    try {
                        metaClient.getActiveTimeline().deletePending(rollbackInstant);
                    }
                    catch (HoodieIOException he) {
                        LOG.warn("Cannot delete " + rollbackInstant, (Throwable)he);
                    }
                    continue;
                }
                LOG.warn("Fetching rollback plan failed for " + rollbackInstant + ", skip the plan", (Throwable)e);
                continue;
            }
            try {
                String action = rollbackPlan.getInstantToRollback().getAction();
                String instantToRollback = rollbackPlan.getInstantToRollback().getCommitTime();
                if (ignoreCompactionAndClusteringInstants) {
                    boolean isClustering;
                    if ("compaction".equals(action) || (isClustering = "replacecommit".equals(action) && ClusteringUtils.getClusteringPlan(metaClient, new HoodieInstant(true, action, instantToRollback)).isPresent())) continue;
                    infoMap.putIfAbsent(instantToRollback, Option.of(new HoodiePendingRollbackInfo(rollbackInstant, rollbackPlan)));
                    continue;
                }
                infoMap.putIfAbsent(instantToRollback, Option.of(new HoodiePendingRollbackInfo(rollbackInstant, rollbackPlan)));
            }
            catch (Exception e) {
                LOG.warn("Processing rollback plan failed for " + rollbackInstant + ", skip the plan", (Throwable)e);
            }
        }
        return infoMap;
    }

    protected boolean rollbackFailedIndexingCommits() {
        HoodieTable<?, I, ?, T> table = this.createTable(this.config, this.hadoopConf);
        List<String> instantsToRollback = this.getFailedIndexingCommitsToRollback(table.getMetaClient());
        Map<String, Option<HoodiePendingRollbackInfo>> pendingRollbacks = this.getPendingRollbackInfos(table.getMetaClient());
        instantsToRollback.forEach(entry -> pendingRollbacks.putIfAbsent((String)entry, Option.empty()));
        this.rollbackFailedWrites(pendingRollbacks);
        return !pendingRollbacks.isEmpty();
    }

    protected List<String> getFailedIndexingCommitsToRollback(HoodieTableMetaClient metaClient) {
        Stream<HoodieInstant> inflightInstantsStream = metaClient.getCommitsTimeline().filter(instant -> !instant.isCompleted() && HoodieTableMetadataUtil.isIndexingCommit(instant.getTimestamp())).getInstantsAsStream();
        return inflightInstantsStream.filter(instant -> {
            try {
                return this.heartbeatClient.isHeartbeatExpired(instant.getTimestamp());
            }
            catch (IOException io) {
                throw new HoodieException("Failed to check heartbeat for instant " + instant, io);
            }
        }).map(HoodieInstant::getTimestamp).collect(Collectors.toList());
    }

    protected Boolean rollbackFailedWrites() {
        HoodieTable<?, I, ?, T> table = this.createTable(this.config, this.hadoopConf);
        List<String> instantsToRollback = this.getInstantsToRollback(table.getMetaClient(), this.config.getFailedWritesCleanPolicy(), Option.empty());
        Map<String, Option<HoodiePendingRollbackInfo>> pendingRollbacks = this.getPendingRollbackInfos(table.getMetaClient());
        instantsToRollback.forEach(entry -> pendingRollbacks.putIfAbsent((String)entry, Option.empty()));
        this.rollbackFailedWrites(pendingRollbacks);
        return !pendingRollbacks.isEmpty();
    }

    protected void rollbackFailedWrites(Map<String, Option<HoodiePendingRollbackInfo>> instantsToRollback) {
        this.rollbackFailedWrites(instantsToRollback, false);
    }

    protected void rollbackFailedWrites(Map<String, Option<HoodiePendingRollbackInfo>> instantsToRollback, boolean skipLocking) {
        LinkedHashMap reverseSortedRollbackInstants = instantsToRollback.entrySet().stream().sorted((i1, i2) -> ((String)i2.getKey()).compareTo((String)i1.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        boolean isMetadataTable = HoodieTableMetadata.isMetadataTable(this.basePath);
        for (Map.Entry entry : reverseSortedRollbackInstants.entrySet()) {
            if (!isMetadataTable && HoodieTimeline.compareTimestamps((String)entry.getKey(), HoodieTimeline.LESSER_THAN_OR_EQUALS, "00000000000002")) {
                this.rollbackFailedBootstrap();
                HeartbeatUtils.deleteHeartbeatFile(this.fs, this.basePath, (String)entry.getKey(), this.config);
                break;
            }
            this.rollback((String)entry.getKey(), (Option)entry.getValue(), skipLocking);
            HeartbeatUtils.deleteHeartbeatFile(this.fs, this.basePath, (String)entry.getKey(), this.config);
        }
    }

    protected List<String> getInstantsToRollback(HoodieTableMetaClient metaClient, HoodieFailedWritesCleaningPolicy cleaningPolicy, Option<String> curInstantTime) {
        Stream<HoodieInstant> inflightInstantsStream = this.getInflightTimelineExcludeCompactionAndClustering(metaClient).getReverseOrderedInstants();
        if (cleaningPolicy.isEager()) {
            if (HoodieTableMetadata.isMetadataTable(metaClient.getBasePathV2().toString())) {
                return inflightInstantsStream.map(HoodieInstant::getTimestamp).filter(entry -> {
                    if (curInstantTime.isPresent()) {
                        return !entry.equals(curInstantTime.get());
                    }
                    return !HoodieTableMetadataUtil.isIndexingCommit(entry);
                }).collect(Collectors.toList());
            }
            return inflightInstantsStream.map(HoodieInstant::getTimestamp).filter(entry -> {
                if (curInstantTime.isPresent()) {
                    return !entry.equals(curInstantTime.get());
                }
                return true;
            }).collect(Collectors.toList());
        }
        if (cleaningPolicy.isLazy()) {
            return this.getInstantsToRollbackForLazyCleanPolicy(metaClient, inflightInstantsStream);
        }
        if (cleaningPolicy.isNever()) {
            return Collections.emptyList();
        }
        throw new IllegalArgumentException("Invalid Failed Writes Cleaning Policy " + (Object)((Object)this.config.getFailedWritesCleanPolicy()));
    }

    private List<String> getInstantsToRollbackForLazyCleanPolicy(HoodieTableMetaClient metaClient, Stream<HoodieInstant> inflightInstantsStream) {
        List expiredInstants = inflightInstantsStream.filter(instant -> {
            try {
                return this.heartbeatClient.isHeartbeatExpired(instant.getTimestamp());
            }
            catch (IOException io) {
                throw new HoodieException("Failed to check heartbeat for instant " + instant, io);
            }
        }).map(HoodieInstant::getTimestamp).collect(Collectors.toList());
        if (!expiredInstants.isEmpty()) {
            metaClient.reloadActiveTimeline();
            HoodieTimeline refreshedInflightTimeline = this.getInflightTimelineExcludeCompactionAndClustering(metaClient);
            return expiredInstants.stream().filter(refreshedInflightTimeline::containsInstant).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Deprecated
    public boolean rollback(String commitInstantTime, Option<HoodiePendingRollbackInfo> pendingRollbackInfo, boolean skipLocking) throws HoodieRollbackException {
        String rollbackInstantTime = pendingRollbackInfo.map(entry -> entry.getRollbackInstant().getTimestamp()).orElse(HoodieActiveTimeline.createNewInstantTime());
        return this.rollback(commitInstantTime, pendingRollbackInfo, rollbackInstantTime, skipLocking);
    }

    @Deprecated
    public boolean rollback(String commitInstantTime, Option<HoodiePendingRollbackInfo> pendingRollbackInfo, String rollbackInstantTime, boolean skipLocking) throws HoodieRollbackException {
        LOG.info("Begin rollback of instant " + commitInstantTime);
        Timer.Context timerContext = this.metrics.getRollbackCtx();
        try {
            HoodieTable<?, I, ?, T> table = this.createTable(this.config, this.hadoopConf);
            Option<HoodieInstant> commitInstantOpt = Option.fromJavaOptional(table.getActiveTimeline().getCommitsTimeline().getInstantsAsStream().filter(instant -> HoodieActiveTimeline.EQUALS.test(instant.getTimestamp(), commitInstantTime)).findFirst());
            if (commitInstantOpt.isPresent() || pendingRollbackInfo.isPresent()) {
                LOG.info(String.format("Scheduling Rollback at instant time : %s (exists in active timeline: %s), with rollback plan: %s", rollbackInstantTime, commitInstantOpt.isPresent(), pendingRollbackInfo.isPresent()));
                Option rollbackPlanOption = pendingRollbackInfo.map(entry -> Option.of(entry.getRollbackPlan())).orElseGet(() -> table.scheduleRollback(this.context, rollbackInstantTime, (HoodieInstant)commitInstantOpt.get(), false, this.config.shouldRollbackUsingMarkers(), false));
                if (rollbackPlanOption.isPresent()) {
                    HoodieRollbackMetadata rollbackMetadata;
                    HoodieRollbackMetadata hoodieRollbackMetadata = rollbackMetadata = commitInstantOpt.isPresent() ? table.rollback(this.context, rollbackInstantTime, commitInstantOpt.get(), true, skipLocking) : table.rollback(this.context, rollbackInstantTime, new HoodieInstant(true, ((HoodieRollbackPlan)((Object)rollbackPlanOption.get())).getInstantToRollback().getAction(), commitInstantTime), false, skipLocking);
                    if (timerContext != null) {
                        long durationInMs = this.metrics.getDurationInMs(timerContext.stop());
                        this.metrics.updateRollbackMetrics(durationInMs, rollbackMetadata.getTotalFilesDeleted().intValue());
                    }
                    return true;
                }
                throw new HoodieRollbackException("Failed to rollback " + this.config.getBasePath() + " commits " + commitInstantTime);
            }
            LOG.warn("Cannot find instant " + commitInstantTime + " in the timeline, for rollback");
            return false;
        }
        catch (Exception e) {
            throw new HoodieRollbackException("Failed to rollback " + this.config.getBasePath() + " commits " + commitInstantTime, e);
        }
    }

    public void rollbackFailedBootstrap() {
        LOG.info("Rolling back pending bootstrap if present");
        HoodieTable<?, I, ?, T> table = this.createTable(this.config, this.hadoopConf);
        HoodieTimeline inflightTimeline = table.getMetaClient().getCommitsTimeline().filterPendingExcludingMajorAndMinorCompaction();
        Option<String> instant = Option.fromJavaOptional(inflightTimeline.getReverseOrderedInstants().map(HoodieInstant::getTimestamp).findFirst());
        if (instant.isPresent() && HoodieTimeline.compareTimestamps(instant.get(), HoodieTimeline.LESSER_THAN_OR_EQUALS, "00000000000002")) {
            LOG.info("Found pending bootstrap instants. Rolling them back");
            table.rollbackBootstrap(this.context, HoodieActiveTimeline.createNewInstantTime());
            LOG.info("Finished rolling back pending bootstrap");
        }
    }

    protected boolean isPreCommitRequired() {
        return this.config.getWriteConflictResolutionStrategy().isPreCommitRequired();
    }

    private Option<String> delegateToTableServiceManager(TableServiceType tableServiceType, HoodieTable table) {
        if (!this.config.getTableServiceManagerConfig().isEnabledAndActionSupported(ActionType.compaction)) {
            return Option.empty();
        }
        HoodieTableServiceManagerClient tableServiceManagerClient = new HoodieTableServiceManagerClient(table.getMetaClient(), this.config.getTableServiceManagerConfig());
        switch (tableServiceType) {
            case COMPACT: {
                return tableServiceManagerClient.executeCompaction();
            }
            case CLUSTER: {
                return tableServiceManagerClient.executeClustering();
            }
            case CLEAN: {
                return tableServiceManagerClient.executeClean();
            }
        }
        LOG.info("Not supported delegate to table service manager, tableServiceType : " + tableServiceType.getAction());
        return Option.empty();
    }

    @Override
    public void close() {
        AsyncArchiveService.forceShutdown(this.asyncArchiveService);
        this.asyncArchiveService = null;
        AsyncCleanerService.forceShutdown(this.asyncCleanerService);
        this.asyncCleanerService = null;
        super.close();
    }

    protected void handleWriteErrors(List<HoodieWriteStat> writeStats, TableServiceType tableServiceType) {
        if (writeStats.stream().mapToLong(HoodieWriteStat::getTotalWriteErrors).sum() > 0L) {
            String message = (Object)((Object)tableServiceType) + " failed to write to files:" + writeStats.stream().filter(s -> s.getTotalWriteErrors() > 0L).map(HoodieWriteStat::getFileId).collect(Collectors.joining(","));
            switch (tableServiceType) {
                case CLUSTER: {
                    throw new HoodieClusteringException(message);
                }
                case LOG_COMPACT: {
                    throw new HoodieLogCompactException(message);
                }
                case COMPACT: {
                    throw new HoodieCompactionException(message);
                }
            }
            throw new HoodieException(message);
        }
    }
}

