/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.common;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.client.common.JavaTaskContextSupplier;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.data.HoodieAccumulator;
import org.apache.hudi.common.data.HoodieAtomicLongAccumulator;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodieListData;
import org.apache.hudi.common.engine.EngineProperty;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.function.FunctionWrapper;
import org.apache.hudi.common.function.SerializableBiFunction;
import org.apache.hudi.common.function.SerializableConsumer;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.function.SerializablePairFlatMapFunction;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.common.util.collection.Pair;

public class HoodieJavaEngineContext
extends HoodieEngineContext {
    public HoodieJavaEngineContext(Configuration conf) {
        this(conf, (TaskContextSupplier)new JavaTaskContextSupplier());
    }

    public HoodieJavaEngineContext(Configuration conf, TaskContextSupplier taskContextSupplier) {
        super(new SerializableConfiguration(conf), taskContextSupplier);
    }

    @Override
    public HoodieAccumulator newAccumulator() {
        return HoodieAtomicLongAccumulator.create();
    }

    @Override
    public <T> HoodieData<T> emptyHoodieData() {
        return HoodieListData.eager(Collections.emptyList());
    }

    @Override
    public <T> HoodieData<T> parallelize(List<T> data, int parallelism) {
        return HoodieListData.eager(data);
    }

    @Override
    public <I, O> List<O> map(List<I> data, SerializableFunction<I, O> func, int parallelism) {
        return ((Stream)data.stream().parallel()).map(FunctionWrapper.throwingMapWrapper(func)).collect(Collectors.toList());
    }

    @Override
    public <I, K, V> List<V> mapToPairAndReduceByKey(List<I> data, SerializablePairFunction<I, K, V> mapToPairFunc, SerializableBiFunction<V, V, V> reduceFunc, int parallelism) {
        return ((Stream)data.stream().parallel()).map(FunctionWrapper.throwingMapToPairWrapper(mapToPairFunc)).collect(Collectors.groupingBy(p -> p.getKey())).values().stream().map(list -> list.stream().map(e -> e.getValue()).reduce(FunctionWrapper.throwingReduceWrapper(reduceFunc)).get()).collect(Collectors.toList());
    }

    @Override
    public <I, K, V> Stream<ImmutablePair<K, V>> mapPartitionsToPairAndReduceByKey(Stream<I> data, SerializablePairFlatMapFunction<Iterator<I>, K, V> flatMapToPairFunc, SerializableBiFunction<V, V, V> reduceFunc, int parallelism) {
        return FunctionWrapper.throwingFlatMapToPairWrapper(flatMapToPairFunc).apply(((Stream)data.parallel()).iterator()).collect(Collectors.groupingBy(Pair::getKey)).entrySet().stream().map(entry -> new ImmutablePair(entry.getKey(), ((List)entry.getValue()).stream().map(Pair::getValue).reduce(FunctionWrapper.throwingReduceWrapper(reduceFunc)).orElse(null))).filter(Objects::nonNull);
    }

    @Override
    public <I, K, V> List<V> reduceByKey(List<Pair<K, V>> data, SerializableBiFunction<V, V, V> reduceFunc, int parallelism) {
        return ((Stream)data.stream().parallel()).collect(Collectors.groupingBy(p -> p.getKey())).values().stream().map(list -> list.stream().map(e -> e.getValue()).reduce(FunctionWrapper.throwingReduceWrapper(reduceFunc)).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public <I, O> List<O> flatMap(List<I> data, SerializableFunction<I, Stream<O>> func, int parallelism) {
        return ((Stream)data.stream().parallel()).flatMap(FunctionWrapper.throwingFlatMapWrapper(func)).collect(Collectors.toList());
    }

    @Override
    public <I> void foreach(List<I> data, SerializableConsumer<I> consumer, int parallelism) {
        data.stream().forEach(FunctionWrapper.throwingForeachWrapper(consumer));
    }

    @Override
    public <I, K, V> Map<K, V> mapToPair(List<I> data, SerializablePairFunction<I, K, V> func, Integer parallelism) {
        return data.stream().map(FunctionWrapper.throwingMapToPairWrapper(func)).collect(Collectors.toMap(Pair::getLeft, Pair::getRight, (oldVal, newVal) -> newVal));
    }

    @Override
    public void setProperty(EngineProperty key, String value) {
    }

    @Override
    public Option<String> getProperty(EngineProperty key) {
        return Option.empty();
    }

    @Override
    public void setJobStatus(String activeModule, String activityDescription) {
    }

    @Override
    public void putCachedDataIds(HoodieData.HoodieDataCacheKey cacheKey, int ... ids) {
    }

    @Override
    public List<Integer> getCachedDataIds(HoodieData.HoodieDataCacheKey cacheKey) {
        return Collections.emptyList();
    }

    @Override
    public List<Integer> removeCachedDataIds(HoodieData.HoodieDataCacheKey cacheKey) {
        return Collections.emptyList();
    }

    @Override
    public void cancelJob(String jobId) {
    }

    @Override
    public void cancelAllJobs() {
    }
}

