/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.fs;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;

@ConfigClassProperty(name="FileSystem Guard Configurations", groupName=ConfigGroups.Names.WRITE_CLIENT, description="The filesystem retry related config options, to help deal with runtime exception like list/get/put/delete performance issues.")
public class FileSystemRetryConfig
extends HoodieConfig {
    public static final ConfigProperty<String> FILESYSTEM_RETRY_ENABLE = ConfigProperty.key("hoodie.filesystem.operation.retry.enable").defaultValue("false").markAdvanced().sinceVersion("0.11.0").withDocumentation("Enabled to handle list/get/delete etc file system performance issue.");
    public static final ConfigProperty<Long> INITIAL_RETRY_INTERVAL_MS = ConfigProperty.key("hoodie.filesystem.operation.retry.initial_interval_ms").defaultValue(100L).markAdvanced().sinceVersion("0.11.0").withDocumentation("Amount of time (in ms) to wait, before retry to do operations on storage.");
    public static final ConfigProperty<Long> MAX_RETRY_INTERVAL_MS = ConfigProperty.key("hoodie.filesystem.operation.retry.max_interval_ms").defaultValue(2000L).markAdvanced().sinceVersion("0.11.0").withDocumentation("Maximum amount of time (in ms), to wait for next retry.");
    public static final ConfigProperty<Integer> MAX_RETRY_NUMBERS = ConfigProperty.key("hoodie.filesystem.operation.retry.max_numbers").defaultValue(4).markAdvanced().sinceVersion("0.11.0").withDocumentation("Maximum number of retry actions to perform, with exponential backoff.");
    public static final ConfigProperty<String> RETRY_EXCEPTIONS = ConfigProperty.key("hoodie.filesystem.operation.retry.exceptions").defaultValue("").markAdvanced().sinceVersion("0.11.0").withDocumentation("The class name of the Exception that needs to be retried, separated by commas. Default is empty which means retry all the IOException and RuntimeException from FileSystem");

    private FileSystemRetryConfig() {
    }

    public long getInitialRetryIntervalMs() {
        return this.getLong(INITIAL_RETRY_INTERVAL_MS);
    }

    public long getMaxRetryIntervalMs() {
        return this.getLong(MAX_RETRY_INTERVAL_MS);
    }

    public int getMaxRetryNumbers() {
        return this.getInt(MAX_RETRY_NUMBERS);
    }

    public boolean isFileSystemActionRetryEnable() {
        return Boolean.parseBoolean(this.getStringOrDefault(FILESYSTEM_RETRY_ENABLE));
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getRetryExceptions() {
        return this.getString(RETRY_EXCEPTIONS);
    }

    public static class Builder {
        private final FileSystemRetryConfig fileSystemRetryConfig = new FileSystemRetryConfig();

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.fileSystemRetryConfig.getProps().load(reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder fromProperties(Properties props) {
            this.fileSystemRetryConfig.getProps().putAll((Map<?, ?>)props);
            return this;
        }

        public Builder withMaxRetryNumbers(int numbers) {
            this.fileSystemRetryConfig.setValue(MAX_RETRY_NUMBERS, String.valueOf(numbers));
            return this;
        }

        public Builder withInitialRetryIntervalMs(long intervalMs) {
            this.fileSystemRetryConfig.setValue(INITIAL_RETRY_INTERVAL_MS, String.valueOf(intervalMs));
            return this;
        }

        public Builder withMaxRetryIntervalMs(long intervalMs) {
            this.fileSystemRetryConfig.setValue(MAX_RETRY_INTERVAL_MS, String.valueOf(intervalMs));
            return this;
        }

        public Builder withFileSystemActionRetryEnabled(boolean enabled) {
            this.fileSystemRetryConfig.setValue(FILESYSTEM_RETRY_ENABLE, String.valueOf(enabled));
            return this;
        }

        public FileSystemRetryConfig build() {
            this.fileSystemRetryConfig.setDefaults(FileSystemRetryConfig.class.getName());
            return this.fileSystemRetryConfig;
        }
    }
}

