/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.fs;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;

public class SizeAwareDataOutputStream {
    private DataOutputStream outputStream;
    private AtomicLong size;

    public SizeAwareDataOutputStream(FileOutputStream fileOutputStream, int cacheSize) {
        this.outputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream, cacheSize));
        this.size = new AtomicLong(0L);
    }

    public void writeLong(long v) throws IOException {
        this.size.addAndGet(8L);
        this.outputStream.writeLong(v);
    }

    public void writeInt(int v) throws IOException {
        this.size.addAndGet(4L);
        this.outputStream.writeInt(v);
    }

    public void write(byte[] v) throws IOException {
        this.size.addAndGet(v.length);
        this.outputStream.write(v);
    }

    public void write(byte[] v, int offset, int len) throws IOException {
        this.size.addAndGet(len + offset);
        this.outputStream.write(v, offset, len);
    }

    public void flush() throws IOException {
        this.outputStream.flush();
    }

    public void close() throws IOException {
        this.outputStream.close();
    }

    public long getSize() {
        return this.size.get();
    }
}

