/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.fs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.ConsistencyGuard;
import org.apache.hudi.common.fs.HoodieWrapperFileSystem;
import org.apache.hudi.exception.HoodieException;

public class SizeAwareFSDataOutputStream
extends FSDataOutputStream {
    private final Runnable closeCallback;
    private final AtomicLong bytesWritten = new AtomicLong(0L);
    private final Path path;
    private final ConsistencyGuard consistencyGuard;

    public SizeAwareFSDataOutputStream(Path path, FSDataOutputStream out, ConsistencyGuard consistencyGuard, Runnable closeCallback) throws IOException {
        super((OutputStream)out, null, out.getPos());
        this.path = path;
        this.closeCallback = closeCallback;
        this.consistencyGuard = consistencyGuard;
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        HoodieWrapperFileSystem.executeFuncWithTimeAndByteMetrics(HoodieWrapperFileSystem.MetricName.write.name(), this.path, len, () -> {
            this.bytesWritten.addAndGet(len);
            super.write(b, off, len);
            return null;
        });
    }

    public void write(byte[] b) throws IOException {
        HoodieWrapperFileSystem.executeFuncWithTimeAndByteMetrics(HoodieWrapperFileSystem.MetricName.write.name(), this.path, b.length, () -> {
            this.bytesWritten.addAndGet(b.length);
            super.write(b);
            return null;
        });
    }

    public void close() throws IOException {
        super.close();
        try {
            this.consistencyGuard.waitTillFileAppears(this.path);
        }
        catch (TimeoutException e) {
            throw new HoodieException(e);
        }
        this.closeCallback.run();
    }

    public long getBytesWritten() {
        return this.bytesWritten.get();
    }
}

