/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import java.util.regex.Matcher;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.exception.InvalidHoodiePathException;
import org.apache.hudi.hadoop.CachingPath;

public class HoodieLogFile
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DELTA_EXTENSION = ".log";
    public static final String LOG_FILE_PREFIX = ".";
    public static final Integer LOGFILE_BASE_VERSION = 1;
    private static final Comparator<HoodieLogFile> LOG_FILE_COMPARATOR = new LogFileComparator();
    private static final Comparator<HoodieLogFile> LOG_FILE_COMPARATOR_REVERSED = new LogFileComparator().reversed();
    private transient FileStatus fileStatus;
    private transient Path path;
    private final String pathStr;
    private String fileId;
    private String baseCommitTime;
    private int logVersion;
    private String logWriteToken;
    private String fileExtension;
    private String suffix;
    private long fileLen;

    public HoodieLogFile(HoodieLogFile logFile) {
        this.fileStatus = logFile.getFileStatus();
        this.path = logFile.getPath();
        this.pathStr = logFile.pathStr;
        this.fileId = logFile.getFileId();
        this.baseCommitTime = logFile.getBaseCommitTime();
        this.logVersion = logFile.getLogVersion();
        this.logWriteToken = logFile.getLogWriteToken();
        this.fileExtension = logFile.getFileExtension();
        this.suffix = logFile.getSuffix();
        this.fileLen = logFile.getFileSize();
    }

    public HoodieLogFile(FileStatus fileStatus) {
        this(fileStatus, fileStatus.getPath(), fileStatus.getPath().toString(), fileStatus.getLen());
    }

    public HoodieLogFile(Path logPath) {
        this(null, logPath, logPath.toString(), -1L);
    }

    public HoodieLogFile(Path logPath, long fileLen) {
        this(null, logPath, logPath.toString(), fileLen);
    }

    public HoodieLogFile(String logPathStr) {
        this(null, null, logPathStr, -1L);
    }

    private HoodieLogFile(FileStatus fileStatus, Path logPath, String logPathStr, long fileLen) {
        this.fileStatus = fileStatus;
        this.pathStr = logPathStr;
        this.fileLen = fileLen;
        this.logVersion = -1;
        if (logPath instanceof CachingPath) {
            this.path = logPath;
        }
    }

    private void parseFieldsFromPath() {
        Matcher matcher = FSUtils.LOG_FILE_PATTERN.matcher(this.getPath().getName());
        if (!matcher.find()) {
            throw new InvalidHoodiePathException(this.path, "LogFile");
        }
        this.fileId = matcher.group(1);
        this.baseCommitTime = matcher.group(2);
        this.fileExtension = matcher.group(3);
        this.logVersion = Integer.parseInt(matcher.group(4));
        this.logWriteToken = matcher.group(6);
        this.suffix = matcher.group(10) == null ? "" : matcher.group(10);
    }

    public String getFileId() {
        if (this.fileId == null) {
            this.parseFieldsFromPath();
        }
        return this.fileId;
    }

    public String getBaseCommitTime() {
        if (this.baseCommitTime == null) {
            this.parseFieldsFromPath();
        }
        return this.baseCommitTime;
    }

    public int getLogVersion() {
        if (this.logVersion == -1) {
            this.parseFieldsFromPath();
        }
        return this.logVersion;
    }

    public String getLogWriteToken() {
        if (this.logWriteToken == null) {
            this.parseFieldsFromPath();
        }
        return this.logWriteToken;
    }

    public String getFileExtension() {
        if (this.fileExtension == null) {
            this.parseFieldsFromPath();
        }
        return this.fileExtension;
    }

    public String getSuffix() {
        if (this.suffix == null) {
            this.parseFieldsFromPath();
        }
        return this.suffix;
    }

    public Path getPath() {
        if (this.path == null) {
            this.path = new CachingPath(this.pathStr);
        }
        return this.path;
    }

    public String getFileName() {
        return this.getPath().getName();
    }

    public void setFileLen(long fileLen) {
        this.fileLen = fileLen;
    }

    public long getFileSize() {
        return this.fileLen;
    }

    public FileStatus getFileStatus() {
        return this.fileStatus;
    }

    public void setFileStatus(FileStatus fileStatus) {
        this.fileStatus = fileStatus;
    }

    public HoodieLogFile rollOver(FileSystem fs, String logWriteToken) throws IOException {
        String fileId = this.getFileId();
        String baseCommitTime = this.getBaseCommitTime();
        Path path = this.getPath();
        String extension = LOG_FILE_PREFIX + this.fileExtension;
        int newVersion = FSUtils.computeNextLogVersion(fs, path.getParent(), fileId, extension, baseCommitTime);
        return new HoodieLogFile(new CachingPath(path.getParent(), FSUtils.makeLogFileName(fileId, extension, baseCommitTime, newVersion, logWriteToken)));
    }

    public static Comparator<HoodieLogFile> getLogFileComparator() {
        return LOG_FILE_COMPARATOR;
    }

    public static Comparator<HoodieLogFile> getReverseLogFileComparator() {
        return LOG_FILE_COMPARATOR_REVERSED;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HoodieLogFile that = (HoodieLogFile)o;
        return Objects.equals(this.pathStr, that.pathStr);
    }

    public int hashCode() {
        return Objects.hash(this.pathStr);
    }

    public String toString() {
        return "HoodieLogFile{pathStr='" + this.pathStr + '\'' + ", fileLen=" + this.fileLen + '}';
    }

    public static class LogFileComparator
    implements Comparator<HoodieLogFile>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private transient Comparator<String> writeTokenComparator;

        private Comparator<String> getWriteTokenComparator() {
            if (null == this.writeTokenComparator) {
                this.writeTokenComparator = Comparator.nullsFirst(Comparator.naturalOrder());
            }
            return this.writeTokenComparator;
        }

        @Override
        public int compare(HoodieLogFile o1, HoodieLogFile o2) {
            String baseInstantTime2;
            String baseInstantTime1 = o1.getBaseCommitTime();
            if (baseInstantTime1.equals(baseInstantTime2 = o2.getBaseCommitTime())) {
                if (o1.getLogVersion() == o2.getLogVersion()) {
                    int compareWriteToken = this.getWriteTokenComparator().compare(o1.getLogWriteToken(), o2.getLogWriteToken());
                    if (compareWriteToken == 0) {
                        return o1.getSuffix().compareTo(o2.getSuffix());
                    }
                    return compareWriteToken;
                }
                return Integer.compare(o1.getLogVersion(), o2.getLogVersion());
            }
            return baseInstantTime1.compareTo(baseInstantTime2);
        }
    }
}

