/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieAvroRecordMerger;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;

public class HoodiePreCombineAvroRecordMerger
extends HoodieAvroRecordMerger {
    public static final HoodiePreCombineAvroRecordMerger INSTANCE = new HoodiePreCombineAvroRecordMerger();

    @Override
    public Option<Pair<HoodieRecord, Schema>> merge(HoodieRecord older, Schema oldSchema, HoodieRecord newer, Schema newSchema, TypedProperties props) throws IOException {
        return Option.of(this.preCombine(older, oldSchema, newer, newSchema, props));
    }

    private Pair<HoodieRecord, Schema> preCombine(HoodieRecord older, Schema oldSchema, HoodieRecord newer, Schema newSchema, TypedProperties props) {
        Object olderPayload;
        Object newerPayload = ((HoodieAvroRecord)newer).getData();
        Object payload = newerPayload.preCombine(olderPayload = ((HoodieAvroRecord)older).getData(), newSchema, props);
        if (payload == olderPayload) {
            return Pair.of(older, oldSchema);
        }
        if (payload == newerPayload) {
            return Pair.of(newer, newSchema);
        }
        HoodieAvroRecord<Object> mergedRecord = new HoodieAvroRecord<Object>(newer.getKey(), payload, newer.getOperation());
        return Pair.of(mergedRecord, newSchema);
    }
}

