/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.util.Option;

public class OverwriteNonDefaultsWithLatestAvroPayload
extends OverwriteWithLatestAvroPayload {
    public OverwriteNonDefaultsWithLatestAvroPayload(GenericRecord record, Comparable orderingVal) {
        super(record, orderingVal);
    }

    public OverwriteNonDefaultsWithLatestAvroPayload(Option<GenericRecord> record) {
        super(record);
    }

    @Override
    public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord currentValue, Schema schema) throws IOException {
        Option<IndexedRecord> recordOption = this.getInsertValue(schema);
        if (!recordOption.isPresent()) {
            return Option.empty();
        }
        GenericRecord insertRecord = (GenericRecord)recordOption.get();
        GenericRecord currentRecord = (GenericRecord)currentValue;
        return this.mergeRecords(schema, insertRecord, currentRecord);
    }

    protected Option<IndexedRecord> mergeRecords(Schema schema, GenericRecord baseRecord, GenericRecord mergedRecord) {
        if (this.isDeleteRecord(baseRecord)) {
            return Option.empty();
        }
        GenericRecordBuilder builder = new GenericRecordBuilder(schema);
        List fields = schema.getFields();
        fields.forEach(field2 -> this.setField(baseRecord, mergedRecord, builder, (Schema.Field)field2));
        return Option.of(builder.build());
    }

    protected void setField(GenericRecord baseRecord, GenericRecord mergedRecord, GenericRecordBuilder builder, Schema.Field field2) {
        Object defaultValue;
        Object value = baseRecord.get(field2.name());
        value = field2.schema().getType().equals((Object)Schema.Type.STRING) && value != null ? value.toString() : value;
        if (!this.overwriteField(value, defaultValue = field2.defaultVal()).booleanValue()) {
            builder.set(field2, value);
        } else {
            builder.set(field2, mergedRecord.get(field2.name()));
        }
    }
}

